/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Absent
extends Optional<Object> {
    static final Absent INSTANCE = new Absent();
    private static final long serialVersionUID = 0L;

    Absent() {
    }

    @Override
    public final boolean isPresent() {
        return false;
    }

    @Override
    public final Object get() {
        throw new IllegalStateException("value is absent");
    }

    @Override
    public final Object or(Object object) {
        return Preconditions.checkNotNull(object, "use orNull() instead of or(null)");
    }

    @Override
    public final Optional<Object> or(Optional<?> optional) {
        return Preconditions.checkNotNull(optional);
    }

    @Override
    public final Object or(Supplier<?> supplier) {
        return Preconditions.checkNotNull(supplier.get(), "use orNull() instead of a Supplier that returns null");
    }

    @Override
    public final Object orNull() {
        return null;
    }

    @Override
    public final Set<Object> asSet() {
        return Collections.emptySet();
    }

    @Override
    public final <V> Optional<V> transform(Function<Object, V> function) {
        Preconditions.checkNotNull(function);
        return Optional.absent();
    }

    @Override
    public final boolean equals(Object object) {
        return object == this;
    }

    @Override
    public final int hashCode() {
        return 1502476572;
    }

    @Override
    public final String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

