/*
 * Decompiled with CFR 0.152.
 */
package xyqb.library;

import android.text.TextUtils;
import java.util.ArrayList;
import xyqb.library.XmlAttribute;
import xyqb.library.XmlNameSpace;

public class XmlElement {
    public String name;
    public String text;
    public int level;
    public XmlElement parent;
    private final ArrayList<XmlNameSpace> nameSpaces = new ArrayList();
    private final ArrayList<XmlElement> children = new ArrayList();
    private final ArrayList<XmlAttribute> attributes = new ArrayList();

    public ArrayList<XmlAttribute> getAttributes() {
        return this.attributes;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getNameSpaceCount() {
        return this.nameSpaces.size();
    }

    public ArrayList<XmlNameSpace> getNameSpaces() {
        return this.nameSpaces;
    }

    public XmlNameSpace getNameSpace(int index) {
        XmlNameSpace nameSpace = null;
        int size = this.nameSpaces.size();
        if (-1 < index && index < size) {
            nameSpace = this.nameSpaces.get(index);
        }
        return nameSpace;
    }

    public String getNameSpacePrefix(String url) {
        String prefix = null;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            int size = this.nameSpaces.size();
            for (int i = 0; i < size; ++i) {
                XmlNameSpace nameSpace = this.nameSpaces.get(i);
                if (!url.equals(nameSpace.url)) continue;
                prefix = nameSpace.prefix;
                break;
            }
        }
        return prefix;
    }

    public String getAttributeValue(String name) {
        String value = null;
        if (!TextUtils.isEmpty((CharSequence)name)) {
            int size = this.attributes.size();
            for (int i = 0; i < size; ++i) {
                XmlAttribute attribute = this.attributes.get(i);
                if (!name.equals(attribute.name)) continue;
                value = attribute.value;
                break;
            }
        }
        return value;
    }

    public XmlAttribute getAttribute(int index) {
        XmlAttribute attribute = null;
        int size = this.attributes.size();
        if (-1 < index && index < size) {
            attribute = this.attributes.get(index);
        }
        return attribute;
    }

    public String getAttributeValue(int index) {
        String value = null;
        int size = this.attributes.size();
        if (-1 < index && index < size) {
            value = this.attributes.get((int)index).value;
        }
        return value;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public XmlElement getChild(int index) {
        XmlElement element = null;
        int size = this.children.size();
        if (-1 < index && index < size) {
            element = this.children.get(index);
        }
        return element;
    }

    public ArrayList<XmlElement> getChildren() {
        return this.children;
    }

    public String toString() {
        return super.toString();
    }
}

