package xyqb.library.config;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.IntDef;

import java.io.IOException;
import java.io.InputStream;

import xyqb.library.XmlElement;
import xyqb.library.XmlHelper;


/**
 * Created by cz on 9/20/16.
 */
public abstract class XmlReaderBase<V> {
    public static final int RAW_XML=0;
    public static final int ASSET_XML=1;
    private static Context context;

    static {
        context = getContext();
    }

    @IntDef({RAW_XML,ASSET_XML})
    public @interface PathType{
    }


    public static Context getContext() {
        if (context == null) {
            try {
                Application application=(Application) Class.forName("android.app.ActivityThread").getMethod("currentApplication").invoke(null);
                context = application.getApplicationContext();
            } catch (final Exception e) {
                e.printStackTrace();
            }
        }
        return context;
    }

    private static final int raw(String name) {
        Context context = getContext();
        return context.getResources().getIdentifier(name, "raw", context.getPackageName());
    }

    public XmlElement readXmlElement(@PathType int type, String path) {
        Resources appResource = getContext().getResources();
        InputStream inputStream=null;
        if (ASSET_XML == type) {
            try {
                inputStream = appResource.getAssets().open(path);
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else if (RAW_XML == type) {
            inputStream = appResource.openRawResource(raw(path));
        }
        XmlElement rootElement =null;
        if (null != inputStream) {
            rootElement = XmlHelper.parserStream(inputStream);
        }
        return rootElement;
    }

    public abstract V readXmlConfig(XmlElement rootElement);
}
