package xyqb.library.config;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;

import java.util.HashMap;

import xyqb.library.XmlElement;


/**
 * Created by cz on 9/20/16.
 */
public class PrefsManager {
    private static final HashMap<String,XmlElement> cacheElements;
    private static final HashMap<Class<? extends XmlReaderBase>,XmlReaderBase> readers;

    static {
        cacheElements=new HashMap<>();
        readers=new HashMap<>();
    }

    private static <T extends XmlReaderBase> XmlReaderBase getXmlReader(Class<T> clazz){
        XmlReaderBase reader = readers.get(clazz);
        if(null==reader){
            try {
                reader = clazz.newInstance();
                readers.put(clazz,reader);
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return reader;
    }

    public static<R,T extends XmlReaderBase<R>> R readConfig(Class<T> clazz){
        XmlReaderBase reader = getXmlReader(clazz);
        XmlElement rootElement = readConfigElement(clazz);
        return (R)reader.readXmlConfig(rootElement);
    }


    /**
     * 读取xml配置
     * @param clazz
     */
    public static<T extends XmlReaderBase> XmlElement readConfigElement(Class<T> clazz){
        XmlElement rootElement=null;
        XmlReaderBase reader = getXmlReader(clazz);
        Config config = clazz.getAnnotation(Config.class);
        if(null!=config){
            String path=config.value();
            int type = config.type();
            if(cacheElements.containsKey(path)){
                rootElement = cacheElements.get(path);
            } else {
                rootElement = reader.readXmlElement(type, path);
                cacheElements.put(path,rootElement);
            }
        }
        return rootElement;
    }
}
