/*
 * Decompiled with CFR 0.152.
 */
package xyqb.library.config;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import xyqb.library.XmlElement;
import xyqb.library.XmlHelper;

public abstract class XmlReaderBase<V> {
    public static final int RAW_XML = 0;
    public static final int ASSET_XML = 1;
    private static Context context = XmlReaderBase.getContext();

    public static Context getContext() {
        if (context == null) {
            try {
                Application application = (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, new Object[0]);
                context = application.getApplicationContext();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return context;
    }

    private static final int raw(String name) {
        Context context = XmlReaderBase.getContext();
        return context.getResources().getIdentifier(name, "raw", context.getPackageName());
    }

    public XmlElement readXmlElement(@PathType int type, String path) {
        Resources appResource = XmlReaderBase.getContext().getResources();
        InputStream inputStream = null;
        if (1 == type) {
            try {
                inputStream = appResource.getAssets().open(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (0 == type) {
            inputStream = appResource.openRawResource(XmlReaderBase.raw(path));
        }
        XmlElement rootElement = null;
        if (null != inputStream) {
            try {
                Method method = XmlHelper.class.getDeclaredMethod("parserStream", InputStream.class);
                method.setAccessible(true);
                rootElement = (XmlElement)method.invoke(null, inputStream);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return rootElement;
    }

    public abstract V readXmlConfig(XmlElement var1);

    public static @interface PathType {
    }
}

