/*
 * Decompiled with CFR 0.152.
 */
package xyqb.library.config;

import java.util.HashMap;
import xyqb.library.XmlElement;
import xyqb.library.config.Config;
import xyqb.library.config.XmlReaderBase;

public class PrefsManager {
    private static final HashMap<String, XmlElement> cacheElements = new HashMap();
    private static final HashMap<Class<? extends XmlReaderBase>, XmlReaderBase> readers = new HashMap();

    private static <T extends XmlReaderBase> XmlReaderBase getXmlReader(Class<T> clazz) {
        XmlReaderBase reader = readers.get(clazz);
        if (null == reader) {
            try {
                reader = (XmlReaderBase)clazz.newInstance();
                readers.put(clazz, reader);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return reader;
    }

    public static <R, T extends XmlReaderBase<R>> R readConfig(Class<T> clazz) {
        XmlReaderBase reader = PrefsManager.getXmlReader(clazz);
        XmlElement rootElement = PrefsManager.readConfigElement(clazz);
        return (R)reader.readXmlConfig(rootElement);
    }

    public static <T extends XmlReaderBase> XmlElement readConfigElement(Class<T> clazz) {
        XmlElement rootElement = null;
        XmlReaderBase reader = PrefsManager.getXmlReader(clazz);
        Config config = clazz.getAnnotation(Config.class);
        if (null != config) {
            String path = config.value();
            int type = config.type();
            if (cacheElements.containsKey(path)) {
                rootElement = cacheElements.get(path);
            } else {
                rootElement = reader.readXmlElement(type, path);
                cacheElements.put(path, rootElement);
            }
        }
        return rootElement;
    }
}

