/*
 * Decompiled with CFR 0.152.
 */
package xyqb.xml;

import android.text.TextUtils;
import android.util.Xml;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import xyqb.xml.XmlAttribute;
import xyqb.xml.XmlElement;
import xyqb.xml.XmlNameSpace;

public class XmlHelper {
    private static final String TAG = "XmlHelper";

    public static XmlElement parserText(String text) {
        XmlElement rootElement = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes());
                rootElement = XmlHelper.parserStream(inputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootElement;
    }

    public static XmlElement parserFile(File file) {
        XmlElement rootElement = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            rootElement = XmlHelper.parserStream(fileInputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return rootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlElement parserStream(InputStream inputStream) {
        XmlPullParser parser = Xml.newPullParser();
        ArrayList<String> tags = new ArrayList<String>();
        XmlElement root = null;
        XmlElement element = null;
        try {
            parser.setInput(inputStream, "UTF-8");
            int eventType = parser.getEventType();
            while (eventType != 1) {
                String name = parser.getName();
                switch (eventType) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        String text = parser.getText();
                        if (TextUtils.isEmpty((CharSequence)text.trim())) break;
                        element.text = text;
                        break;
                    }
                    case 2: {
                        XmlElement createElement = XmlHelper.createElement(parser, root, tags);
                        if (null == element) {
                            root = element = createElement;
                        } else if (element.level < createElement.level) {
                            createElement.parent = element;
                            element.getChildren().add(createElement);
                            element = createElement;
                        } else if (element.level == createElement.level) {
                            createElement.parent = element.parent;
                            element.parent.getChildren().add(createElement);
                            element = createElement;
                        } else if (element.level > createElement.level) {
                            XmlElement parent = element.parent;
                            for (int i = createElement.level; i < element.level; ++i) {
                                parent = parent.parent;
                            }
                            parent.getChildren().add(createElement);
                            createElement.parent = parent;
                            element = createElement;
                        }
                        tags.add(name);
                        break;
                    }
                    case 3: {
                        tags.remove(name);
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return root;
    }

    private static ArrayList<XmlNameSpace> getNameSpace(XmlPullParser parser) {
        ArrayList<XmlNameSpace> nameSpaces = new ArrayList<XmlNameSpace>();
        try {
            int namespaceCount = parser.getNamespaceCount(parser.getDepth());
            for (int i = 0; i < namespaceCount; ++i) {
                nameSpaces.add(new XmlNameSpace(parser.getNamespacePrefix(i), parser.getNamespaceUri(i)));
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return nameSpaces;
    }

    public static String formatElement(XmlElement root, boolean spacing) {
        StringBuffer formatValue = new StringBuffer();
        XmlHelper.formatChildElement(root, formatValue, spacing);
        return formatValue.toString();
    }

    private static void formatChildElement(XmlElement element, StringBuffer formatValue, boolean spacing) {
        if (null != element) {
            String end;
            int attributeCount;
            formatValue.append(XmlHelper.getFormatTab(element.level) + "<" + element.name);
            int nameSpaceCount = element.getNameSpaceCount();
            if (0 < nameSpaceCount) {
                for (int i = 0; i < nameSpaceCount; ++i) {
                    XmlNameSpace nameSpace = element.getNameSpace(i);
                    if (0 == i) {
                        formatValue.append(" xmlns:" + nameSpace.prefix + "=\"" + nameSpace.url + "\"\n");
                        continue;
                    }
                    formatValue.append(XmlHelper.getFormatTab(element.level + 1) + "xmlns:" + nameSpace.prefix + "=\"" + nameSpace.url + "\"\n");
                }
            }
            if (0 < (attributeCount = element.getAttributeCount())) {
                for (int i = 0; i < attributeCount; ++i) {
                    String nameSpace;
                    XmlAttribute attribute = element.getAttribute(i);
                    String string = nameSpace = !TextUtils.isEmpty((CharSequence)attribute.nameSpace) ? attribute.nameSpace + ":" : "";
                    if (0 == i) {
                        formatValue.append((0 < nameSpaceCount ? XmlHelper.getFormatTab(element.level + 1) : " ") + nameSpace + attribute.name + "=\"" + attribute.value + "\"" + (1 == attributeCount ? "" : "\n"));
                        continue;
                    }
                    formatValue.append(XmlHelper.getFormatTab(element.level + 1) + nameSpace + attribute.name + "=\"" + attribute.value + "\"" + (attributeCount - 1 != i ? "\n" : ""));
                }
            }
            int childCount = element.getChildCount();
            String string = end = spacing ? "\n\t\n" : "\n";
            if (0 < childCount) {
                formatValue.append(">" + end);
                for (int i = 0; i < childCount; ++i) {
                    XmlHelper.formatChildElement(element.getChild(i), formatValue, spacing);
                }
                formatValue.append(XmlHelper.getFormatTab(element.level) + "</" + element.name + ">" + end);
            } else if (!TextUtils.isEmpty((CharSequence)element.text)) {
                formatValue.append(">" + element.text.trim() + "</" + element.name + ">" + end);
            } else {
                formatValue.append("/>" + end);
            }
        }
    }

    private static final String getFormatTab(int level) {
        String value = "";
        for (int i = 0; i < level; ++i) {
            value = value + "\t";
        }
        return value;
    }

    private static XmlElement createElement(XmlPullParser parser, XmlElement root, ArrayList<String> tags) {
        XmlElement element = new XmlElement();
        element.name = parser.getName();
        element.level = tags.size();
        XmlHelper.addAttribute(element, root, parser);
        return element;
    }

    private static void addAttribute(XmlElement element, XmlElement root, XmlPullParser parser) {
        int attributeCount = parser.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace;
            String attributeName = parser.getAttributeName(i);
            String url = parser.getAttributeNamespace(i);
            if (null == root) {
                if (0 == i) {
                    element.getNameSpaces().addAll(XmlHelper.getNameSpace(parser));
                }
                attributeNamespace = element.getNameSpacePrefix(url);
            } else {
                attributeNamespace = root.getNameSpacePrefix(url);
            }
            String attributeValue = parser.getAttributeValue(url, attributeName);
            element.getAttributes().add(new XmlAttribute(attributeName, attributeNamespace, attributeValue));
        }
    }
}

