/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.indicator.drawable;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.ShapeDrawable;
import com.cz.library.widget.indicator.Indicatorable;
import com.cz.library.widget.indicator.ViewPagerIndicator;

public final class CircleIndicatorDrawable
extends ShapeDrawable
implements Indicatorable {
    private static final int _MOVE = 0;
    private static final int _RATE = 1;
    private static final int _SIZE = 2;
    private ViewPagerIndicator.IndicatorConfig mConfig;
    private int mIndex;
    private int mCount;
    private PorterDuffXfermode mRrcAtopfermode;
    private Paint mPaint;

    public CircleIndicatorDrawable(int index, int count, ViewPagerIndicator.IndicatorConfig config) {
        this.mConfig = config;
        this.mIndex = index;
        this.mCount = count;
        if (config.is3d) {
            this.setEvaluateShader(this.mConfig.defaultColor, this.getPaint());
            this.mPaint = new Paint(1);
            this.setEvaluateShader(this.mConfig.animColor, this.mPaint);
        } else {
            this.mPaint = new Paint(1);
            this.mPaint.setColor(this.mConfig.animColor);
            this.getPaint().setColor(this.mConfig.defaultColor);
        }
        this.mRrcAtopfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP);
    }

    private void setEvaluateShader(int defaultColor, Paint paint) {
        float radial = this.mConfig.size / 4.0f;
        RadialGradient gradient = new RadialGradient(radial * 3.0f, radial, this.mConfig.size, defaultColor, this.getDarkColor(defaultColor), Shader.TileMode.CLAMP);
        paint.setShader((Shader)gradient);
    }

    private int getDarkColor(int color) {
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        int darkColor = 0xFF000000 | red / 4 << 16 | green / 4 << 8 | blue / 4;
        return darkColor;
    }

    @Override
    public void draw(Canvas canvas) {
        switch (this.mConfig.circleType) {
            case 0: {
                this.drawMoveCircle(canvas);
                break;
            }
            case 1: {
                this.drawRateCircle(canvas);
                break;
            }
            case 2: {
                this.drawSizeCircle(canvas);
                break;
            }
        }
    }

    private void drawSizeCircle(Canvas canvas) {
        RectF newRect = this.initScaleRect(this.mConfig.mRect);
        if (this.mIndex == this.mConfig.position) {
            int color = this.evaluate(this.mConfig.positionOffset, this.mConfig.animColor, this.mConfig.defaultColor);
            if (this.mConfig.is3d) {
                this.setEvaluateShader(color, this.mPaint);
                canvas.drawOval(newRect, this.mPaint);
            } else {
                this.mPaint.setColor(color);
                canvas.drawOval(newRect, this.mPaint);
            }
        } else if (this.mIndex == (this.mCount - 1 == this.mConfig.position ? 0 : this.mConfig.position + 1)) {
            int color = this.evaluate(this.mConfig.positionOffset, this.mConfig.defaultColor, this.mConfig.animColor);
            if (this.mConfig.is3d) {
                this.setEvaluateShader(color, this.mPaint);
                canvas.drawOval(newRect, this.mPaint);
            } else {
                this.mPaint.setColor(color);
                canvas.drawOval(newRect, this.mPaint);
            }
        } else {
            this.getPaint().setColor(this.mConfig.defaultColor);
            canvas.drawOval(newRect, this.getPaint());
        }
    }

    private void drawRateCircle(Canvas canvas) {
        RectF newRect = this.initScaleRect(this.mConfig.mRect);
        if (this.mIndex == this.mConfig.position) {
            canvas.drawOval(newRect, this.getPaint());
            canvas.drawArc(newRect, 0.0f, 360.0f * (1.0f - this.mConfig.positionOffset), true, this.mPaint);
        } else if (this.mIndex == (this.mCount - 1 == this.mConfig.position ? 0 : this.mConfig.position + 1)) {
            canvas.drawOval(newRect, this.getPaint());
            canvas.drawArc(newRect, 0.0f, 360.0f * this.mConfig.positionOffset, true, this.mPaint);
        } else {
            Paint paint = this.getPaint();
            paint.setColor(this.mConfig.defaultColor);
            canvas.drawOval(newRect, paint);
        }
    }

    private void drawMoveCircle(Canvas canvas) {
        float size = this.mConfig.size + this.mConfig.scaleSize;
        int sc = canvas.saveLayer(0.0f, 0.0f, size, size, null, 31);
        RectF newRect = this.initScaleRect(this.mConfig.mRect);
        canvas.drawOval(newRect, this.getPaint());
        this.mPaint.setXfermode((Xfermode)this.mRrcAtopfermode);
        if (this.mIndex == this.mConfig.position) {
            canvas.drawOval(new RectF(0.0f + this.mConfig.positionOffset * size, 0.0f, size + this.mConfig.positionOffset * size, size), this.mPaint);
        } else if (this.mIndex == (this.mCount - 1 == this.mConfig.position ? 0 : this.mConfig.position + 1)) {
            canvas.drawOval(new RectF(-(1.0f - this.mConfig.positionOffset) * size, 0.0f, size - (1.0f - this.mConfig.positionOffset) * size, size), this.mPaint);
        }
        this.mPaint.setXfermode(null);
        canvas.restoreToCount(sc);
    }

    private RectF initScaleRect(RectF rect) {
        RectF newRect = new RectF(rect);
        if (this.mIndex == this.mConfig.position) {
            newRect.right += this.mConfig.scaleSize * (1.0f - this.mConfig.positionOffset);
            newRect.bottom += this.mConfig.scaleSize * (1.0f - this.mConfig.positionOffset);
        } else if (this.mIndex == (this.mCount - 1 == this.mConfig.position ? 0 : this.mConfig.position + 1)) {
            newRect.right += this.mConfig.scaleSize * this.mConfig.positionOffset;
            newRect.bottom += this.mConfig.scaleSize * this.mConfig.positionOffset;
        }
        return newRect;
    }

    public void onPageScrollStateChanged(int status) {
    }

    public void onPageScrolled(int position, float offset, int offsetValue) {
        this.mConfig.position = position % this.mCount;
        this.mConfig.positionOffset = offset;
    }

    public void onPageSelected(int position) {
    }

    public int evaluate(float fraction, int startValue, int endValue) {
        int startInt = startValue;
        int startA = startInt >> 24;
        int startR = startInt >> 16 & 0xFF;
        int startG = startInt >> 8 & 0xFF;
        int startB = startInt & 0xFF;
        int endInt = endValue;
        int endA = endInt >> 24;
        int endR = endInt >> 16 & 0xFF;
        int endG = endInt >> 8 & 0xFF;
        int endB = endInt & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }
}

