/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.indicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.indicator.Indicatorable;
import com.cz.library.widget.indicator.drawable.CircleIndicatorDrawable;
import java.util.ArrayList;

public final class ViewPagerIndicator
extends View
implements ViewPager.OnPageChangeListener {
    private static final int CENTER = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int DEFAULT_CIRCLE_RADIUS = 10;
    private static final int DEFAULT_PADDING = 5;
    private static final int DEFUALT_COLORRES = 17170452;
    private static final int ANIM_COLORRES = 17170451;
    private ViewPager mViewPager;
    private final ArrayList<Indicatorable> mDrawables = new ArrayList();
    private ViewPager.OnPageChangeListener mPagerChangeListener;
    private final IndicatorConfig mConfig = new IndicatorConfig();
    private int mGravity;
    private int mCount;

    public ViewPagerIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        Resources resources = this.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewPagerIndicator);
        this.setCircleType(a.getInt(R.styleable.ViewPagerIndicator_vi_circle_type, 0));
        this.setRadius(a.getDimension(R.styleable.ViewPagerIndicator_vi_radius, (float)Utils.dip2px(10.0f)));
        this.setGravity(a.getInt(R.styleable.ViewPagerIndicator_vi_circle_gravity, 0));
        this.setPadding(a.getDimension(R.styleable.ViewPagerIndicator_vi_padding, (float)Utils.dip2px(5.0f)));
        this.setScaleSize(a.getDimension(R.styleable.ViewPagerIndicator_vi_scale, 0.0f));
        this.setColor(resources.getColor(a.getResourceId(R.styleable.ViewPagerIndicator_vi_default_color, 17170452)));
        this.setAnimColor(resources.getColor(a.getResourceId(R.styleable.ViewPagerIndicator_vi_anim_color, 17170451)));
        this.set3D(a.getBoolean(R.styleable.ViewPagerIndicator_vi_is_3d, true));
        a.recycle();
    }

    public void setScaleSize(float size) {
        this.mConfig.scaleSize = size;
        this.invalidate();
    }

    public void setAnimColor(int color2) {
        this.mConfig.animColor = color2;
    }

    public void setColor(int color2) {
        this.mConfig.defaultColor = color2;
    }

    public void setPadding(float padding) {
        this.mConfig.padding = padding;
        this.invalidate();
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
        this.invalidate();
    }

    public void setRadius(float radius) {
        this.mConfig.circleRadius = radius;
        this.mConfig.size = radius;
        this.mConfig.mRect.right = radius;
        this.mConfig.mRect.bottom = radius;
        this.invalidate();
    }

    private void set3D(boolean is3d) {
        this.mConfig.is3d = is3d;
        this.invalidate();
    }

    public float getRadius() {
        return this.mConfig.circleRadius;
    }

    public void setCircleType(int type) {
        this.mConfig.circleType = type;
        this.invalidate();
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewPagerIndicator(Context context) {
        this(context, null, 0);
    }

    public void setViewPager(ViewPager viewPager) {
        this.setViewPager(viewPager, 0);
    }

    public void setViewPager(ViewPager viewPager, int count) {
        if (!this.mDrawables.isEmpty()) {
            this.mDrawables.clear();
        }
        this.mViewPager = viewPager;
        if (null == this.mViewPager || null == this.mViewPager.getAdapter()) {
            throw new NullPointerException("ViewPager/Adapter\u600e\u4e48\u80fd\u4e3a\u7a7a\u5462~");
        }
        PagerAdapter adapter = this.mViewPager.getAdapter();
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mCount = 0 == count ? adapter.getCount() : count;
        for (int i = 0; i < this.mCount; ++i) {
            this.mDrawables.add(new CircleIndicatorDrawable(i, this.mCount, this.mConfig));
        }
    }

    public void onPageScrollStateChanged(int status) {
        if (null != this.mPagerChangeListener) {
            this.mPagerChangeListener.onPageSelected(status);
        }
        for (int i = 0; i < this.mCount; ++i) {
            Indicatorable indicatorable = this.mDrawables.get(i);
            indicatorable.onPageScrollStateChanged(status);
        }
    }

    public void onPageScrolled(int position, float offset, int offsetValue) {
        if (null != this.mPagerChangeListener) {
            this.mPagerChangeListener.onPageScrolled(position, offset, offsetValue);
        }
        for (int i = 0; i < this.mCount; ++i) {
            Indicatorable indicatorable = this.mDrawables.get(i);
            indicatorable.onPageScrolled(position, offset, offsetValue);
        }
        this.mConfig.position = position % this.mCount;
        this.mConfig.positionOffset = offset;
        this.invalidate();
    }

    public void onPageSelected(int position) {
        if (null != this.mPagerChangeListener) {
            this.mPagerChangeListener.onPageSelected(position);
        }
        for (int i = 0; i < this.mCount; ++i) {
            Indicatorable indicatorable = this.mDrawables.get(i);
            indicatorable.onPageSelected(position);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mPagerChangeListener = listener;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (null != this.mViewPager) {
            this.drawCircle(canvas);
        }
    }

    private void drawCircle(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int size = (int)(this.mConfig.circleRadius + this.mConfig.padding);
        int drawWidth = size * this.mCount;
        float scaleSize = this.mConfig.scaleSize / 2.0f;
        for (int i = 0; i < this.mCount; ++i) {
            float dx;
            float dy = ((float)height - this.mConfig.circleRadius) / 2.0f;
            switch (this.mGravity) {
                case 1: {
                    dx = (float)(i * size) + this.mConfig.padding;
                    break;
                }
                case 2: {
                    dx = width - drawWidth + i * size;
                    break;
                }
                default: {
                    dx = (width - drawWidth) / 2 + i * size;
                }
            }
            canvas.save();
            if (i == this.mConfig.position) {
                canvas.translate(dx - scaleSize * (1.0f - this.mConfig.positionOffset), dy - scaleSize * (1.0f - this.mConfig.positionOffset));
            } else if (i == (this.mCount - 1 == this.mConfig.position ? 0 : this.mConfig.position + 1)) {
                canvas.translate(dx - scaleSize * this.mConfig.positionOffset, dy - scaleSize * this.mConfig.positionOffset);
            } else {
                canvas.translate(dx, dy);
            }
            this.mDrawables.get(i).draw(canvas);
            canvas.restore();
        }
    }

    public static class IndicatorConfig {
        public int defaultColor;
        public int animColor;
        public float circleRadius;
        public float padding;
        public float scaleSize;
        public float size;
        public int circleType;
        public int position;
        public float positionOffset;
        public boolean is3d;
        public RectF mRect = new RectF();
    }
}

