/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.drawable;

import android.graphics.drawable.GradientDrawable;
import com.cz.library.widget.drawable.DrawableBuilder;

public class GradientBuilder {
    private static final String TAG = "GradientBuilder";
    private final int gradientType;
    private final DrawableBuilder gradientDrawable;
    private int gradientAngle;
    private float gradientRadius;
    private boolean useLevel;
    private float gradientCenterX;
    private float gradientCenterY;
    private int gradientStartColor;
    private int gradientCenterColor;
    private int gradientEndColor;

    GradientBuilder(DrawableBuilder drawableBuilder, @GradientType int gradientType) {
        this.gradientDrawable = drawableBuilder;
        this.gradientType = gradientType;
    }

    public GradientBuilder setGradientAngle(int gradientAngle) {
        this.gradientAngle = gradientAngle;
        return this;
    }

    public GradientBuilder setGradientCenterColor(int gradientCenterColor) {
        this.gradientCenterColor = gradientCenterColor;
        return this;
    }

    public GradientBuilder setCenterX(float gradientCenterX) {
        this.gradientCenterX = gradientCenterX;
        return this;
    }

    public GradientBuilder setCenterY(float gradientCenterY) {
        this.gradientCenterY = gradientCenterY;
        return this;
    }

    public GradientBuilder setGradientEndColor(int gradientEndColor) {
        this.gradientEndColor = gradientEndColor;
        return this;
    }

    public GradientBuilder setGradientRadius(float gradientRadius) {
        this.gradientRadius = gradientRadius;
        return this;
    }

    public GradientBuilder setGradientStartColor(int gradientStartColor) {
        this.gradientStartColor = gradientStartColor;
        return this;
    }

    public GradientBuilder setUseLevel(boolean useLevel) {
        this.useLevel = useLevel;
        return this;
    }

    private GradientDrawable.Orientation getOrientation(int angle) {
        GradientDrawable.Orientation orientation;
        switch (angle %= 360) {
            default: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 45: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 90: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 135: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 180: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 225: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 270: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 315: {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    GradientDrawable create() {
        GradientDrawable drawable = new GradientDrawable(this.getOrientation(this.gradientAngle), new int[]{this.gradientStartColor, this.gradientCenterColor, this.gradientEndColor});
        drawable.setGradientType(this.gradientType);
        drawable.setGradientRadius(this.gradientRadius);
        drawable.setUseLevel(this.useLevel);
        drawable.setGradientCenter(this.gradientCenterX, this.gradientCenterY);
        return drawable;
    }

    public GradientDrawable build() {
        return this.gradientDrawable.build();
    }

    public static @interface GradientType {
    }
}

