/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.card;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;

public class ShadowDrawable
extends ShapeDrawable
implements Cloneable {
    private static final int SHADOW_COLOR = 0x1E000000;
    public static final int RECT = 0;
    public static final int OVAL = 1;
    private ShadowDrawable cloneDrawable;
    private float shadowRadius;
    private float rectRadius;
    private float elevation;
    private int cardType;

    public void setBackgroundColor(int color) {
        this.getPaint().setColor(color);
        this.invalidateSelf();
    }

    public void setShadowRadius(float radius) {
        this.shadowRadius = radius;
        this.setShadowLayer(this.shadowRadius, this.elevation, 0x1E000000);
    }

    public void setRectRadius(float radius) {
        this.rectRadius = radius;
    }

    public void setElevation(float elevation) {
        this.elevation = elevation;
        this.setShadowLayer(this.shadowRadius, this.elevation, 0x1E000000);
    }

    public void setCardType(int cardType) {
        this.cardType = cardType;
        if (0 == cardType) {
            this.setShape((Shape)new RectShadow());
        } else if (1 == cardType) {
            this.setShape((Shape)new OvalShadow());
        }
        this.setShadowLayer(this.shadowRadius, this.elevation, 0x1E000000);
    }

    public void setShadowColor(int color) {
        this.getPaint().setShadowLayer(this.shadowRadius, 0.0f, this.elevation, color);
    }

    private void setShadowLayer(float shadowRadius, float elevation, int color) {
        this.getPaint().setShadowLayer(shadowRadius, 0.0f, elevation, color);
        if (null != this.cloneDrawable) {
            this.cloneDrawable.getPaint().setShadowLayer(shadowRadius, 0.0f, elevation, 0x1E000000);
        }
    }

    protected ShadowDrawable clone() {
        ShadowDrawable drawable = new ShadowDrawable();
        drawable.getPaint().setShadowLayer(this.shadowRadius, 0.0f, this.elevation, 0x1E000000);
        drawable.setCardType(this.cardType);
        this.cloneDrawable = drawable;
        return this.cloneDrawable;
    }

    class RectShadow
    extends RectShape {
        public void draw(Canvas canvas, Paint paint) {
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, this.getWidth(), this.getHeight()), ShadowDrawable.this.rectRadius, ShadowDrawable.this.rectRadius, paint);
        }
    }

    class OvalShadow
    extends OvalShape {
        public void draw(Canvas canvas, Paint paint) {
            Rect bounds = ShadowDrawable.this.getBounds();
            float viewWidth = bounds.width();
            float viewHeight = bounds.height();
            canvas.drawCircle(viewWidth / 2.0f, viewHeight / 2.0f, Math.min(viewWidth, viewHeight) / 2.0f, paint);
        }
    }
}

