/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.card;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.LinearLayout;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.card.ShadowDrawable;

public class CardLinearLayout
extends LinearLayout {
    private static final int DELAYED_TIME = 300;
    public static final int RIPPLE_SHAPE = 0;
    public static final int RIPPLE_FULL = 1;
    private final ShadowDrawable shadowDrawable = new ShadowDrawable();
    private int backgroundPressColor;
    private int horizontalPadding;
    private int verticalPadding;
    private Drawable foreground;
    private int rippleMode;

    public CardLinearLayout(Context context) {
        this(context, null);
    }

    public CardLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, this.shadowDrawable.getPaint());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CardLinearLayout);
        this.setHorizontalPadding((int)a.getDimension(R.styleable.CardLinearLayout_cl_horizontalPadding, (float)Utils.dip2px(1.0f)));
        this.setVerticalPadding((int)a.getDimension(R.styleable.CardLinearLayout_cl_verticalPadding, (float)Utils.dip2px(2.0f)));
        this.setCornerRadius(a.getDimension(R.styleable.CardLinearLayout_cl_cardCornerRadius, (float)Utils.dip2px(1.0f)));
        this.setCardRectRadius(a.getDimension(R.styleable.CardLinearLayout_cl_cardRectRadius, 0.0f));
        this.setCardBackgroundColor(a.getColor(R.styleable.CardLinearLayout_cl_cardBackgroundColor, -1));
        this.setCardBackgroundPressColor(a.getColor(R.styleable.CardLinearLayout_cl_cardBackgroundPressColor, 0));
        this.setCardElevation(a.getDimension(R.styleable.CardLinearLayout_cl_cardElevation, (float)Utils.dip2px(1.0f)));
        this.setCardType(a.getInt(R.styleable.CardLinearLayout_cl_cardType, 0));
        this.setCardRippleMode(a.getInt(R.styleable.CardLinearLayout_cl_cardRippleMode, 0));
        a.recycle();
    }

    public void setCardRippleMode(int mode) {
        this.rippleMode = mode;
        this.resetShadowDrawable();
    }

    public void setHorizontalPadding(int padding) {
        this.setContentPadding(padding, this.verticalPadding);
    }

    public void setVerticalPadding(int padding) {
        this.setContentPadding(this.horizontalPadding, padding);
    }

    private void setBackgroundDrawableCompat(ShadowDrawable shadowDrawable) {
        int width = this.getWidth();
        int height = this.getHeight();
        StateListDrawable stateListDrawable = new StateListDrawable();
        ShadowDrawable pressDrawable = shadowDrawable.clone();
        pressDrawable.setBackgroundColor(this.backgroundPressColor);
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)pressDrawable);
        stateListDrawable.addState(EMPTY_STATE_SET, (Drawable)shadowDrawable);
        stateListDrawable.setBounds(this.horizontalPadding, this.verticalPadding, width - this.horizontalPadding, height - this.verticalPadding);
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable((Drawable)stateListDrawable);
        } else {
            this.setBackground((Drawable)stateListDrawable);
        }
    }

    private void setBackgroundDrawableL(ShadowDrawable shadowDrawable) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (null != this.foreground) {
                this.foreground.setCallback(null);
                this.unscheduleDrawable(this.foreground);
            }
            if (1 == this.rippleMode) {
                ShadowDrawable newDrawable = shadowDrawable.clone();
                newDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.foreground = new RippleDrawable(ColorStateList.valueOf((int)this.backgroundPressColor), null, (Drawable)newDrawable);
            } else {
                this.foreground = new RippleDrawable(ColorStateList.valueOf((int)this.backgroundPressColor), null, (Drawable)shadowDrawable);
            }
            this.foreground.setCallback((Drawable.Callback)this);
            if (this.foreground.isStateful()) {
                this.foreground.setState(this.getDrawableState());
            }
            this.setBackground((Drawable)shadowDrawable);
            this.setContentPadding(this.horizontalPadding, this.verticalPadding);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.resetShadowDrawable();
    }

    private void resetShadowDrawable() {
        if (Build.VERSION.SDK_INT < 21) {
            this.setBackgroundDrawableCompat(this.shadowDrawable);
        } else {
            this.setBackgroundDrawableL(this.shadowDrawable);
        }
    }

    public void setCardType(int cardType) {
        this.shadowDrawable.setCardType(cardType);
        if (this.isShown()) {
            this.resetShadowDrawable();
        }
    }

    public void setContentPadding(int padding) {
        this.setContentPadding(padding, padding);
    }

    public void setContentPadding(int horizontalPadding, int verticalPadding) {
        this.horizontalPadding = horizontalPadding;
        this.verticalPadding = verticalPadding;
        if (null != this.getBackground()) {
            this.getBackground().setBounds(horizontalPadding, verticalPadding, this.getWidth() - horizontalPadding, this.getHeight() - verticalPadding);
        }
        if (Build.VERSION.SDK_INT >= 21 && null != this.foreground) {
            if (1 == this.rippleMode) {
                this.foreground.setBounds(0, 0, this.getWidth(), this.getHeight());
            } else {
                this.foreground.setBounds(horizontalPadding, verticalPadding, this.getWidth() - horizontalPadding, this.getHeight() - verticalPadding);
            }
        }
    }

    public void setCornerRadius(float radius) {
        this.shadowDrawable.setShadowRadius(radius);
        this.invalidate();
    }

    public void setCardBackgroundColor(int color) {
        this.shadowDrawable.setBackgroundColor(color);
        this.invalidate();
    }

    private void setCardBackgroundPressColor(int color) {
        this.backgroundPressColor = color;
    }

    public void setCardElevation(float elevation) {
        this.shadowDrawable.setElevation(elevation);
        this.invalidate();
    }

    public void setCardRectRadius(float radius) {
        this.shadowDrawable.setRectRadius(radius);
        this.invalidate();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.foreground != null && this.foreground.isStateful()) {
            this.foreground.setState(this.getDrawableState());
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.foreground;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.foreground != null) {
            this.foreground.jumpToCurrentState();
        }
    }

    public void draw(Canvas canvas) {
        this.setContentPadding(this.horizontalPadding, this.verticalPadding);
        super.draw(canvas);
        if (null != this.foreground) {
            this.foreground.draw(canvas);
        }
    }

    public boolean performClick() {
        boolean result = true;
        if (Build.VERSION.SDK_INT < 21) {
            result = super.performClick();
        } else {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CardLinearLayout.super.performClick();
                }
            }, 300L);
        }
        return result;
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (Build.VERSION.SDK_INT >= 21 && e.getActionMasked() == 0 && null != this.foreground) {
            this.foreground.setHotspot(e.getX(), e.getY());
        }
        return super.onTouchEvent(e);
    }
}

