/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.badger;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewTreeObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Badger {
    private static final HashMap<View, List<View>> decorItems = new HashMap();
    private static final HashMap<View, List<View>> dependItems = new HashMap();

    public static Badger create(Activity activity, @IdRes int id) {
        View decorView = null;
        View findView = null;
        if (null != activity) {
            findView = activity.findViewById(id);
            decorView = activity.getWindow().getDecorView();
        }
        return new Badger(decorView, null, findView);
    }

    public static Badger create(Fragment fragment, @IdRes int id) {
        View decorView = null;
        View dependView = null;
        View findView = null;
        if (null != fragment && null != (dependView = fragment.getView())) {
            findView = dependView.findViewById(id);
            FragmentActivity activity = fragment.getActivity();
            if (null != activity && null != findView) {
                decorView = activity.getWindow().getDecorView();
            }
        }
        return new Badger(decorView, dependView, findView);
    }

    private Badger(View decorView, View dependView, View findView) {
        this.dependToView(dependView, findView);
        this.dependToDecorView(decorView, findView);
    }

    private void dependToView(final View dependView, View findView) {
        this.ensureAndAddItem(dependItems, dependView, findView);
        final ViewTreeObserver viewTreeObserver = dependView.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (8 == dependView.getVisibility()) {
                    List views = (List)dependItems.get(dependView);
                    if (null != views) {
                        for (View view : views) {
                        }
                    }
                } else if (dependView == dependView.getRootView()) {
                    dependItems.remove(dependView);
                    if (Build.VERSION.SDK_INT < 16) {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
        });
    }

    private void dependToDecorView(final View decorView, View findView) {
        this.ensureAndAddItem(decorItems, decorView, findView);
        final ViewTreeObserver viewTreeObserver = decorView.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (decorView == decorView.getRootView()) {
                    decorItems.remove(decorView);
                    if (Build.VERSION.SDK_INT < 16) {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
        });
    }

    private void ensureAndAddItem(Map<View, List<View>> items, View dependView, View findView) {
        List<View> views = items.get(dependView);
        if (null == views) {
            views = new ArrayList<View>();
            items.put(dependView, views);
        }
        views.add(findView);
    }
}

