/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.cz.library.R;

public class TemplateView
extends RelativeLayout {
    private static final String TAG = "TemplateView";
    public static final int CONTAINER = 0;
    public static final int PROGRESS = 1;
    public static final int DISPLAY = 2;
    public static final int ERROR = 3;
    public static final int CUSTOM = 4;
    private RelativeLayout container;
    private Runnable frameAction;
    private int templateCount;
    private int lastFrame;

    public TemplateView(Context context) {
        this(context, null, R.attr.template);
    }

    public TemplateView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.template);
    }

    public TemplateView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.container = new RelativeLayout(context);
        this.addView((View)this.container, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TemplateView, R.attr.template, R.style.Template);
        this.inflateLayout(a.getResourceId(R.styleable.TemplateView_fv_progressLayout, -1));
        this.inflateLayout(a.getResourceId(R.styleable.TemplateView_fv_displayLayout, -1));
        this.inflateLayout(a.getResourceId(R.styleable.TemplateView_fv_errorLayout, -1));
        this.inflateLayout(a.getResourceId(R.styleable.TemplateView_fv_customLayout, -1));
        a.recycle();
        this.templateCount = this.getChildCount();
        this.setFrame(0, true, 0L);
    }

    private void inflateLayout(@LayoutRes int layout2) {
        if (-1 != layout2) {
            int index = this.getChildCount();
            TemplateView.inflate((Context)this.getContext(), (int)layout2, (ViewGroup)this);
            this.getChildAt(index).setVisibility(8);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int i = this.templateCount;
        while (i < this.getChildCount()) {
            View childView = this.getChildAt(i);
            this.removeView(childView);
            this.container.addView(childView);
        }
    }

    public boolean isFrame(@Frame int frame) {
        return this.lastFrame == frame;
    }

    public void setFrame(@Frame int frame, boolean animate, long delayTime) {
        this.setFrame(frame, animate, false, delayTime);
    }

    public void setFrame(@Frame int frame, long delayTime) {
        this.setFrame(frame, true, false, delayTime);
    }

    public void setForceFrame(@Frame int frame, long delayTime) {
        this.setFrame(frame, true, true, delayTime);
    }

    public void setForceFrame(int frame, boolean animator, long delayTime) {
        this.setFrame(frame, animator, true, delayTime);
    }

    private void setFrame(final int frame, final boolean animate, boolean check, long delayTime) {
        if (null != this.container && (check || frame != this.lastFrame)) {
            if (null != this.frameAction) {
                this.removeCallbacks(this.frameAction);
            }
            final int lastFrame = this.lastFrame;
            this.lastFrame = frame;
            if (0L >= delayTime) {
                this.showFrame(frame, lastFrame, animate);
            } else {
                this.frameAction = new Runnable(){

                    @Override
                    public void run() {
                        TemplateView.this.showFrame(frame, lastFrame, animate);
                    }
                };
                this.postDelayed(this.frameAction, delayTime);
            }
        }
    }

    protected void onDetachedFromWindow() {
        if (null != this.frameAction) {
            this.removeCallbacks(this.frameAction);
        }
        super.onDetachedFromWindow();
    }

    public void showFrame(int frame, int lastFrame, boolean animate) {
        View showView = this.getChildAt(frame);
        View closeView = this.getChildAt(lastFrame);
        closeView.setVisibility(8);
        showView.setVisibility(0);
        if (11 < Build.VERSION.SDK_INT && animate) {
            ViewCompat.setAlpha((View)showView, (float)0.0f);
            ViewCompat.animate((View)showView).alpha(1.0f);
        }
    }

    public static @interface Frame {
    }
}

