/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.StringRes;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.cz.library.R;
import com.cz.library.widget.DivideTextView;

public class SuperTextView
extends DivideTextView {
    private static final String TAG = "SuperTextView";
    private static final boolean debug = false;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_TOP = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int ALIGN_BOTTOM = 4;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int CENTER_HORIZONTAL = 16;
    public static final int CENTER_VERTICAL = 32;
    public static final int CENTER = 48;
    private final TextPaint textPaint;
    private final int[] originPadding = new int[4];
    private final int[] extPadding = new int[4];
    private int extGravity;
    private Layout extLayout;
    private int extLines;
    private int constrains;
    private String extText;
    private float extTextWidth;
    private float extTextHeight;
    private float fixedTextWidth;
    private float fixedTextHeight;
    private int extTextWeight;
    private int extTextWeightSum;
    private Drawable extBackgroundDrawable;
    private Drawable backgroundDrawable;

    public SuperTextView(Context context) {
        this(context, null, 0);
    }

    public SuperTextView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.superTextView);
    }

    public SuperTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.textPaint = new TextPaint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuperTextView, defStyleAttr, R.style.SuperTextView);
        this.setExtText(a.getString(R.styleable.SuperTextView_st_extText));
        this.setExtTextColor(a.getColor(R.styleable.SuperTextView_st_extTextColor, 0));
        this.setExtTextSize(a.getDimensionPixelSize(R.styleable.SuperTextView_st_extTextSize, 0));
        this.setExtLines(a.getInteger(R.styleable.SuperTextView_st_extLines, 0));
        this.setExtConstrainsInner(a.getInt(R.styleable.SuperTextView_st_extConstrains, 1));
        this.setExtTextWidth(a.getDimension(R.styleable.SuperTextView_st_extTextWidth, 0.0f));
        this.setExtTextHeight(a.getDimension(R.styleable.SuperTextView_st_extTextHeight, 0.0f));
        this.setExtTextWeight(a.getInteger(R.styleable.SuperTextView_st_extTextWeight, 0));
        this.setExtTextWeightSum(a.getInteger(R.styleable.SuperTextView_st_extTextWeightSum, 0));
        this.setExtGravityInner(a.getInt(R.styleable.SuperTextView_st_extGravity, 1));
        this.setExtBackground(a.getDrawable(R.styleable.SuperTextView_st_extBackground));
        this.setExtTextStyle(a.getInt(R.styleable.SuperTextView_st_extTextStyle, 0));
        int extPadding = (int)a.getDimension(R.styleable.SuperTextView_st_padding, 0.0f);
        int extPaddingLeft = (int)a.getDimension(R.styleable.SuperTextView_st_paddingLeft, 0.0f);
        int extPaddingTop = (int)a.getDimension(R.styleable.SuperTextView_st_paddingTop, 0.0f);
        int extPaddingRight = (int)a.getDimension(R.styleable.SuperTextView_st_paddingRight, 0.0f);
        int extPaddingBottom = (int)a.getDimension(R.styleable.SuperTextView_st_paddingBottom, 0.0f);
        if (0 != extPadding) {
            this.setExtPadding(extPadding, extPadding, extPadding, extPadding);
        } else {
            this.setExtPadding(extPaddingLeft, extPaddingTop, extPaddingRight, extPaddingBottom);
        }
        a.recycle();
        a = context.obtainStyledAttributes(attrs, new int[]{16842965, 16842966, 16842967, 16842968, 16842969});
        int padding = (int)a.getDimension(0, 0.0f);
        int paddingLeft = (int)a.getDimension(1, 0.0f);
        int paddingTop = (int)a.getDimension(2, 0.0f);
        int paddingRight = (int)a.getDimension(3, 0.0f);
        int paddingBottom = (int)a.getDimension(4, 0.0f);
        if (0 != padding) {
            this.setPaddingInner(padding, padding, padding, padding);
        } else {
            this.setPaddingInner(paddingLeft, paddingTop, paddingRight, paddingBottom);
        }
        a.recycle();
    }

    public void setExtTextStyle(int style2) {
        this.textPaint.setTypeface(Typeface.defaultFromStyle((int)style2));
        this.invalidate();
    }

    private void setExtBackground(Drawable drawable) {
        this.extBackgroundDrawable = drawable;
        this.invalidate();
    }

    public void setExtGravity(@Gravity int gravity) {
        this.setExtGravityInner(gravity);
    }

    private void setExtGravityInner(int gravity) {
        this.extGravity = gravity;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtText(String text) {
        this.extText = text;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtText(@StringRes int res) {
        this.extText = this.getResources().getString(res);
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtTextColor(int color2) {
        this.textPaint.setColor(color2);
        this.invalidate();
    }

    public void setExtTextSize(int textSize) {
        this.textPaint.setTextSize((float)textSize);
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtLines(int lines) {
        this.extLines = lines;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtConstrains(@Constrains int constrains) {
        this.setExtConstrainsInner(constrains);
    }

    public void setExtConstrainsInner(int constrains) {
        this.extTextHeight = 0.0f;
        this.extTextWidth = 0.0f;
        this.constrains = constrains;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtTextWidth(float textWidth) {
        this.fixedTextWidth = textWidth;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtTextHeight(float textHeight) {
        this.fixedTextHeight = textHeight;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtTextWeight(int weight) {
        this.extTextWeight = weight;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public void setExtTextWeightSum(int sum) {
        this.extTextWeightSum = sum;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public final void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
    }

    public void setRealPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.setPaddingInner(left, top, right, bottom);
    }

    public void setExtPadding(int left, int top, int right, int bottom) {
        this.extPadding[0] = left;
        this.extPadding[1] = top;
        this.extPadding[2] = right;
        this.extPadding[3] = bottom;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    private void setPaddingInner(int left, int top, int right, int bottom) {
        this.originPadding[0] = left;
        this.originPadding[1] = top;
        this.originPadding[2] = right;
        this.originPadding[3] = bottom;
    }

    public String getExtText() {
        return this.extText;
    }

    public float getExtTextWidth() {
        return this.extTextWidth;
    }

    public float getExtTextHeight() {
        return this.extTextHeight;
    }

    public int getExtGravity() {
        return this.extGravity;
    }

    public int getExtTextWeight() {
        return this.extTextWeight;
    }

    public int getExtTextWeightSum() {
        return this.extTextWeightSum;
    }

    public int[] getExtPadding() {
        return this.extPadding;
    }

    public Layout getExtLayout() {
        return this.extLayout;
    }

    public Drawable getExtBackgroundDrawable() {
        return this.extBackgroundDrawable;
    }

    public boolean isTextEmpty() {
        return TextUtils.isEmpty((CharSequence)this.extText);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measureHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int paddingLeft = this.originPadding[0];
        int paddingTop = this.originPadding[1];
        int paddingRight = this.originPadding[2];
        int paddingBottom = this.originPadding[3];
        int wrapWidth = paddingLeft + paddingRight + this.getDrawableSize(0) + this.getDrawableSize(2);
        int wrapHeight = paddingTop + paddingBottom + this.getDrawableSize(1) + this.getDrawableSize(3);
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        float measureTextWidth = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)this.extText)) {
            measureTextWidth = this.textPaint.measureText(this.extText, 0, this.extText.length());
        }
        if (this.isHorizontalConstrains()) {
            textWidth = (0x40000000 == widthMode || (float)measureWidth <= measureTextWidth) && 0 != this.extTextWeight ? (float)this.extTextWeight * 1.0f / (float)this.extTextWeightSum * (float)measureWidth : (0.0f >= this.fixedTextWidth ? Math.min((float)(measureWidth - wrapWidth), measureTextWidth) : this.fixedTextWidth);
        } else if (this.isVerticalConstrains()) {
            if (0x40000000 == heightMode && 0 != this.extTextWeight) {
                textHeight = (float)this.extTextWeight * 1.0f / (float)this.extTextWeightSum * (float)measureHeight;
            } else if (0.0f < this.fixedTextHeight) {
                textHeight = this.fixedTextHeight;
            }
            textWidth = Integer.MIN_VALUE == widthMode ? Math.min((float)(measureWidth - wrapWidth), measureTextWidth) : (float)(measureWidth - this.extPadding[0] - this.extPadding[2]);
        }
        Layout layout2 = this.getLayout();
        if (!TextUtils.isEmpty((CharSequence)this.extText)) {
            int layoutTextWidth = Math.round(textWidth);
            this.extLayout = 1 == this.extLines ? new BoringLayout((CharSequence)this.extText, this.textPaint, 0 < layoutTextWidth ? layoutTextWidth : 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, new BoringLayout.Metrics(), true) : new StaticLayout((CharSequence)this.extText, this.textPaint, 0 < layoutTextWidth ? layoutTextWidth : 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
            this.extTextWidth = layoutTextWidth;
            this.extTextHeight = 0.0f != textHeight ? textHeight : (float)this.getExtLayoutHeight();
        } else if (null != this.extLayout) {
            this.extLayout = null;
            super.setPadding(this.originPadding[0], this.originPadding[1], this.originPadding[2], this.originPadding[3]);
        }
        if (Integer.MIN_VALUE == widthMode) {
            if (null != layout2) {
                wrapWidth += layout2.getWidth();
            }
            if (this.isHorizontalConstrains()) {
                if ((wrapWidth += this.getExtLayoutWidth() + this.extPadding[0] + this.extPadding[2]) < measureWidth) {
                    measureWidth = wrapWidth;
                }
            } else if (this.isVerticalConstrains() && wrapWidth < measureWidth && this.getExtLayoutWidth() + this.extPadding[0] + this.extPadding[2] < measureWidth) {
                measureWidth = Math.max(wrapWidth, this.getExtLayoutWidth() + this.extPadding[0] + this.extPadding[2]);
            }
        } else if (0 == widthMode) {
            measureWidth = this.isHorizontalConstrains() ? (measureWidth += layout2.getWidth() + this.getExtLayoutWidth() + wrapWidth + this.extPadding[0] + this.extPadding[2]) : Math.max(layout2.getWidth() + wrapWidth, this.getExtLayoutWidth() + this.extPadding[0] + this.extPadding[2]);
        }
        if (0x40000000 == heightMode) {
            measureHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else if (0.0f >= this.fixedTextHeight && Integer.MIN_VALUE == heightMode) {
            if (null != layout2) {
                wrapHeight += layout2.getHeight();
            }
            if (this.isVerticalConstrains()) {
                wrapHeight += this.getExtLayoutHeight() + this.extPadding[1] + this.extPadding[3];
            } else if (wrapHeight < Math.min(measureHeight, this.getExtLayoutHeight() + this.extPadding[1] + this.extPadding[3])) {
                wrapHeight = Math.min(measureHeight, this.getExtLayoutHeight() + this.extPadding[1] + this.extPadding[3]);
            }
            measureHeight = Math.min(wrapHeight, measureHeight);
        } else if (0 == heightMode) {
            measureHeight = this.isVerticalConstrains() ? wrapHeight + layout2.getHeight() + this.getExtLayoutHeight() + this.extPadding[1] + this.extPadding[3] : Math.max(layout2.getHeight() + wrapHeight, this.getExtLayoutHeight() + this.extPadding[1] + this.extPadding[3]);
        } else if (0.0f < this.fixedTextHeight) {
            measureHeight = (int)this.fixedTextHeight;
        }
        if (null != this.extLayout) {
            if (this.isHorizontalConstrains()) {
                this.resetLayoutPadding((int)textWidth + this.extPadding[0] + this.extPadding[2]);
            } else if (this.isVerticalConstrains()) {
                if (Integer.MIN_VALUE == heightMeasureSpec) {
                    this.resetLayoutPadding((int)Math.min(this.extTextHeight + (float)this.extPadding[1] + (float)this.extPadding[3], (float)measureHeight));
                } else if (0.0f != textHeight) {
                    this.resetLayoutPadding((int)(textHeight + (float)this.extPadding[1] + (float)this.extPadding[3]));
                } else {
                    this.resetLayoutPadding((int)(this.extTextHeight + (float)this.extPadding[1] + (float)this.extPadding[3]));
                }
            }
        }
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    public int getExtLayoutWidth() {
        return null == this.extLayout ? 0 : this.extLayout.getWidth();
    }

    public int getExtLayoutHeight() {
        return null == this.extLayout ? 0 : this.extLayout.getHeight();
    }

    private int getDrawableSize(int index) {
        int drawableSize = 0;
        int compoundDrawablePadding = this.getCompoundDrawablePadding();
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        if (null != compoundDrawables[index]) {
            int intrinsicSize = 0;
            if (0 == index || 2 == index) {
                intrinsicSize = compoundDrawables[index].getIntrinsicWidth();
            } else if (1 == index || 3 == index) {
                intrinsicSize = compoundDrawables[index].getIntrinsicHeight();
            }
            drawableSize += intrinsicSize + compoundDrawablePadding;
        }
        return drawableSize;
    }

    private void resetLayoutPadding(int extTextSize) {
        switch (this.constrains) {
            case 1: {
                if (this.originPadding[0] + extTextSize == this.getPaddingLeft()) break;
                super.setPadding(this.originPadding[0] + extTextSize, this.originPadding[1], this.originPadding[2], this.originPadding[3]);
                break;
            }
            case 2: {
                if (this.originPadding[1] + extTextSize == this.getPaddingTop()) break;
                super.setPadding(this.originPadding[0], this.originPadding[1] + extTextSize, this.originPadding[2], this.originPadding[3]);
                break;
            }
            case 3: {
                if (this.originPadding[2] + extTextSize == this.getPaddingRight()) break;
                super.setPadding(this.originPadding[0], this.originPadding[1], this.originPadding[2] + extTextSize, this.originPadding[3]);
                break;
            }
            case 4: {
                if (this.originPadding[3] + extTextSize == this.getPaddingBottom()) break;
                super.setPadding(this.originPadding[0], this.originPadding[1], this.originPadding[2], this.originPadding[3] + extTextSize);
            }
        }
    }

    public boolean isHorizontalConstrains() {
        return this.constrains == 1 || this.constrains == 3;
    }

    public boolean isVerticalConstrains() {
        return this.constrains == 2 || this.constrains == 4;
    }

    private PointF getTranslatePoint(float x, float y) {
        int width = this.getWidth();
        int height = this.getHeight();
        float lineWidth = null == this.extLayout ? 0.0f : this.extLayout.getLineRight(0);
        int layoutHeight = this.getExtLayoutHeight();
        if (0 != (this.extGravity & 4)) {
            if (lineWidth < this.extTextWidth) {
                x += this.extTextWidth - lineWidth;
            } else if (this.extTextWidth < (float)width) {
                x += (float)width - this.extTextWidth;
            }
        } else if (0 != (this.extGravity & 0x10)) {
            if (lineWidth < this.extTextWidth) {
                x += (this.extTextWidth - lineWidth) / 2.0f;
            } else if (!this.isHorizontalConstrains() && lineWidth < (float)width) {
                x += ((float)width - lineWidth) / 2.0f;
            }
        }
        if (0 != (this.extGravity & 8)) {
            if ((float)layoutHeight < this.extTextHeight) {
                y += this.extTextHeight - (float)layoutHeight;
            } else if (!this.isVerticalConstrains() && this.extTextHeight < (float)height) {
                y += (float)height - this.extTextHeight;
            }
        } else if (0 != (this.extGravity & 8) && (float)layoutHeight > this.extTextHeight) {
            y += this.extTextHeight - (float)layoutHeight;
        } else if (0 != (this.extGravity & 0x20)) {
            if ((float)layoutHeight < this.extTextHeight) {
                y += (this.extTextHeight - (float)layoutHeight) / 2.0f;
            } else if (!this.isVerticalConstrains() && layoutHeight < height) {
                y = (height - layoutHeight) / 2;
            }
        }
        Layout layout2 = this.getLayout();
        if (null != layout2) {
            int textHeight = layout2.getHeight();
            int fillTextHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.getDrawableSize(1) - this.getDrawableSize(3);
            int gravity = this.getGravity();
            if (0 != (gravity & 0x50) && textHeight > fillTextHeight) {
                y += (float)(textHeight - fillTextHeight);
            }
        }
        return new PointF(x, y);
    }

    public PointF getAlignTranslatePointF() {
        PointF point = null;
        int width = this.getWidth();
        int height = this.getHeight();
        switch (this.constrains) {
            case 1: {
                point = this.getTranslatePoint(this.extPadding[0], this.extPadding[1]);
                break;
            }
            case 2: {
                point = this.getTranslatePoint(this.extPadding[0], this.extPadding[1]);
                break;
            }
            case 3: {
                point = this.getTranslatePoint((float)width - this.extTextWidth - (float)this.extPadding[2], this.extPadding[1]);
                break;
            }
            case 4: {
                point = this.getTranslatePoint(this.extPadding[0], (float)height - this.extTextHeight - (float)this.extPadding[3]);
            }
        }
        return point;
    }

    public Drawable getBackground() {
        return this.backgroundDrawable;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (null != this.backgroundDrawable) {
            this.backgroundDrawable.setState(this.getDrawableState());
        }
        if (null != this.extBackgroundDrawable) {
            this.extBackgroundDrawable.setState(this.getDrawableState());
        }
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (null != this.backgroundDrawable) {
            this.backgroundDrawable.jumpToCurrentState();
        }
        if (null != this.extBackgroundDrawable) {
            this.extBackgroundDrawable.jumpToCurrentState();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        PointF point = this.getAlignTranslatePointF();
        this.drawBackground(canvas);
        this.drawExtBackground(canvas, point);
        this.drawExtText(canvas, point);
    }

    private void drawBackground(Canvas canvas) {
        if (null != this.backgroundDrawable) {
            int width = this.getWidth();
            int height = this.getHeight();
            boolean left = false;
            int top = 0;
            int right = 0;
            int bottom = 0;
            int textWidth = 0;
            int textHeight = 0;
            Layout layout2 = this.getLayout();
            if (null != layout2) {
                textWidth = layout2.getWidth();
                textHeight = layout2.getHeight();
            }
            switch (this.constrains) {
                case 1: {
                    right = width - this.getPaddingRight();
                    bottom = Math.min(height, this.extLayout.getHeight() + this.extPadding[1] + this.extPadding[3]);
                    break;
                }
                case 2: {
                    right = Math.min(width, this.extLayout.getWidth() + this.extPadding[0] + this.extPadding[2]);
                    bottom = height - this.getPaddingBottom();
                    break;
                }
                case 3: {
                    right = width - this.getPaddingLeft();
                    bottom = Math.min(height, this.extLayout.getHeight() + this.extPadding[1] + this.extPadding[3]);
                    break;
                }
                case 4: {
                    top = 0;
                    right = Math.min(width, this.extLayout.getWidth() + this.extPadding[0] + this.extPadding[2]);
                    bottom = height;
                }
            }
            this.backgroundDrawable.setBounds(0, top, right, bottom);
            this.backgroundDrawable.draw(canvas);
        }
    }

    private void drawExtBackground(Canvas canvas, PointF point) {
        if (null != this.extBackgroundDrawable) {
            int width = this.getWidth();
            int height = this.getHeight();
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            switch (this.constrains) {
                case 1: {
                    if (null != point) {
                        top = (int)point.y - this.extPadding[1];
                    }
                    right = this.getPaddingLeft() - this.originPadding[0];
                    bottom = Math.min(height, top + this.extLayout.getHeight() + this.extPadding[1] + this.extPadding[3]);
                    break;
                }
                case 2: {
                    right = Math.min(width, this.extLayout.getWidth() + this.extPadding[0] + this.extPadding[2]);
                    bottom = this.getPaddingTop() - this.originPadding[1];
                    break;
                }
                case 3: {
                    if (null != point) {
                        top = (int)point.y - this.extPadding[1];
                    }
                    left = width - this.getPaddingRight() + this.originPadding[2];
                    right = width;
                    bottom = Math.min(height, top + this.extLayout.getHeight() + this.extPadding[1] + this.extPadding[3]);
                    break;
                }
                case 4: {
                    top = height - this.getPaddingBottom() + this.originPadding[3];
                    right = Math.min(width, this.extLayout.getWidth() + this.extPadding[0] + this.extPadding[2]);
                    bottom = height;
                }
            }
            this.extBackgroundDrawable.setBounds(left, top, right, bottom);
            this.extBackgroundDrawable.draw(canvas);
        }
    }

    private void drawExtText(Canvas canvas, PointF point) {
        if (null != this.extLayout) {
            canvas.save();
            if (null != point) {
                canvas.translate(point.x, point.y);
            }
            this.extLayout.draw(canvas);
            canvas.restore();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        Parcelable parcelable = super.onSaveInstanceState();
        bundle.putParcelable("super", parcelable);
        bundle.putString("text", this.extText);
        bundle.putFloat("textSize", this.textPaint.getTextSize());
        bundle.putInt("textColor", this.textPaint.getColor());
        bundle.putInt("paddingLeft", this.extPadding[0]);
        bundle.putInt("paddingTop", this.extPadding[1]);
        bundle.putInt("paddingRight", this.extPadding[2]);
        bundle.putInt("paddingBottom", this.extPadding[3]);
        bundle.putFloat("textWidth", this.extTextWidth);
        bundle.putFloat("textHeight", this.extTextHeight);
        bundle.putInt("textWeight", this.extTextWeight);
        bundle.putInt("weightSum", this.extTextWeightSum);
        bundle.putInt("gravity", this.extGravity);
        bundle.putInt("constrains", this.constrains);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        Parcelable parcelable = bundle.getParcelable("super");
        super.onRestoreInstanceState(parcelable);
        this.extText = bundle.getString("text");
        this.textPaint.setColor(bundle.getInt("textColor"));
        this.textPaint.setTextSize(bundle.getFloat("textSize"));
        this.extPadding[0] = bundle.getInt("paddingLeft");
        this.extPadding[1] = bundle.getInt("paddingTop");
        this.extPadding[2] = bundle.getInt("paddingRight");
        this.extPadding[3] = bundle.getInt("paddingBottom");
        this.extTextWidth = bundle.getFloat("textWidth");
        this.extTextHeight = bundle.getFloat("textHeight");
        this.extTextWeight = bundle.getInt("textWeight");
        this.extTextWeightSum = bundle.getInt("weightSum");
        this.extGravity = bundle.getInt("gravity");
        this.constrains = bundle.getInt("constrains");
    }

    public static @interface Gravity {
    }

    public static @interface Constrains {
    }
}

