/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.view.View;
import com.cz.library.callback.OnMultiSelectListener;
import com.cz.library.callback.OnRectangleSelectListener;
import com.cz.library.callback.OnSingleSelectListener;
import com.cz.library.callback.Selectable;
import java.util.ArrayList;
import java.util.List;

public class SelectHelper {
    public static final int STATE_SELECTED = 0;
    public static final int STATE1 = 1;
    public static final int STATE2 = 2;
    public static final int STATE3 = 3;
    public static final int STATE4 = 4;
    public static final int STATE5 = 5;
    public static final int STATE6 = 6;
    public static final int STATE7 = 7;
    public static final int STATE8 = 8;
    public static final int STATE9 = 9;
    public static final int SINGLE = 0;
    public static final int MULTI = 1;
    public static final int RECTANGLE = 2;
    private final Selectable selectable;
    private int singleCheckedIndex = -1;
    private ArrayList<Integer> multiItems;
    private int start;
    private int end;
    private int selectMode;
    private OnRectangleSelectListener rectangleSelectListener;
    private OnMultiSelectListener multiSelectListener;
    private OnSingleSelectListener singleSelectListener;

    public int getSelectMode() {
        return this.selectMode;
    }

    public SelectHelper(Selectable selectable) {
        this.selectable = selectable;
        this.multiItems = new ArrayList();
    }

    public void setSelectMode(@SelectMode int mode) {
        this.selectMode = mode;
        switch (this.selectMode) {
            case 1: {
                this.end = -1;
                this.start = -1;
                this.singleCheckedIndex = -1;
                break;
            }
            case 2: {
                this.singleCheckedIndex = -1;
                this.multiItems.clear();
                break;
            }
            default: {
                this.end = -1;
                this.start = -1;
                this.multiItems.clear();
            }
        }
        this.selectable.setItemSelect(false);
    }

    public void setSingleSelectIndex(int index) {
        if (this.singleCheckedIndex != index) {
            if (-1 != index) {
                this.selectable.setItemSelect(index, true);
            }
            if (-1 != this.singleCheckedIndex) {
                this.selectable.setItemSelect(this.singleCheckedIndex, false);
            }
            this.singleCheckedIndex = index;
        }
    }

    public void setSingleSelectIndexCallback(View v, int index) {
        if (null != this.singleSelectListener) {
            this.singleSelectListener.onSelected(v, index, this.singleCheckedIndex);
        }
        this.setSingleSelectIndex(index);
    }

    public void setSelectIndex(View v, int index) {
        switch (this.selectMode) {
            case 1: {
                if (this.multiItems.contains(index)) {
                    this.selectable.setItemSelect(index, false);
                    this.multiItems.remove((Object)index);
                } else {
                    this.selectable.setItemSelect(index, true);
                    this.multiItems.add(index);
                }
                if (null == this.multiSelectListener) break;
                this.multiSelectListener.onMultiSelected(v, this.multiItems);
                break;
            }
            case 2: {
                if (-1 != this.start && -1 != this.end) {
                    this.selectable.setItemSelect(false);
                    this.end = -1;
                    this.start = -1;
                    break;
                }
                if (-1 == this.start) {
                    this.start = index;
                    this.selectable.setItemSelect(index, true);
                    break;
                }
                if (-1 != this.end) break;
                this.end = index;
                for (int i = Math.min(this.start, this.end); i <= Math.max(this.start, this.end); ++i) {
                    this.selectable.setItemSelect(i, true);
                }
                if (null == this.rectangleSelectListener) break;
                this.rectangleSelectListener.onRectangleSelected(this.start, this.end);
                break;
            }
            default: {
                this.setSingleSelectIndexCallback(v, index);
            }
        }
    }

    public void setOnSingleCheckListener(OnSingleSelectListener listener) {
        this.singleSelectListener = listener;
    }

    public void setOnMultiCheckListener(OnMultiSelectListener listener) {
        this.multiSelectListener = listener;
    }

    public void setOnRectangleCheckListener(OnRectangleSelectListener listener) {
        this.rectangleSelectListener = listener;
    }

    public int getSingleCheckedIndex() {
        return this.singleCheckedIndex;
    }

    public List<Integer> getMultiSelectIndex() {
        return this.multiItems;
    }

    public int getRectangleStartIndex() {
        return this.start;
    }

    public int getRectangleEndIndex() {
        return this.end;
    }

    public static @interface SelectMode {
    }
}

