/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.cz.library.R;
import com.cz.library.callback.OnMultiSelectListener;
import com.cz.library.callback.OnRectangleSelectListener;
import com.cz.library.callback.OnSingleSelectListener;
import com.cz.library.callback.Selectable;
import com.cz.library.widget.FlowLayout;
import com.cz.library.widget.SelectHelper;
import com.cz.library.widget.state.StateTextView;
import java.util.List;

public class SelectFlowLayout
extends FlowLayout
implements Selectable {
    private final SelectHelper selectHelper = new SelectHelper(this);
    private Drawable itemSelectorDrawable;
    private int state;

    public SelectFlowLayout(Context context) {
        this(context, null, 0);
    }

    public SelectFlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SelectFlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SelectFlowLayout);
        this.setButtonItemSelector(a.getDrawable(R.styleable.SelectFlowLayout_sl_buttonItemSelector));
        this.setState(a.getInt(R.styleable.SelectFlowLayout_sl_state, 0));
        a.recycle();
    }

    public void setButtonItemSelector(Drawable itemSelector) {
        this.itemSelectorDrawable = itemSelector;
        this.refreshItemSelector();
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public void setItemSelect(boolean select) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.setItemSelect(i, select);
        }
    }

    @Override
    public void setItemSelect(int index, boolean select) {
        View childView = this.getChildAt(index);
        if (0 == this.state) {
            childView.setSelected(select);
        } else if (childView instanceof StateTextView) {
            StateTextView stateTextView = (StateTextView)childView;
            stateTextView.setStateEnabled(this.state, select);
        }
    }

    public void setSingleSelectIndex(int index) {
        this.selectHelper.setSingleSelectIndex(index);
    }

    public void setSingleSelectIndexCallback(int index) {
        this.selectHelper.setSingleSelectIndexCallback(this.getChildAt(index), index);
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        this.setViewListener(child);
        this.setBackgroundDrawableCompat(child);
    }

    private void refreshItemSelector() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.setBackgroundDrawableCompat(this.getChildAt(i));
        }
    }

    private void setBackgroundDrawableCompat(View childView) {
        if (null != this.itemSelectorDrawable) {
            Drawable newDrawable = this.itemSelectorDrawable.getConstantState().newDrawable();
            if (Build.VERSION.SDK_INT < 16) {
                childView.setBackgroundDrawable(newDrawable);
            } else {
                childView.setBackground(newDrawable);
            }
        }
    }

    private void setViewListener(View view) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectFlowLayout.this.selectHelper.setSelectIndex(v, SelectFlowLayout.this.indexOfChild(v));
                SelectFlowLayout.this.invalidate();
            }
        });
    }

    @Override
    public void setOnSingleSelectListener(OnSingleSelectListener listener) {
        this.selectHelper.setOnSingleCheckListener(listener);
    }

    @Override
    public void setOnMultiSelectListener(OnMultiSelectListener listener) {
        this.selectHelper.setOnMultiCheckListener(listener);
    }

    @Override
    public void setOnRectangleSelectListener(OnRectangleSelectListener listener) {
        this.selectHelper.setOnRectangleCheckListener(listener);
    }

    @Override
    public int getSingleSelectedIndex() {
        return this.selectHelper.getSingleCheckedIndex();
    }

    @Override
    public List<Integer> getMultiSelectedIndex() {
        return this.selectHelper.getMultiSelectIndex();
    }

    @Override
    public int getRectangleStartIndex() {
        return this.selectHelper.getRectangleStartIndex();
    }

    @Override
    public int getRectangleEndIndex() {
        return this.selectHelper.getRectangleEndIndex();
    }
}

