/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ArrayRes;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.cz.library.R;

public class ProgressView
extends View {
    public Paint ringPaint;
    public Paint progressPaint = new Paint(1);
    public Paint backgroundPaint;
    public TextPaint textPaint;
    private float ringPadding;
    private int[] ringColorArray;
    private int[] levelArray;
    private int currentValue;
    private float currentDegrees;
    private int animDuration;
    private int progressStartAngle;

    public ProgressView(Context context) {
        this(context, null, R.attr.progressView);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.progressView);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.progressPaint.setStyle(Paint.Style.STROKE);
        this.ringPaint = new Paint(1);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.backgroundPaint = new Paint(1);
        this.textPaint = new TextPaint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressView, defStyleAttr, R.style.ProgressView);
        this.setTextSize(a.getDimensionPixelOffset(R.styleable.ProgressView_pv_textSize, 0));
        this.setTextColor(a.getColor(R.styleable.ProgressView_pv_textColor, -1));
        this.setRingColor(a.getColor(R.styleable.ProgressView_pv_ringColor, -12303292));
        this.setRingColorArray(a.getResourceId(R.styleable.ProgressView_pv_ringColorRes, -1));
        this.setRingSize(a.getDimension(R.styleable.ProgressView_pv_ringSize, 0.0f));
        this.setRingPadding(a.getDimension(R.styleable.ProgressView_pv_ringPadding, 0.0f));
        this.setLevelArray(a.getResourceId(R.styleable.ProgressView_pv_levelArray, -1));
        this.setCircleBackgroundColor(a.getColor(R.styleable.ProgressView_pv_circleBackgroundColor, -1));
        this.setAnimDuration(a.getInteger(R.styleable.ProgressView_pv_animDuration, 1000));
        this.setProgressPaintRound(a.getBoolean(R.styleable.ProgressView_pv_progressPaintRound, false));
        this.setProgressStartAngle(a.getInteger(R.styleable.ProgressView_pv_progressStartAngle, 0));
        a.recycle();
    }

    public void setTextSize(int textSize) {
        this.textPaint.setTextSize((float)textSize);
        this.invalidate();
    }

    public void setTextColor(int color2) {
        this.textPaint.setColor(color2);
        this.invalidate();
    }

    public void setRingColor(int color2) {
        this.ringPaint.setColor(color2);
        this.invalidate();
    }

    public void setRingColorArray(@ArrayRes int res) {
        this.setRingColorArray(this.getResources().getIntArray(res));
    }

    public void setRingColorArray(int[] colorArray) {
        this.ringColorArray = colorArray;
        this.invalidate();
    }

    public void setLevelArray(@ArrayRes int res) {
        if (-1 != res) {
            this.setLevelArray(this.getResources().getIntArray(res));
        }
    }

    public void setLevelArray(int[] levelArray) {
        this.levelArray = levelArray;
        this.currentValue = levelArray[0];
        this.invalidate();
    }

    public void setCurrentValue(int value) {
        int itemPosition = this.getItemPosition(value) - 1;
        int itemDegrees = 360 / (this.levelArray.length - 1);
        int startValue = this.levelArray[itemPosition];
        int itemValue = itemPosition < this.levelArray.length - 1 ? this.levelArray[itemPosition + 1] - startValue : startValue;
        float fraction = (float)(value - startValue) * 1.0f / (float)itemValue;
        this.currentDegrees = (float)(itemPosition * itemDegrees) + fraction * (float)itemDegrees;
        this.currentValue = value;
        this.invalidate();
    }

    public void setProgressPaintRound(boolean round) {
        this.progressPaint.setStrokeCap(round ? Paint.Cap.ROUND : Paint.Cap.BUTT);
    }

    public void setProgressStartAngle(int angle) {
        this.progressStartAngle = angle;
    }

    public void setRingSize(float size) {
        this.ringPaint.setStrokeWidth(size);
        this.progressPaint.setStrokeWidth(size);
        this.invalidate();
    }

    public void setRingPadding(float padding) {
        this.ringPadding = padding;
        this.requestLayout();
    }

    public void setCircleBackgroundColor(int color2) {
        this.backgroundPaint.setColor(color2);
        this.invalidate();
    }

    public void setAnimDuration(int duration) {
        this.animDuration = duration;
    }

    public int getMaxValue() {
        int value = 0;
        if (null != this.levelArray && 0 < this.levelArray.length) {
            value = this.levelArray[this.levelArray.length - 1];
        }
        return value;
    }

    public void invalidate() {
        if (this.hasWindowFocus()) {
            super.invalidate();
        }
    }

    public void postInvalidate(int left, int top, int right, int bottom) {
        if (this.hasWindowFocus()) {
            super.postInvalidate(left, top, right, bottom);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.progressPaint.setShader((Shader)new SweepGradient((float)(w / 2), (float)(h / 2), this.ringColorArray, null));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        float width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        String text = String.valueOf(this.currentValue);
        float textWidth = this.textPaint.measureText(text);
        Rect bounds = new Rect();
        this.textPaint.getTextBounds(text, 0, text.length(), bounds);
        float size = Math.max(textWidth, (float)bounds.height());
        if (Integer.MIN_VALUE == widthSpecMode) {
            width = size + this.ringPadding + this.progressPaint.getStrokeWidth();
        }
        if (Integer.MIN_VALUE == heightSpecMode) {
            height = size + this.ringPadding + this.progressPaint.getStrokeWidth();
        }
        this.setMeasuredDimension(ProgressView.resolveSize((int)((int)width), (int)widthMeasureSpec), ProgressView.resolveSize((int)((int)height), (int)heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)(Math.min(width, height) / 2), this.backgroundPaint);
        String text = String.valueOf(this.currentValue);
        canvas.drawText(text, ((float)width - this.textPaint.measureText(text, 0, text.length())) / 2.0f, ((float)height - (this.textPaint.descent() + this.textPaint.ascent())) / 2.0f, (Paint)this.textPaint);
        float strokeWidth = this.progressPaint.getStrokeWidth() / 2.0f;
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)(Math.min(width, height) / 2) - strokeWidth, this.ringPaint);
        canvas.save();
        canvas.rotate((float)(270 + this.progressStartAngle), (float)(width / 2), (float)(height / 2));
        if (Build.VERSION.SDK_INT < 21) {
            canvas.drawArc(new RectF(strokeWidth, strokeWidth, (float)width - strokeWidth, (float)height - strokeWidth), 0.0f, this.currentDegrees, false, this.progressPaint);
        } else {
            canvas.drawArc(strokeWidth, strokeWidth, (float)width - strokeWidth, (float)height - strokeWidth, 0.0f, this.currentDegrees, false, this.progressPaint);
        }
        canvas.restore();
    }

    public void setLevelValueTo(int endValue) {
        int startValue = this.currentValue;
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startValue, endValue});
        valueAnimator.setDuration((long)this.animDuration);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ProgressView.this.setCurrentValue((Integer)valueAnimator.getAnimatedValue());
            }
        });
        valueAnimator.start();
    }

    private int getItemPosition(int currentValue) {
        int[] positions = this.levelArray;
        int start = 0;
        int end = positions.length - 1;
        int result = -1;
        while (start <= end) {
            int middle = (start + end) / 2;
            if (currentValue == positions[middle]) {
                result = middle + 1;
                break;
            }
            if (currentValue < positions[middle]) {
                end = middle - 1;
                continue;
            }
            start = middle + 1;
        }
        return -1 == result ? start : result;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("super", super.onSaveInstanceState());
        bundle.putInt("value", this.currentValue);
        bundle.putFloat("degrees", this.currentDegrees);
        bundle.putFloat("ringPadding", this.ringPadding);
        bundle.putIntArray("levelArray", this.levelArray);
        bundle.putIntArray("colorArray", this.ringColorArray);
        bundle.putFloat("textSize", this.textPaint.getTextSize());
        bundle.putInt("textColor", this.textPaint.getColor());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        Parcelable superState = bundle.getParcelable("super");
        super.onRestoreInstanceState(superState);
        this.currentValue = bundle.getInt("value");
        this.currentDegrees = bundle.getFloat("degrees");
        this.ringPadding = bundle.getFloat("ringPadding");
        this.levelArray = bundle.getIntArray("levelArray");
        this.ringColorArray = bundle.getIntArray("colorArray");
        this.textPaint.setTextSize(bundle.getFloat("textSize"));
        this.textPaint.setColor(bundle.getInt("textColor"));
    }
}

