/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.os.Build;
import android.support.annotation.ArrayRes;
import android.support.v4.util.Pair;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.cz.library.R;
import java.util.ArrayList;
import java.util.List;

public class OvalDialView
extends View {
    private static final String TAG = "OvalDialView";
    private final boolean DEBUG = false;
    private final Paint ringPaint = new Paint(1);
    private final Paint fillPaint = new Paint(1);
    private final Paint levelPaint;
    private final TextPaint levelTextPaint;
    private final TextPaint levelValuePaint;
    private final TextPaint infoPaint;
    private final RectF ovalRect;
    private final Rect textRect;
    private final List<Pair<Path, Float>> pathItems;
    private CharSequence[] levelTextItems;
    private int[] ringColorArray;
    private int[] levelValueArray;
    private int levelMinValue;
    private int levelMaxValue;
    private int currentLevelValue;
    private float currentLevelDegrees;
    private int animDuration;
    private int itemCount;
    private int dialPadding;
    private float textPadding;
    private OnLevelValueChangeListener listener;
    private float levelStrokePadding;
    private float levelDivideSize;

    public OvalDialView(Context context) {
        this(context, null, 0);
    }

    public OvalDialView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OvalDialView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.fillPaint.setStyle(Paint.Style.STROKE);
        this.pathItems = new ArrayList<Pair<Path, Float>>();
        this.levelPaint = new Paint(1);
        this.levelTextPaint = new TextPaint(1);
        this.levelValuePaint = new TextPaint(1);
        this.infoPaint = new TextPaint(1);
        this.textRect = new Rect();
        this.ovalRect = new RectF();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OvalDialView, R.attr.ovalDialView, R.style.OvalDialView);
        this.setPaintColor(a.getColor(R.styleable.OvalDialView_ov_paintColor, 0));
        this.setStrokeWidth(a.getDimension(R.styleable.OvalDialView_ov_strokeWidth, 0.0f));
        this.setFillPaintColorArray(a.getResourceId(R.styleable.OvalDialView_ov_fillPaintColorArray, -1));
        this.setFillStrokeWidth(a.getDimension(R.styleable.OvalDialView_ov_fillStrokeWidth, 0.0f));
        this.setTextPadding(a.getDimension(R.styleable.OvalDialView_ov_textPadding, 0.0f));
        this.setCornerRound(a.getBoolean(R.styleable.OvalDialView_ov_cornerRound, true));
        this.setDialItemCount(a.getInteger(R.styleable.OvalDialView_ov_dialItemCount, 0));
        this.setLevelTextArray(a.getTextArray(R.styleable.OvalDialView_ov_dialLevelTextArray));
        this.setLevelDivideSize(a.getDimension(R.styleable.OvalDialView_ov_levelDivideSize, 0.0f));
        this.setLevelStrokePadding(a.getDimension(R.styleable.OvalDialView_ov_levelStrokePadding, 0.0f));
        int resId = a.getResourceId(R.styleable.OvalDialView_ov_levelValue, -1);
        if (-1 != resId) {
            this.setLevelValue(this.getResources().getIntArray(resId));
        }
        this.setLevelStrokeWidth(a.getDimension(R.styleable.OvalDialView_ov_levelStrokeWidth, 0.0f));
        this.setLevelDivideColor(a.getColor(R.styleable.OvalDialView_ov_levelDivideColor, 0));
        this.setDialPadding((int)a.getDimension(R.styleable.OvalDialView_ov_dialPadding, 0.0f));
        this.setLevelTextSize(a.getDimensionPixelSize(R.styleable.OvalDialView_ov_levelTextSize, 0));
        this.setLevelTextColor(a.getColor(R.styleable.OvalDialView_ov_levelTextColor, 0));
        this.setLevelInfoTextSize(a.getDimensionPixelSize(R.styleable.OvalDialView_ov_levelInfoTextSize, 0));
        this.setLevelInfoTextColor(a.getColor(R.styleable.OvalDialView_ov_levelInfoTextColor, 0));
        this.setLevelValueTextSize(a.getDimensionPixelSize(R.styleable.OvalDialView_ov_levelValueTextSize, 0));
        this.setLevelValueTextColor(a.getColor(R.styleable.OvalDialView_ov_levelValueTextColor, 0));
        this.setLevelAnimDuration(a.getInteger(R.styleable.OvalDialView_ov_levelAnimDuration, 300));
        a.recycle();
    }

    private void setTextPadding(float textPadding) {
        this.textPadding = textPadding;
        this.invalidate();
    }

    public void setStrokeWidth(float width) {
        this.ringPaint.setStrokeWidth(width);
        this.invalidate();
    }

    public void setPaintColor(int color2) {
        this.ringPaint.setColor(color2);
        this.invalidate();
    }

    public void setFillPaintColorArray(@ArrayRes int res) {
        if (-1 != res) {
            this.setFillPaintColorArray(this.getResources().getIntArray(res));
        }
    }

    public void setFillPaintColorArray(int[] colorArray) {
        this.ringColorArray = colorArray;
        this.invalidate();
    }

    public void setFillStrokeWidth(float strokeWidth) {
        this.fillPaint.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    public void setDialItemCount(int count) {
        this.itemCount = count;
        this.invalidate();
    }

    public void setCornerRound(boolean round) {
        this.ringPaint.setStrokeCap(round ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.fillPaint.setStrokeCap(round ? Paint.Cap.ROUND : Paint.Cap.BUTT);
    }

    public void setLevelDivideSize(float size) {
        this.levelDivideSize = size;
        this.invalidate();
    }

    public void setLevelStrokePadding(float strokePadding) {
        this.levelStrokePadding = strokePadding;
        this.invalidate();
    }

    public void setLevelTextSize(int textSize) {
        this.levelTextPaint.setTextSize((float)textSize);
        this.invalidate();
    }

    public void setLevelInfoTextSize(int textSize) {
        this.infoPaint.setTextSize((float)textSize);
        this.invalidate();
    }

    public void setLevelValueTextSize(int textSize) {
        this.levelValuePaint.setTextSize((float)textSize);
        this.invalidate();
    }

    public void setLevelValueTextColor(int color2) {
        this.levelValuePaint.setColor(color2);
        this.invalidate();
    }

    public void setLevelTextColor(int color2) {
        this.levelTextPaint.setColor(color2);
        this.invalidate();
    }

    private void setLevelInfoTextColor(int color2) {
        this.infoPaint.setColor(color2);
        this.invalidate();
    }

    public void setDialPadding(int padding) {
        this.dialPadding = padding;
        this.invalidate();
    }

    public void setLevelTextArray(CharSequence[] items) {
        if (null == items || items.length < this.itemCount) {
            throw new IllegalArgumentException("items's height must be the same as item count!");
        }
        this.levelTextItems = items;
        this.invalidate();
    }

    public void setLevelAnimDuration(int duration) {
        this.animDuration = duration;
    }

    public void setLevelDivideColor(int color2) {
        this.levelPaint.setColor(color2);
        this.invalidate();
    }

    public void setLevelStrokeWidth(float strokeWidth) {
        this.levelPaint.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    public void setLevelValue(int[] array) {
        if (null == array || array.length < this.itemCount) {
            throw new IllegalArgumentException("items's height must be the same as item count!");
        }
        this.levelValueArray = array;
        this.currentLevelValue = array[0];
        this.levelMinValue = array[0];
        this.levelMaxValue = array[array.length - 1];
        this.invalidate();
    }

    public int getMinLevelValue() {
        return this.levelMinValue;
    }

    public int getMaxLevelValue() {
        return this.levelMaxValue;
    }

    public int getCurrentLevelValue() {
        return this.currentLevelValue;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int width = this.getWidth();
        int height = this.getHeight();
        int centerX = width / 2;
        int centerY = height / 2;
        float radius = (float)(Math.min(width, height) / 2) - this.ringPaint.getStrokeWidth() - this.levelStrokePadding * 2.0f - this.levelDivideSize;
        this.ovalRect.set((float)centerX - radius, (float)centerY - radius, (float)centerX + radius, (float)centerY + radius);
        this.pathItems.clear();
        float itemDegrees = 360.0f / (float)this.itemCount;
        for (int i = 0; i < this.itemCount; ++i) {
            Path path = new Path();
            path.addArc(this.ovalRect, (float)i * itemDegrees, itemDegrees);
            PathMeasure pathMeasure = new PathMeasure(path, false);
            this.pathItems.add((Pair<Path, Float>)new Pair((Object)path, (Object)Float.valueOf(pathMeasure.getLength())));
        }
        if (null != this.ringColorArray) {
            this.fillPaint.setShader((Shader)new SweepGradient((float)(w / 2), (float)(h / 2), this.ringColorArray, null));
        }
    }

    public void setLevelValue(int value) {
        int itemPosition = this.getItemPosition(value) - 1;
        if (itemPosition < this.levelValueArray.length - 1) {
            int itemDegrees = 360 / this.itemCount;
            int startValue = this.levelValueArray[itemPosition];
            int itemValue = this.levelValueArray[itemPosition + 1] - startValue;
            float fraction = (float)(value - startValue) * 1.0f / (float)itemValue;
            this.currentLevelDegrees = (float)(itemPosition * itemDegrees) + fraction * (float)itemDegrees;
            this.currentLevelValue = value;
            this.invalidate();
        }
    }

    public void setLevelValueTo(final int endValue) {
        if (this.levelMinValue <= endValue && this.levelMaxValue >= endValue) {
            int startValue = this.currentLevelValue;
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startValue, endValue});
            valueAnimator.setDuration((long)this.animDuration);
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    Integer value = Integer.valueOf(valueAnimator.getAnimatedValue().toString());
                    int itemPosition = OvalDialView.this.getItemPosition(value) - 1;
                    if (itemPosition < OvalDialView.this.levelValueArray.length - 1) {
                        int itemDegrees = 360 / OvalDialView.this.itemCount;
                        int startValue = OvalDialView.this.levelValueArray[itemPosition];
                        int itemValue = OvalDialView.this.levelValueArray[itemPosition + 1] - startValue;
                        float fraction = (float)(value - startValue) * 1.0f / (float)itemValue;
                        OvalDialView.this.currentLevelDegrees = (float)(itemPosition * itemDegrees) + fraction * (float)itemDegrees;
                        OvalDialView.this.currentLevelValue = value;
                        if (null != OvalDialView.this.listener) {
                            OvalDialView.this.listener.onLevelValueChanged(startValue, value, endValue, itemPosition, fraction);
                        }
                        OvalDialView.this.invalidate();
                    }
                }
            });
            valueAnimator.start();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        long st = System.currentTimeMillis();
        int width = this.getWidth();
        int height = this.getHeight();
        int centerX = width / 2;
        int centerY = height / 2;
        float itemDegrees = 360.0f / (float)this.itemCount;
        float radius = (float)(Math.min(width, height) / 2 - this.dialPadding) - this.ringPaint.getStrokeWidth() / 2.0f;
        this.drawRing(canvas, centerX, centerY, itemDegrees, radius);
        this.drawRingItems(canvas, itemDegrees, centerX, centerY);
        this.drawLevelItems(canvas, centerX, centerY);
        this.drawLevelTextValue(canvas, width, height);
    }

    private void drawRing(Canvas canvas, int centerX, int centerY, float itemDegrees, float radius) {
        canvas.save();
        canvas.rotate((180.0f - itemDegrees) / 2.0f, (float)centerX, (float)centerY);
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawArc((float)centerX - radius, (float)centerY - radius, (float)centerX + radius, (float)centerY + radius, itemDegrees, 360.0f - itemDegrees, false, this.ringPaint);
        } else {
            canvas.drawArc(new RectF((float)centerX - radius, (float)centerY - radius, (float)centerX + radius, (float)centerY + radius), itemDegrees, 360.0f - itemDegrees, false, this.ringPaint);
        }
        int sweepAngle = (int)(360.0f * (this.currentLevelDegrees * 1.0f / 360.0f));
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawArc((float)centerX - radius, (float)centerY - radius, (float)centerX + radius, (float)centerY + radius, itemDegrees, 0 == sweepAngle ? 1.0f : (float)sweepAngle, false, this.fillPaint);
        } else {
            canvas.drawArc(new RectF((float)centerX - radius, (float)centerY - radius, (float)centerX + radius, (float)centerY + radius), itemDegrees, 0 == sweepAngle ? 1.0f : (float)sweepAngle, false, this.fillPaint);
        }
        canvas.restore();
    }

    private void drawLevelItems(Canvas canvas, int centerX, int centerY) {
        if (this.levelMinValue != this.levelMaxValue && this.levelMaxValue - this.levelMinValue > this.itemCount) {
            for (int i = 0; i < this.itemCount; ++i) {
                String text = String.valueOf(this.levelValueArray[i]);
                float textWidth = this.levelValuePaint.measureText(text, 0, text.length());
                this.levelValuePaint.getTextBounds(text, 0, text.length(), this.textRect);
                Pair<Path, Float> item = this.pathItems.get(i);
                canvas.save();
                canvas.rotate(90.0f, (float)centerX, (float)centerY);
                canvas.drawTextOnPath(text, (Path)item.first, (((Float)item.second).floatValue() - textWidth) / 2.0f, (float)this.textRect.height(), (Paint)this.levelValuePaint);
                canvas.restore();
            }
        }
    }

    private void drawRingItems(Canvas canvas, float itemDegrees, int centerX, int centerY) {
        float outPadding = (float)this.dialPadding + this.ringPaint.getStrokeWidth() + this.levelStrokePadding;
        for (int i = 0; i < this.itemCount; ++i) {
            canvas.save();
            canvas.rotate(itemDegrees * (float)i, (float)centerX, (float)centerY);
            canvas.drawLine((float)centerX, outPadding, (float)centerX, outPadding + this.levelDivideSize, this.levelPaint);
            canvas.restore();
        }
    }

    private void drawLevelTextValue(Canvas canvas, int width, int height) {
        int itemPosition;
        CharSequence text;
        String value = String.valueOf(this.currentLevelValue);
        float textWidth = this.levelTextPaint.measureText(value, 0, value.length());
        float levelValueTextTop = -(this.levelTextPaint.descent() + this.levelTextPaint.ascent());
        float levelInfoTextTop = -(this.infoPaint.descent() + this.infoPaint.ascent()) + levelValueTextTop;
        canvas.save();
        canvas.translate(0.0f, ((float)height - levelInfoTextTop) / 2.0f);
        canvas.drawText(value, ((float)width - textWidth) / 2.0f, levelValueTextTop, (Paint)this.levelTextPaint);
        if (null != this.levelTextItems && this.levelTextItems.length == this.itemCount && !TextUtils.isEmpty((CharSequence)(text = this.levelTextItems[itemPosition = this.getItemPosition(this.currentLevelValue) - 1]))) {
            textWidth = this.infoPaint.measureText(text, 0, text.length());
            canvas.drawText(text.toString(), ((float)width - textWidth) / 2.0f, -(this.infoPaint.descent() + this.infoPaint.ascent()) + levelValueTextTop + this.textPadding, (Paint)this.infoPaint);
        }
        canvas.restore();
    }

    private int getItemPosition(int currentValue) {
        int[] positions = this.levelValueArray;
        int start = 0;
        int end = positions.length - 1;
        int result = -1;
        while (start <= end) {
            int middle = (start + end) / 2;
            if (currentValue == positions[middle]) {
                result = middle + 1;
                break;
            }
            if (currentValue < positions[middle]) {
                end = middle - 1;
                continue;
            }
            start = middle + 1;
        }
        return -1 == result ? start : result;
    }

    public void setOnLevelValueChangeListener(OnLevelValueChangeListener listener) {
        this.listener = listener;
    }

    public static interface OnLevelValueChangeListener {
        public void onLevelValueChanged(int var1, int var2, int var3, int var4, float var5);
    }
}

