/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ArrayRes;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.cz.library.R;
import com.cz.library.callback.OnCheckedListener;
import com.cz.library.util.Utils;
import com.cz.library.widget.drawable.DrawableBuilder;
import com.cz.library.widget.drawable.RectDrawableBuilder;
import com.cz.library.widget.selector.SelectState;
import com.cz.library.widget.selector.SelectorBuilder;

public class OptionGroup
extends RadioGroup {
    public static final int GROUP_EDGE = 0;
    public static final int ITEM_EDGE = 1;
    private static final int WRAP_CONTENT = 0;
    private static final int WEIGHT = 1;
    private static final int TEXT_SIZE = 14;
    private static final int DEFAULT_TEXT_PADDING = 0;
    private static final int DEFAULT_BUTTON_ROUND = 4;
    private final int DEFAULT_COLOR = -16711936;
    private int dividerSize;
    private int dividerColor;
    private int backgroundColor;
    private ColorStateList colorStateList;
    private int selectColor;
    private int pressColor;
    private int defaultColor;
    private float roundRadius;
    private int itemHorizontalPadding;
    private int itemVerticalPadding;
    private float itemTextSize;
    private int itemMargin;
    private int selectPosition;
    private int itemWidthMode;
    private int edgeMode;
    private OnCheckedListener listener;
    private Paint paint;

    public OptionGroup(Context context) {
        this(context, null);
    }

    public OptionGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.setOrientation(0);
        this.paint = new Paint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OptionGroup);
        this.setItemWidthMode(a.getInt(R.styleable.OptionGroup_og_itemWidthMode, 0));
        this.setBackGroundColor(a.getColor(R.styleable.OptionGroup_og_backGroundColor, 0));
        this.setDividerSize((int)a.getDimension(R.styleable.OptionGroup_og_divideSize, (float)Utils.dip2px(1.0f)));
        this.setDivideColor(a.getColor(R.styleable.OptionGroup_og_divideColor, -16711936));
        this.setRoundRadius(a.getDimension(R.styleable.OptionGroup_og_roundRadius, (float)Utils.dip2px(4.0f)));
        this.setItemTextSize(a.getDimensionPixelSize(R.styleable.OptionGroup_og_itemTextSize, 14));
        this.setItemMargin((int)a.getDimension(R.styleable.OptionGroup_og_itemMargin, 0.0f));
        this.setItemHorizontalPadding(a.getDimension(R.styleable.OptionGroup_og_itemHorizontalPadding, (float)Utils.dip2px(0.0f)));
        this.setItemVerticalPadding(a.getDimension(R.styleable.OptionGroup_og_itemVerticalPadding, (float)Utils.dip2px(0.0f)));
        this.setItemTextSelector(a.getColorStateList(R.styleable.OptionGroup_og_itemTextSelector));
        this.edgeMode = a.getInt(R.styleable.OptionGroup_og_itemEdgeMode, 0);
        this.setSelectColor(a.getColor(R.styleable.OptionGroup_og_selectColor, -16711936));
        this.setPressColor(a.getColor(R.styleable.OptionGroup_og_pressColor, -16711936));
        this.setDefaultColor(a.getColor(R.styleable.OptionGroup_og_defaultColor, 0));
        this.setItems(a.getTextArray(R.styleable.OptionGroup_og_items));
        a.recycle();
    }

    public void setItemWidthMode(int mode) {
        this.itemWidthMode = mode;
        if (0 == mode) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = this.getChildAt(i);
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)childView.getLayoutParams();
                layoutParams.width = -2;
            }
        } else if (1 == mode) {
            int childCount = this.getChildCount();
            this.setWeightSum(childCount);
            for (int i = 0; i < childCount; ++i) {
                View childView = this.getChildAt(i);
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)childView.getLayoutParams();
                layoutParams.weight = 1.0f;
            }
        }
        this.requestLayout();
    }

    public void setItemEdgeMode(@EdgeMode int mode) {
        this.edgeMode = mode;
        this.refreshItems();
    }

    public void setRoundRadius(float radius) {
        this.roundRadius = radius;
        this.refreshItems();
    }

    public void setDefaultColor(int color2) {
        this.defaultColor = color2;
        this.refreshItems();
    }

    public void setSelectColor(int color2) {
        this.selectColor = color2;
        this.refreshItems();
    }

    public void setPressColor(int color2) {
        this.pressColor = color2;
        this.refreshItems();
    }

    public void setItems(@ArrayRes int res) {
        if (-1 != res) {
            this.setItems(this.getResources().getStringArray(res));
        }
    }

    public void setItems(CharSequence[] items) {
        if (null != items) {
            this.initItems(items);
        }
    }

    public void setItemTextSize(float textSize) {
        this.itemTextSize = textSize;
        this.refreshItems();
    }

    public void setItemHorizontalPadding(float padding) {
        this.itemHorizontalPadding = (int)padding;
        this.refreshItems();
    }

    public void setItemVerticalPadding(float padding) {
        this.itemVerticalPadding = (int)padding;
        this.refreshItems();
    }

    public void setItemTextSelector(ColorStateList stateList) {
        this.colorStateList = stateList;
        this.refreshItems();
    }

    public void setItemMargin(int margin) {
        this.itemMargin = margin;
        this.refreshItems();
    }

    private void initItems(final CharSequence[] titles) {
        this.removeAllViews();
        RadioGroup.LayoutParams layoutParams = null;
        int length = titles.length;
        for (int i = 0; i < length; ++i) {
            RadioButton button = new RadioButton(this.getContext());
            button.setButtonDrawable((Drawable)new ColorDrawable(0));
            button.setGravity(17);
            button.setText(titles[i]);
            if (null != this.colorStateList) {
                button.setTextColor(this.colorStateList);
            }
            button.setTextSize(this.itemTextSize);
            this.setButtonBackground((View)button, i, length);
            button.setPadding(this.itemHorizontalPadding, this.itemVerticalPadding, this.itemHorizontalPadding, this.itemVerticalPadding);
            final int index = i;
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != titles) {
                        OptionGroup.this.setChecked(index);
                        if (null != OptionGroup.this.listener) {
                            OptionGroup.this.listener.onChecked(v, index, titles[index]);
                        }
                    }
                }
            });
            if (0 == this.itemWidthMode) {
                layoutParams = new RadioGroup.LayoutParams(-2, -1);
                layoutParams.setMargins(this.itemMargin, this.itemMargin, this.itemMargin, this.itemMargin);
            } else if (1 == this.itemWidthMode) {
                layoutParams = new RadioGroup.LayoutParams(0, -1, 1.0f);
            }
            if (null == layoutParams) continue;
            this.addView((View)button, (ViewGroup.LayoutParams)layoutParams);
        }
        this.setChecked(this.selectPosition);
    }

    private void refreshItems() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (!(childView instanceof TextView)) continue;
            TextView itemView = (TextView)childView;
            itemView.setTextSize(this.itemTextSize);
            this.setButtonBackground(childView, i, childCount);
            if (null != this.colorStateList) {
                itemView.setTextColor(this.colorStateList);
            }
            itemView.setPadding(this.itemHorizontalPadding, this.itemVerticalPadding, this.itemHorizontalPadding, this.itemVerticalPadding);
        }
        RectDrawableBuilder rect = DrawableBuilder.rect();
        if (0 == this.edgeMode) {
            rect.setCornersRadius(this.roundRadius);
        }
        this.setBackgroundDrawable((Drawable)rect.setStrokeWidth(this.dividerSize).setStrokeColor(this.dividerColor).setSolidColor(this.backgroundColor).build());
    }

    private void setTextColorByPosition(int index, boolean isSelect) {
        View childView = this.getChildAt(index);
        if (null != childView && childView instanceof RadioButton) {
            childView.setSelected(isSelect);
        }
    }

    private void setButtonBackground(View view, int i, int length) {
        RectDrawableBuilder pressDrawableBuilder = DrawableBuilder.rect();
        RectDrawableBuilder selectDrawableBuilder = DrawableBuilder.rect();
        RectDrawableBuilder emptyDrawableBuilder = DrawableBuilder.rect();
        if (0 == this.edgeMode) {
            if (0 == i) {
                pressDrawableBuilder.setLeftTopRadius(this.roundRadius).setLeftBottomRadius(this.roundRadius).setPadding(this.dividerSize);
                selectDrawableBuilder.setLeftTopRadius(this.roundRadius).setLeftBottomRadius(this.roundRadius).setPadding(this.dividerSize);
                emptyDrawableBuilder.setLeftTopRadius(this.roundRadius).setLeftBottomRadius(this.roundRadius).setPadding(this.dividerSize);
            } else if (i == length - 1) {
                pressDrawableBuilder.setRightTopRadius(this.roundRadius).setRightBottomRadius(this.roundRadius).setPadding(this.dividerSize);
                selectDrawableBuilder.setRightTopRadius(this.roundRadius).setRightBottomRadius(this.roundRadius).setPadding(this.dividerSize);
                emptyDrawableBuilder.setRightTopRadius(this.roundRadius).setRightBottomRadius(this.roundRadius).setPadding(this.dividerSize);
            }
        } else {
            pressDrawableBuilder.setCornersRadius(this.roundRadius).setPadding(this.dividerSize);
            selectDrawableBuilder.setCornersRadius(this.roundRadius).setPadding(this.dividerSize);
            emptyDrawableBuilder.setCornersRadius(this.roundRadius).setPadding(this.dividerSize);
        }
        view.setBackgroundDrawable((Drawable)new SelectorBuilder().addState(SelectState.PRESSED_ENABLED, (Drawable)pressDrawableBuilder.setSolidColor(this.pressColor).build()).addState(SelectState.ENABLED_SELECTED, (Drawable)selectDrawableBuilder.setSolidColor(this.selectColor).build()).addState(SelectState.EMPTY, (Drawable)emptyDrawableBuilder.setSolidColor(this.defaultColor).build()).build());
    }

    public void setDividerSize(int size) {
        this.dividerSize = size;
        this.invalidate();
    }

    public void setBackGroundColor(int color2) {
        this.backgroundColor = color2;
        this.refreshItems();
    }

    public void setDivideColor(int color2) {
        this.dividerColor = color2;
        RectDrawableBuilder rect = DrawableBuilder.rect();
        if (0 == this.edgeMode) {
            rect.setCornersRadius(this.roundRadius);
        }
        this.setBackgroundDrawable((Drawable)rect.setStrokeWidth(this.dividerSize).setStrokeColor(this.dividerColor).setSolidColor(this.backgroundColor).build());
    }

    public void setChecked(int position) {
        this.setTextColorByPosition(this.selectPosition, false);
        this.setTextColorByPosition(position, true);
        this.selectPosition = position;
    }

    public void setOnCheckedListener(OnCheckedListener listener) {
        this.listener = listener;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawDivide(canvas);
    }

    private void drawDivide(Canvas canvas) {
        int length = this.getChildCount();
        if (0 != length) {
            this.paint.setColor(this.dividerColor);
            this.paint.setStrokeWidth((float)this.dividerSize);
            for (int i = 0; i < length - 1; ++i) {
                View childView = this.getChildAt(i);
                canvas.drawLine((float)childView.getRight(), 0.0f, (float)childView.getRight(), (float)this.getHeight(), this.paint);
            }
        }
    }

    public static @interface EdgeMode {
    }
}

