/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.cz.library.R;
import com.cz.library.callback.OnItemClickListener;
import com.cz.library.util.ViewCompat;
import com.cz.library.widget.DivideLinearLayout;

public class IndicateLayout<T>
extends DivideLinearLayout {
    private static final String TAG = "IndicateView";
    public static final int START = 0;
    public static final int CENTER = 1;
    public static final int END = 2;
    public static final int FROM_START = 0;
    public static final int FROM_END = 1;
    private final LayoutInflater layoutInflater;
    private final TextPaint textPaint;
    private final Paint dividePaint;
    private final Paint selectDividePaint;
    private final Paint backgroundPaint;
    private float indicatePadding;
    private float indicateSize;
    private Drawable indicateDrawable;
    private Drawable selectIndicateDrawable;
    private OnTemplateAddedListener listener;
    private OnItemClickListener itemClickListener;
    private OnDrawIndicatorTextCallback drawIndicatorTextCallback;
    private float selectIndicatePadding;
    private int templateLayout;
    private int selectStartIndex;
    private boolean showEdgeDevice;
    private float indicatorStartOffset;
    private int gravity;
    private int from;

    public IndicateLayout(Context context) {
        this(context, null);
    }

    public IndicateLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        ViewCompat.setDefaultViewTranslation((ViewGroup)this);
        this.layoutInflater = LayoutInflater.from((Context)context);
        this.textPaint = new TextPaint(1);
        this.dividePaint = new Paint(1);
        this.selectDividePaint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IndicateLayout, R.attr.indicatorView, R.style.IndicatorView);
        this.setShowEdgeDivide(a.getBoolean(R.styleable.IndicateLayout_iv_showEdgeDivide, false));
        this.setTemplateLayout(a.getResourceId(R.styleable.IndicateLayout_iv_templateLayout, -1));
        this.setTextColor(a.getColor(R.styleable.IndicateLayout_iv_textColor, -1));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.IndicateLayout_iv_textSize, 0));
        this.setIndicatePadding(a.getDimension(R.styleable.IndicateLayout_iv_indicatePadding, 0.0f));
        this.setIndicateDivideColor(a.getColor(R.styleable.IndicateLayout_iv_divideColor, -1));
        this.setIndicateDivideSize(a.getDimension(R.styleable.IndicateLayout_iv_divideSize, 0.0f));
        this.setIndicateBackground(a.getColor(R.styleable.IndicateLayout_iv_indicateBackground, -1));
        this.setIndicateDrawable(a.getDrawable(R.styleable.IndicateLayout_iv_indicateDrawable));
        this.setIndicateSize(a.getDimension(R.styleable.IndicateLayout_iv_indicateSize, 0.0f));
        this.setSelectIndicatePadding(a.getDimension(R.styleable.IndicateLayout_iv_selectIndicatePadding, 0.0f));
        this.setSelectIndicateDrawable(a.getDrawable(R.styleable.IndicateLayout_iv_selectIndicateDrawable));
        this.setSelectDivideColor(a.getColor(R.styleable.IndicateLayout_iv_selectDivideColor, -1));
        this.setSelectDivideSize(a.getDimension(R.styleable.IndicateLayout_iv_selectDivideSize, 0.0f));
        this.setFromInner(a.getInt(R.styleable.IndicateLayout_iv_from, 0));
        this.setIndicatorStartOffset(a.getDimension(R.styleable.IndicateLayout_iv_indicatorStartOffset, 0.0f));
        this.gravity = a.getInt(R.styleable.IndicateLayout_iv_indicateGravity, 0);
        a.recycle();
    }

    public void setIndicatorStartOffset(float offset) {
        this.indicatorStartOffset = offset;
        this.invalidate();
    }

    public void setShowEdgeDivide(boolean show) {
        this.showEdgeDevice = show;
        this.invalidate();
    }

    public void setTemplateLayout(int layoutId) {
        this.templateLayout = layoutId;
    }

    public void setTextSize(float textSize) {
        this.textPaint.setTextSize(textSize);
        this.invalidate();
    }

    public void setTextColor(int color) {
        this.textPaint.setColor(color);
        this.invalidate();
    }

    public void setIndicatePadding(float padding) {
        this.indicatePadding = padding;
        this.invalidate();
    }

    public void setIndicateDivideSize(float size) {
        this.dividePaint.setStrokeWidth(size);
        this.invalidate();
    }

    public void setIndicateDivideColor(int color) {
        this.dividePaint.setColor(color);
        this.invalidate();
    }

    public void setIndicateBackground(int color) {
        this.backgroundPaint.setColor(color);
    }

    public void setIndicateDrawable(int color) {
        this.setIndicateDrawable((Drawable)new ColorDrawable(color));
    }

    public void setIndicateDrawable(Drawable drawable) {
        if (null != drawable) {
            this.indicateDrawable = drawable;
            this.invalidate();
        }
    }

    public void setSelectIndicatePadding(float padding) {
        this.selectIndicatePadding = padding;
        this.invalidate();
    }

    public void setSelectIndicateDrawable(int color) {
        this.setSelectIndicateDrawable((Drawable)new ColorDrawable(color));
    }

    public void setSelectIndicateDrawable(Drawable drawable) {
        if (null != drawable) {
            this.selectIndicateDrawable = drawable;
            this.invalidate();
        }
    }

    public void setIndicateSize(float size) {
        this.indicateSize = size;
        this.invalidate();
    }

    public void setSelectDivideColor(int color) {
        this.selectDividePaint.setColor(color);
        this.invalidate();
    }

    public void setSelectDivideSize(float divideSize) {
        this.selectDividePaint.setStrokeWidth(divideSize);
        this.invalidate();
    }

    public void setSelectStartIndex(int index) {
        if (0 <= index && index < this.getChildCount()) {
            this.selectStartIndex = index;
        }
    }

    public void addTemplateLayout(T item) {
        if (-1 != this.templateLayout) {
            View newLayout = this.layoutInflater.inflate(this.templateLayout, (ViewGroup)this, false);
            if (null != this.listener) {
                this.listener.onTemplateAdded(newLayout, item);
            }
            this.addView(newLayout, -1, -2);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (null != this.itemClickListener) {
            child.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    IndicateLayout.this.itemClickListener.onItemClick(v, IndicateLayout.this.indexOfChild(v));
                }
            });
        }
    }

    private void setFromInner(int from) {
        this.setFrom(from);
    }

    public void setFrom(@IndicateFrom int from) {
        this.from = from;
        this.invalidate();
    }

    public void setIndicateGravity(@IndicateGravity int gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        int orientation = this.getOrientation();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)childView.getLayoutParams();
            if (1 == orientation) {
                layoutParams.leftMargin = (int)this.indicateSize;
                continue;
            }
            if (0 != orientation) continue;
            layoutParams.topMargin = (int)this.indicateSize;
        }
        this.requestLayout();
    }

    private float getStartX() {
        float startX = this.getViewFromStart();
        if (1 == this.getOrientation()) {
            startX = this.indicateSize / 2.0f;
        }
        return startX;
    }

    private float getStartY() {
        float startY = this.getViewFromStart();
        if (0 == this.getOrientation()) {
            startY = this.indicateSize / 2.0f;
        }
        return startY;
    }

    private float getViewFromStart() {
        float from = 0.0f;
        int childCount = this.getChildCount();
        if (0 < childCount && !this.showEdgeDevice) {
            View childView = this.getChildAt(0);
            if (1 == this.getOrientation()) {
                if (1 == this.gravity) {
                    from = (childView.getBottom() + childView.getTop()) / 2;
                } else if (2 == this.gravity) {
                    from = childView.getBottom();
                }
            } else if (0 == this.getOrientation()) {
                if (1 == this.gravity) {
                    from = (childView.getRight() + childView.getLeft()) / 2;
                } else if (2 == this.gravity) {
                    from = childView.getRight();
                }
            }
        }
        return from;
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (0 < this.getChildCount()) {
            float startX = this.getStartX();
            float startY = this.getStartY();
            this.drawDivide(canvas, startX, startY);
            this.drawIndicatorItem(canvas, startX, startY);
        }
    }

    private void drawIndicatorItem(Canvas canvas, float startX, float startY) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            String text = null;
            if (null != this.drawIndicatorTextCallback) {
                text = this.drawIndicatorTextCallback.callText(i);
            }
            if (!TextUtils.isEmpty(text)) {
                this.drawText(canvas, text, startX, startY, i);
                continue;
            }
            this.drawIndicatorDrawable(canvas, startX, startY, i);
        }
    }

    private void drawDivide(Canvas canvas, float startX, float startY) {
        int width = this.getWidth();
        int height = this.getHeight();
        int orientation = this.getOrientation();
        float radius = (this.indicateSize - this.indicatePadding) / 2.0f;
        if (1 == orientation) {
            canvas.drawRect(0.0f, 0.0f, this.indicateSize, (float)height, this.backgroundPaint);
            PointF startPoint = this.getCenterPoint(0, startX, startY, radius);
            if (0 < this.selectStartIndex && this.selectStartIndex < this.getChildCount()) {
                PointF selectPoint = this.getCenterPoint(this.selectStartIndex, startX, startY, radius);
                canvas.drawLine(this.indicateSize / 2.0f, startPoint.y, this.indicateSize / 2.0f, selectPoint.y, this.selectDividePaint);
                startPoint = selectPoint;
            }
            PointF endPoint = this.getCenterPoint(this.getChildCount() - 1, startX, startY, radius);
            canvas.drawLine(this.indicateSize / 2.0f, startPoint.y, this.indicateSize / 2.0f, endPoint.y, this.dividePaint);
        } else if (0 == orientation) {
            canvas.drawRect(0.0f, 0.0f, (float)width, this.indicateSize, this.backgroundPaint);
            PointF startPoint = this.getCenterPoint(0, startX, startY, radius);
            if (0 < this.selectStartIndex && this.selectStartIndex < this.getChildCount()) {
                PointF selectPoint = this.getCenterPoint(this.selectStartIndex, startX, startY, radius);
                canvas.drawLine(startPoint.x, this.indicateSize / 2.0f, selectPoint.x, this.indicateSize / 2.0f, this.selectDividePaint);
                startPoint = selectPoint;
            }
            PointF endPoint = this.getCenterPoint(this.getChildCount() - 1, startX, startY, radius);
            canvas.drawLine(startPoint.x, this.indicateSize / 2.0f, endPoint.x, this.indicateSize / 2.0f, this.selectDividePaint);
        }
    }

    private void drawText(Canvas canvas, String text, float startX, float startY, int index) {
        Rect textRect = new Rect();
        Rect outRect = new Rect();
        View childView = this.getChildAt(index);
        childView.getHitRect(outRect);
        int orientation = this.getOrientation();
        this.textPaint.getTextBounds(text, 0, text.length(), textRect);
        float textWidth = this.textPaint.measureText(text);
        Paint.FontMetrics fm = this.textPaint.getFontMetrics();
        float centerBaselineY = (float)(textRect.height() / 2) - fm.descent + (fm.descent - fm.ascent) / 2.0f;
        float radius = (this.indicateSize - this.textPaint.getStrokeWidth() / 2.0f) / 2.0f;
        float textLeft = 0.0f;
        float textTop = 0.0f;
        float circleX = 0.0f;
        float circleY = 0.0f;
        if (1 == orientation) {
            switch (this.gravity) {
                case 0: {
                    textTop = (float)outRect.top + radius + centerBaselineY / 2.0f;
                    circleY = (float)outRect.top + radius;
                    break;
                }
                case 1: {
                    textTop = (float)outRect.centerY() + centerBaselineY / 2.0f;
                    circleY = outRect.centerY();
                    break;
                }
                case 2: {
                    textTop = (float)outRect.bottom - radius + centerBaselineY / 2.0f;
                    circleY = (float)outRect.bottom - radius;
                }
            }
            textLeft = startX - textWidth / 2.0f;
            textTop += this.indicatorStartOffset;
            circleX = startX;
            circleY += this.indicatorStartOffset;
        } else if (0 == orientation) {
            switch (this.gravity) {
                case 0: {
                    textLeft = (float)outRect.left + radius - textWidth / 2.0f;
                    circleX = (float)outRect.left + radius;
                    break;
                }
                case 1: {
                    textLeft = (float)outRect.centerX() - textWidth / 2.0f;
                    circleX = outRect.centerX();
                    break;
                }
                case 2: {
                    textLeft = (float)outRect.right - radius - textWidth / 2.0f;
                    circleX = (float)outRect.right - radius;
                }
            }
            textLeft += this.indicatorStartOffset;
            textTop = startY + (float)(textRect.height() / 2);
            circleX += this.indicatorStartOffset;
            circleY = startY;
        }
        if (index <= this.selectStartIndex) {
            this.drawDrawable(this.selectIndicateDrawable, canvas, circleX, circleY, radius - this.selectIndicatePadding);
        } else {
            this.drawDrawable(this.indicateDrawable, canvas, circleX, circleY, radius - this.indicatePadding);
        }
        canvas.drawText(text, textLeft, textTop, (Paint)this.textPaint);
    }

    private void drawIndicatorDrawable(Canvas canvas, float startX, float startY, int index) {
        float radius = (this.indicateSize - this.indicatePadding) / 2.0f;
        PointF pointF = this.getCenterPoint(index, startX, startY, radius);
        if (index <= this.selectStartIndex) {
            this.drawDrawable(this.selectIndicateDrawable, canvas, pointF.x, pointF.y, radius - this.selectIndicatePadding);
        } else {
            this.drawDrawable(this.indicateDrawable, canvas, pointF.x, pointF.y, radius - this.indicatePadding);
        }
    }

    private PointF getCenterPoint(int index, float startX, float startY, float radius) {
        Rect outRect = new Rect();
        View childView = this.getChildAt(index);
        childView.getHitRect(outRect);
        float circleX = 0.0f;
        float circleY = 0.0f;
        if (1 == this.getOrientation()) {
            switch (this.gravity) {
                case 0: {
                    circleY = (float)outRect.top + radius;
                    break;
                }
                case 1: {
                    circleY = outRect.centerY();
                    break;
                }
                case 2: {
                    circleY = (float)outRect.bottom - radius;
                }
            }
            circleX = startX;
            circleY += this.indicatorStartOffset;
        } else if (0 == this.getOrientation()) {
            switch (this.gravity) {
                case 0: {
                    circleX = (float)outRect.left + radius;
                    break;
                }
                case 1: {
                    circleX = outRect.centerX();
                    break;
                }
                case 2: {
                    circleX = (float)outRect.right - radius;
                }
            }
            circleX += this.indicatorStartOffset;
            circleY = startY;
        }
        return new PointF(circleX, circleY);
    }

    private void drawDrawable(Drawable drawable, Canvas canvas, float circleX, float circleY, float radius) {
        if (null != drawable) {
            drawable.setBounds((int)(circleX - radius), (int)(circleY - radius), (int)(circleX + radius), (int)(circleY + radius));
            drawable.draw(canvas);
        }
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.itemClickListener = listener;
    }

    public void setOnTemplateAddedListener(OnTemplateAddedListener listener) {
        this.listener = listener;
    }

    public void setOnDrawIndicatorTextCallback(OnDrawIndicatorTextCallback callback) {
        this.drawIndicatorTextCallback = callback;
    }

    public static interface OnTemplateAddedListener<T> {
        public void onTemplateAdded(View var1, T var2);
    }

    public static interface OnDrawIndicatorTextCallback {
        public String callText(int var1);
    }

    private static @interface IndicateFrom {
    }

    private static @interface IndicateGravity {
    }
}

