/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.widget.EditText;
import android.widget.TextView;
import com.cz.library.R;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatEditText
extends EditText {
    private CharSequence originalText;
    private final FormatTextWatcher textWatcher;
    private final List<FormatItem> formatItems = new ArrayList<FormatItem>();
    private final SparseArray<FormatItem> afterPositionItems;
    private final SparseArray<FormatItem> beforePositionItems;

    public FormatEditText(Context context) {
        this(context, null, 0);
    }

    public FormatEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.textWatcher = new FormatTextWatcher();
        this.afterPositionItems = new SparseArray();
        this.beforePositionItems = new SparseArray();
        this.addTextChangedListener(new FormatTextWatcher());
        this.initAttr(context, attrs);
    }

    public FormatEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.textWatcher = new FormatTextWatcher();
        this.afterPositionItems = new SparseArray();
        this.beforePositionItems = new SparseArray();
        this.addTextChangedListener(new FormatTextWatcher());
        this.initAttr(context, attrs);
    }

    private void initAttr(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FormatEditText);
        this.setFormat(a.getString(R.styleable.FormatEditText_ft_format));
        a.recycle();
    }

    public void setFormat(@StringRes int res) {
        this.setFormat(this.getResources().getString(res));
    }

    public void setFormat(String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.resetFormatItems(value);
            this.resetText(this.formatItems);
        }
    }

    private void resetFormatItems(String value) {
        this.formatItems.clear();
        this.afterPositionItems.clear();
        int index = 0;
        int interval = 0;
        int lastCharCount = 0;
        Matcher matcher = Pattern.compile("(\\d+)((.)(\\{(\\d+)\\})?)?").matcher(value);
        while (matcher.find()) {
            FormatItem formatItem = null;
            try {
                String charValue = matcher.group(3);
                if (!TextUtils.isEmpty((CharSequence)charValue)) {
                    String charCountValue = matcher.group(5);
                    int charCount = TextUtils.isEmpty((CharSequence)charCountValue) ? 1 : Integer.valueOf(charCountValue);
                    formatItem = new FormatItem(index += Integer.valueOf(matcher.group(1)).intValue(), index + interval, matcher.group(3), charCount);
                    interval += charCount;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null == formatItem) continue;
            this.formatItems.add(formatItem);
            this.afterPositionItems.put(index + interval, formatItem);
            this.beforePositionItems.put(index + lastCharCount, formatItem);
            lastCharCount = formatItem.charCount;
        }
    }

    private void resetText(List<FormatItem> formatItems) {
        if (null != formatItems && !formatItems.isEmpty()) {
            int lastIndex = 0;
            int length = this.originalText.length();
            StringBuilder out = new StringBuilder();
            for (FormatItem item : formatItems) {
                if (item.index >= length) continue;
                CharSequence text = this.originalText.subSequence(lastIndex, item.index);
                if (TextUtils.isEmpty((CharSequence)item.charItem)) {
                    out.append(text);
                } else {
                    out.append(text + this.getFormatChar(item.charItem, item.charCount));
                }
                lastIndex = item.index;
            }
            if (lastIndex < length) {
                out.append(this.originalText.subSequence(lastIndex, length));
            }
            if (0 < out.length()) {
                super.setText((CharSequence)out.toString(), TextView.BufferType.EDITABLE);
            }
        }
    }

    private String getFormatChar(String charItem, int count) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            out.append(charItem);
        }
        return out.toString();
    }

    public CharSequence getOriginalText() {
        return this.originalText;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.originalText = text;
        super.setText(text, type);
        this.resetText(this.formatItems);
    }

    public class FormatTextWatcher
    implements TextWatcher {
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence text, int start, int before, int count) {
            if (0 != start && start < text.length()) {
                int findPosition = this.getFormatPosition((SparseArray<FormatItem>)FormatEditText.this.beforePositionItems, start);
                if (0 <= findPosition) {
                    FormatItem formatItem = (FormatItem)FormatEditText.this.beforePositionItems.valueAt(findPosition);
                    FormatEditText.this.removeTextChangedListener(FormatEditText.this.textWatcher);
                    StringBuilder out = new StringBuilder(text.subSequence(0, formatItem.realIndex));
                    out.append(FormatEditText.this.getFormatChar(formatItem.charItem, formatItem.charCount));
                    out.append(text.subSequence(formatItem.realIndex, text.length()));
                    FormatEditText.super.setText(out.toString(), TextView.BufferType.EDITABLE);
                    FormatEditText.super.setSelection(out.length());
                    FormatEditText.this.addTextChangedListener(FormatEditText.this.textWatcher);
                    text = out.toString();
                }
            } else {
                int findPosition = this.getFormatPosition((SparseArray<FormatItem>)FormatEditText.this.afterPositionItems, start);
                if (0 <= findPosition) {
                    FormatItem formatItem = (FormatItem)FormatEditText.this.afterPositionItems.valueAt(findPosition);
                    FormatEditText.this.removeTextChangedListener(FormatEditText.this.textWatcher);
                    text = text.subSequence(0, start - formatItem.charCount);
                    FormatEditText.super.setText(text, TextView.BufferType.EDITABLE);
                    FormatEditText.super.setSelection(text.length());
                    FormatEditText.this.addTextChangedListener(FormatEditText.this.textWatcher);
                }
            }
            FormatEditText.this.originalText = this.getOriginalText(text);
        }

        public void afterTextChanged(Editable s) {
        }

        private int getFormatPosition(SparseArray<FormatItem> formatItems, int position) {
            int findPosition = -1;
            int size = formatItems.size();
            for (int i = 0; i < size; ++i) {
                if (position != formatItems.keyAt(i)) continue;
                findPosition = i;
                break;
            }
            return findPosition;
        }

        private CharSequence getOriginalText(CharSequence text) {
            StringBuilder out = new StringBuilder(text);
            int size = FormatEditText.this.formatItems.size();
            for (int i = 0; i < size; ++i) {
                String formatValue;
                FormatItem formatItem = (FormatItem)FormatEditText.this.formatItems.get(i);
                if (formatItem.index >= out.length() || formatItem.index + formatItem.charCount >= out.length() || !this.isMatcher(formatValue = out.substring(formatItem.index, formatItem.index + formatItem.charCount), formatItem.charItem)) continue;
                out.delete(formatItem.index, formatItem.index + formatItem.charCount);
            }
            return out;
        }

        private boolean isMatcher(CharSequence value, String charItem) {
            boolean result = false;
            if (!TextUtils.isEmpty((CharSequence)value)) {
                for (int i = 0; i < value.length(); ++i) {
                    if (!(result | new Character(value.charAt(i)).toString().equals(charItem))) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }
    }

    public class FormatItem {
        public final int index;
        public final int realIndex;
        public final String charItem;
        public final int charCount;

        public FormatItem(int index, int realIndex, String charItem, int charCount) {
            this.index = index;
            this.realIndex = realIndex;
            this.charItem = charItem;
            this.charCount = charCount;
        }
    }
}

