/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.cz.library.R;

public class DivideLinearLayout
extends LinearLayout {
    public static final int NONE = 1;
    public static final int LEFT = 2;
    public static final int TOP = 4;
    public static final int RIGHT = 8;
    public static final int BOTTOM = 16;
    public static final int ITEM_DIVIDE = 32;
    private int strokeSize;
    private int itemStrokeSize;
    private int dividePadding;
    private int itemDividePadding;
    private int leftPadding;
    private int leftItemPadding;
    private Drawable divideDrawable;
    private Drawable itemDivideDrawable;
    private int gravity;

    public DivideLinearLayout(Context context) {
        this(context, null);
    }

    public DivideLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.divideLinearLayout);
    }

    public DivideLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DivideLinearLayout, defStyleAttr, R.style.DivideLinearLayout);
        this.setDivideGravityInner(a.getInt(R.styleable.DivideLinearLayout_dl_divideGravity, 1));
        this.setDivideSize(a.getDimension(R.styleable.DivideLinearLayout_dl_divideSize, 0.0f));
        this.setItemDivideSize(a.getDimension(R.styleable.DivideLinearLayout_dl_itemDivideSize, 0.0f));
        this.setDivideDrawable(a.getDrawable(R.styleable.DivideLinearLayout_dl_divideDrawable));
        this.setItemDivideDrawable(a.getDrawable(R.styleable.DivideLinearLayout_dl_itemDivideDrawable));
        this.setDividePadding(a.getDimension(R.styleable.DivideLinearLayout_dl_dividePadding, 0.0f));
        this.setLeftPadding(a.getDimension(R.styleable.DivideLinearLayout_dl_leftPadding, 0.0f));
        this.setLeftItemPadding((int)a.getDimension(R.styleable.DivideLinearLayout_dl_leftItemPadding, 0.0f));
        this.setItemDividePadding(a.getDimension(R.styleable.DivideLinearLayout_dl_itemDividePadding, 0.0f));
        a.recycle();
    }

    private void setLeftPadding(float padding) {
        this.leftPadding = Math.round(padding);
        this.invalidate();
    }

    public void setDivideGravity(@DivideGravity int gravity) {
        this.setDivideGravityInner(gravity);
    }

    public void setDivideGravityInner(int gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    public void setDivideSize(float size) {
        this.strokeSize = Math.round(size);
        this.invalidate();
    }

    public void setItemDivideSize(float size) {
        this.itemStrokeSize = Math.round(size);
        this.invalidate();
    }

    public void setDivideDrawable(Drawable drawable) {
        this.divideDrawable = drawable;
        this.invalidate();
    }

    public void setItemDivideDrawable(Drawable drawable) {
        this.itemDivideDrawable = drawable;
        this.invalidate();
    }

    public void setDividePadding(float padding) {
        this.dividePadding = Math.round(padding);
        this.invalidate();
    }

    public void setItemDividePadding(float padding) {
        this.itemDividePadding = Math.round(padding);
        this.invalidate();
    }

    public void setLeftItemPadding(int padding) {
        this.leftItemPadding = padding;
        this.invalidate();
    }

    public Drawable getDividerDrawable() {
        return this.divideDrawable;
    }

    public Drawable getItemDividerDrawable() {
        return this.itemDivideDrawable;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (null != this.divideDrawable) {
            this.divideDrawable.setState(this.getDrawableState());
        }
        if (null != this.itemDivideDrawable) {
            this.itemDivideDrawable.setState(this.getDrawableState());
        }
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (null != this.divideDrawable) {
            this.divideDrawable.jumpToCurrentState();
        }
        if (null != this.itemDivideDrawable) {
            this.itemDivideDrawable.jumpToCurrentState();
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawDivide(canvas, 0 != (this.gravity & 2), 0 != (this.gravity & 4), 0 != (this.gravity & 8), 0 != (this.gravity & 0x10));
        this.drawItemDivide(canvas);
    }

    private void drawDivide(Canvas canvas, boolean drawLeft, boolean drawTop, boolean drawRight, boolean drawBottom) {
        if (null == this.divideDrawable) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (drawLeft) {
            this.divideDrawable.setBounds(0, this.dividePadding, this.strokeSize, height - this.dividePadding);
            this.divideDrawable.draw(canvas);
        }
        if (drawTop) {
            this.divideDrawable.setBounds(this.dividePadding, 0, width - this.dividePadding, this.strokeSize);
            this.divideDrawable.draw(canvas);
        }
        if (drawRight) {
            this.divideDrawable.setBounds(width - this.strokeSize, this.dividePadding, width, height - this.dividePadding);
            this.divideDrawable.draw(canvas);
        }
        if (drawBottom) {
            this.divideDrawable.setBounds(this.dividePadding + this.leftPadding, height - this.strokeSize, width - this.dividePadding, height);
            this.divideDrawable.draw(canvas);
        }
    }

    private void drawItemDivide(Canvas canvas) {
        if (null == this.itemDivideDrawable) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int orientation = this.getOrientation();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount - 1; ++i) {
            View childView = this.getChildAt(i);
            if (0 != childView.getVisibility() || 0 == (this.gravity & 0x20)) continue;
            if (0 == orientation) {
                int right = childView.getRight();
                this.itemDivideDrawable.setBounds(right - this.itemStrokeSize, this.itemDividePadding, right, height - this.itemDividePadding);
                this.itemDivideDrawable.draw(canvas);
                continue;
            }
            if (1 != orientation) continue;
            int bottom = childView.getBottom();
            this.itemDivideDrawable.setBounds(this.itemDividePadding + this.leftItemPadding, bottom - this.itemStrokeSize, width - this.itemDividePadding, bottom);
            this.itemDivideDrawable.draw(canvas);
        }
    }

    public static @interface DivideGravity {
    }
}

