/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.cz.library.R;

public class DialView
extends View {
    private static final String TAG = "DialView";
    private final boolean DEBUG = false;
    private final Paint paint = new Paint(1);
    private final Paint ringPaint = new Paint(1);
    private final Paint textPaint = new Paint(1);
    private final Path path;
    private final Path textPath;
    private float dialPadding;
    private float[] pos;
    private float[] tan;
    private PathMeasure pathMeasure;
    private PathMeasure textPathMeasure;
    private Drawable progressDrawable;
    private RectF arcRect;
    private Rect textRect;
    private float innerStrokeWidth1;
    private float innerStrokeWidth2;
    private float dialInnerPadding1;
    private float dialInnerPadding2;
    private float dialBottomPadding;
    private int intervalItemCount;
    private int levelTextSize;
    private int levelInfoTextSize;
    private int levelValueTextSize;
    private CharSequence[] levelTextItems;
    private int[] levelValueArray;
    private int levelMinValue;
    private int levelMaxValue;
    private int currentLevelValue;
    private float currentLevelDegrees;
    private int itemIntervalDegrees;
    private int animDuration;
    private int itemCount;
    private OnLevelValueChangeListener listener;

    public DialView(Context context) {
        this(context, null, 0);
    }

    public DialView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DialView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.textPaint.setTextSize(20.0f);
        this.textRect = new Rect();
        this.path = new Path();
        this.textPath = new Path();
        this.pos = new float[2];
        this.tan = new float[2];
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DialView);
        this.setDialItemCount(a.getInteger(R.styleable.DialView_dv_dialItemCount, 5));
        this.setStrokeWidth(a.getDimension(R.styleable.DialView_dv_strokeWidth, 0.0f));
        this.setInnerStrokeWidth1(a.getDimension(R.styleable.DialView_dv_innerStrokeWidth1, 0.0f));
        this.setInnerStrokeWidth2(a.getDimension(R.styleable.DialView_dv_innerStrokeWidth2, 0.0f));
        this.setPaintColor(a.getColor(R.styleable.DialView_dv_paintColor, -1));
        this.setDialPadding(a.getDimension(R.styleable.DialView_dv_dialPadding, 0.0f));
        this.setDialProgressDrawable(a.getDrawable(R.styleable.DialView_dv_dialProgressDrawable));
        this.setDialInnerPadding1(a.getDimension(R.styleable.DialView_dv_dialInnerPadding1, 0.0f));
        this.setDialInnerPadding2(a.getDimension(R.styleable.DialView_dv_dialInnerPadding2, 0.0f));
        this.setDialItemIntervalDegrees(a.getInteger(R.styleable.DialView_dv_dialItemIntervalDegrees, 2));
        this.setDialIntervalItemCount(a.getInteger(R.styleable.DialView_dv_dialIntervalItemCount, 7));
        this.setDialBottomPadding(a.getDimension(R.styleable.DialView_dv_dialBottomPadding, 0.0f));
        this.setLevelTextArray(a.getTextArray(R.styleable.DialView_dv_dialLevelTextArray));
        int resId = a.getResourceId(R.styleable.DialView_dv_levelValue, -1);
        if (-1 != resId) {
            this.setLevelValue(this.getResources().getIntArray(resId));
        }
        this.setLevelTextSize(a.getDimensionPixelSize(R.styleable.DialView_dv_levelTextSize, this.applyDimension(2, 8)));
        this.setLevelInfoTextSize(a.getDimensionPixelSize(R.styleable.DialView_dv_levelInfoTextSize, this.applyDimension(2, 16)));
        this.setLevelValueTextSize(a.getDimensionPixelSize(R.styleable.DialView_dv_levelValueTextSize, this.applyDimension(2, 28)));
        this.setLevelAnimDuration(a.getInteger(R.styleable.DialView_dv_levelAnimDuration, 300));
        a.recycle();
    }

    public int applyDimension(int typedValue, int value) {
        return Math.round(TypedValue.applyDimension((int)typedValue, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    public void setDialBottomPadding(float padding) {
        this.dialBottomPadding = padding;
        this.invalidate();
    }

    public void setDialIntervalItemCount(int itemCount) {
        this.intervalItemCount = itemCount;
        this.invalidate();
    }

    private void setDialItemCount(int count) {
        this.itemCount = count;
        this.invalidate();
    }

    public void setDialItemIntervalDegrees(int degrees) {
        this.itemIntervalDegrees = degrees;
        this.invalidate();
    }

    public void setDialInnerPadding1(float padding) {
        this.dialInnerPadding1 = padding;
        this.invalidate();
    }

    public void setDialInnerPadding2(float padding) {
        this.dialInnerPadding2 = padding;
        this.invalidate();
    }

    public void setDialPadding(float padding) {
        this.dialPadding = padding;
        this.invalidate();
    }

    public void setStrokeWidth(float width) {
        this.paint.setStrokeWidth(width);
        this.invalidate();
    }

    public void setInnerStrokeWidth1(float strokeWidth) {
        this.innerStrokeWidth1 = strokeWidth;
        this.invalidate();
    }

    public void setInnerStrokeWidth2(float strokeWidth) {
        this.innerStrokeWidth2 = strokeWidth;
        this.invalidate();
    }

    public void setPaintColor(int color) {
        this.paint.setColor(color);
        this.ringPaint.setColor(color);
        this.textPaint.setColor(color);
        this.invalidate();
    }

    public void setDialProgressDrawable(Drawable drawable) {
        this.progressDrawable = drawable;
        this.invalidate();
    }

    public void setLevelTextSize(int textSize) {
        this.levelTextSize = textSize;
        this.invalidate();
    }

    public void setLevelInfoTextSize(int textSize) {
        this.levelInfoTextSize = textSize;
        this.invalidate();
    }

    public void setLevelValueTextSize(int textSize) {
        this.levelValueTextSize = textSize;
        this.invalidate();
    }

    public void setLevelTextArray(CharSequence[] items) {
        if (null == items || items.length != this.itemCount) {
            throw new IllegalArgumentException("items's height must be the same as item count!");
        }
        this.levelTextItems = items;
        this.invalidate();
    }

    public void setLevelAnimDuration(int duration) {
        this.animDuration = duration;
    }

    public void setLevelValue(int[] array) {
        if (null == array || array.length != this.itemCount) {
            throw new IllegalArgumentException("items's height must be the same as item count!");
        }
        this.levelValueArray = array;
        this.currentLevelValue = array[0];
        this.levelMinValue = array[0];
        this.levelMaxValue = array[array.length - 1];
        this.invalidate();
    }

    public int getMinLevelValue() {
        return this.levelMinValue;
    }

    public int getMaxLevelValue() {
        return this.levelMaxValue;
    }

    public int getCurrentLevelValue() {
        return this.currentLevelValue;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.paint.setStyle(Paint.Style.STROKE);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        int width = this.getWidth();
        int height = this.getHeight();
        float radius = (float)(Math.max(width, height) / 2) - this.dialPadding;
        this.path.addCircle((float)(width / 2), (float)height - this.dialBottomPadding, radius, Path.Direction.CW);
        this.pathMeasure = new PathMeasure(this.path, false);
        this.textPath.addCircle((float)(width / 2), (float)height - this.dialBottomPadding, radius - this.dialPadding - this.dialInnerPadding1 - this.dialInnerPadding2, Path.Direction.CW);
        this.textPathMeasure = new PathMeasure(this.textPath, false);
        float startY = (float)height - radius + this.dialInnerPadding1;
        float padding = this.dialPadding + this.dialInnerPadding1;
        this.arcRect = new RectF(padding, startY - this.dialBottomPadding, (float)width - padding, startY + (radius - this.dialInnerPadding1) * 2.0f - this.dialBottomPadding);
    }

    public void setLevelValueTo(final int endValue) {
        if (this.levelMinValue <= endValue && this.levelMaxValue >= endValue) {
            int startValue = this.currentLevelValue;
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startValue, endValue});
            valueAnimator.setDuration((long)this.animDuration);
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    Integer value = Integer.valueOf(valueAnimator.getAnimatedValue().toString());
                    int itemPosition = DialView.this.getItemPosition(value) - 1;
                    int itemDegrees = 180 / (DialView.this.itemCount - 1);
                    int startValue = DialView.this.levelValueArray[itemPosition];
                    int itemValue = DialView.this.levelValueArray[itemPosition + 1] - startValue;
                    float fraction = (float)(value - startValue) * 1.0f / (float)itemValue;
                    DialView.this.currentLevelDegrees = (float)(itemPosition * itemDegrees) + fraction * (float)itemDegrees;
                    DialView.this.currentLevelValue = value;
                    if (null != DialView.this.listener) {
                        DialView.this.listener.onLevelValueChanged(startValue, value, endValue, itemPosition, fraction);
                    }
                    DialView.this.invalidate();
                }
            });
            valueAnimator.start();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        long st = System.currentTimeMillis();
        int width = this.getWidth();
        int height = this.getHeight();
        canvas.drawPath(this.path, this.paint);
        float radius = (float)(Math.max(width, height) / 2) - this.dialPadding;
        float halfLength = this.pathMeasure.getLength() / 2.0f;
        this.drawIndicatorDrawable(canvas, halfLength);
        this.drawInnerRing(canvas);
        this.drawRingItems(canvas, halfLength);
        this.drawLevelItems(canvas, width, height);
        this.drawLevelText(canvas, width, height, radius);
        this.drawLevelTextValue(canvas, width, height);
    }

    private void drawIndicatorDrawable(Canvas canvas, float halfLength) {
        if (null != this.progressDrawable) {
            this.pathMeasure.getPosTan(halfLength + this.currentLevelDegrees * 1.0f / 180.0f * halfLength, this.pos, this.tan);
            float degrees = (float)(Math.atan2(this.tan[1], this.tan[0]) * 180.0 / Math.PI);
            canvas.save();
            canvas.rotate(degrees, this.pos[0], this.pos[1]);
            int halfDrawableWidth = this.progressDrawable.getIntrinsicWidth() / 2;
            int halfDrawableHeight = this.progressDrawable.getIntrinsicHeight() / 2;
            this.progressDrawable.setBounds((int)this.pos[0] - halfDrawableWidth, (int)this.pos[1] - halfDrawableHeight, (int)this.pos[0] + halfDrawableWidth, (int)this.pos[1] + halfDrawableHeight);
            this.progressDrawable.draw(canvas);
            canvas.restore();
        }
    }

    private void drawInnerRing(Canvas canvas) {
        int startDegrees = 180 + this.itemIntervalDegrees / 2;
        int itemDegrees = (180 - this.itemIntervalDegrees * (this.itemCount - 1)) / (this.itemCount - 1);
        this.ringPaint.setStrokeWidth(this.innerStrokeWidth1);
        for (int i = 0; i < this.itemCount - 1; ++i) {
            canvas.drawArc(this.arcRect, (float)startDegrees, (float)itemDegrees, false, this.ringPaint);
            startDegrees += itemDegrees + this.itemIntervalDegrees;
        }
    }

    private void drawRingItems(Canvas canvas, float halfLength) {
        int totalItemCount = this.intervalItemCount * (this.itemCount - 1);
        float itemFraction = 1.0f / (float)totalItemCount;
        float strokeWidth = this.ringPaint.getStrokeWidth();
        this.ringPaint.setStrokeWidth(this.innerStrokeWidth2);
        for (int i = 0; i <= totalItemCount; ++i) {
            this.pathMeasure.getPosTan(halfLength + (float)i * itemFraction * halfLength, this.pos, this.tan);
            float degrees = (float)(Math.atan2(this.tan[1], this.tan[0]) * 180.0 / Math.PI);
            canvas.save();
            canvas.rotate(degrees, this.pos[0], this.pos[1]);
            canvas.translate(0.0f, this.dialInnerPadding1 + this.dialInnerPadding2 + strokeWidth / 2.0f);
            canvas.drawLine(this.pos[0], this.pos[1] - (float)(0 == i % this.intervalItemCount ? 10 : 0), this.pos[0], this.pos[1] + 10.0f, this.ringPaint);
            canvas.restore();
        }
    }

    private void drawLevelItems(Canvas canvas, int width, int height) {
        if (this.levelMinValue != this.levelMaxValue && this.levelMaxValue - this.levelMinValue > this.itemCount) {
            float halfLength = this.textPathMeasure.getLength() / 2.0f;
            this.textPaint.setTextSize((float)this.levelTextSize);
            for (int i = 0; i < this.itemCount; ++i) {
                String text = String.valueOf(this.levelValueArray[i]);
                float textWidth = this.textPaint.measureText(text, 0, text.length());
                this.textPathMeasure.getPosTan(textWidth / 2.0f, this.pos, this.tan);
                float degrees = (float)(Math.atan2(this.tan[1], this.tan[0]) * 180.0 / Math.PI);
                this.textPaint.getTextBounds(text.toString(), 0, text.length(), this.textRect);
                canvas.save();
                canvas.rotate(270.0f - degrees, (float)(width / 2), (float)height - this.dialBottomPadding);
                canvas.drawTextOnPath(text.toString(), this.textPath, (float)i * (halfLength / (float)(this.itemCount - 1)), (float)this.textRect.height(), this.textPaint);
                canvas.restore();
            }
        }
    }

    private void drawLevelText(Canvas canvas, int width, int height, float radius) {
        int itemPosition;
        CharSequence text;
        if (null != this.levelTextItems && this.levelTextItems.length == this.itemCount && !TextUtils.isEmpty((CharSequence)(text = this.levelTextItems[itemPosition = this.getItemPosition(this.currentLevelValue) - 1]))) {
            this.textPaint.setTextSize((float)this.levelInfoTextSize);
            float textWidth = this.textPaint.measureText(text, 0, text.length());
            canvas.drawText(text.toString(), ((float)width - textWidth) / 2.0f, -(this.textPaint.descent() + this.textPaint.ascent()) + ((float)height - radius) + radius / 2.0f, this.textPaint);
        }
    }

    private void drawLevelTextValue(Canvas canvas, int width, int height) {
        String value = String.valueOf(this.currentLevelValue);
        this.textPaint.setTextSize((float)this.levelValueTextSize);
        float textWidth = this.textPaint.measureText(value, 0, value.length());
        this.textPaint.getTextBounds(value, 0, value.length(), this.textRect);
        canvas.drawText(value, ((float)width - textWidth) / 2.0f, (float)height - this.textPaint.descent() - this.textPaint.ascent() - (float)this.textRect.height() - this.dialBottomPadding, this.textPaint);
    }

    private int getItemPosition(int currentValue) {
        int[] positions = this.levelValueArray;
        int start = 0;
        int end = positions.length - 1;
        int result = -1;
        while (start <= end) {
            int middle = (start + end) / 2;
            if (currentValue == positions[middle]) {
                result = middle + 1;
                break;
            }
            if (currentValue < positions[middle]) {
                end = middle - 1;
                continue;
            }
            start = middle + 1;
        }
        return -1 == result ? start : result;
    }

    public void setOnLevelValueChangeListener(OnLevelValueChangeListener listener) {
        this.listener = listener;
    }

    public static interface OnLevelValueChangeListener {
        public void onLevelValueChanged(int var1, int var2, int var3, int var4, float var5);
    }
}

