/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import com.cz.library.R;
import com.cz.library.widget.DivideTextView;

public class CenterTextView
extends DivideTextView {
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int ALL = 15;
    public static final int DRAWABLE_LEFT = 0;
    public static final int DRAWABLE_TOP = 1;
    public static final int DRAWABLE_RIGHT = 2;
    public static final int DRAWABLE_BOTTOM = 3;
    public static final int DRAWABLE_ALL = 4;
    private int sizeMode;
    private int drawableMode;
    private int drawableWidth;
    private int drawableHeight;
    private Drawable[] compoundDrawables;
    private CharSequence text;
    private TextPaint textPaint;
    private boolean isChecked;
    private boolean debug;
    private Paint paint = new Paint(1);

    public CenterTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CenterTextView(Context context) {
        this(context, null, 0);
    }

    public CenterTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.textPaint = new TextPaint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CenterTextView);
        this.setDrawableWidth((int)a.getDimension(R.styleable.CenterTextView_cv_drawableWidth, -1.0f));
        this.setDrawableHeight((int)a.getDimension(R.styleable.CenterTextView_cv_drawableHeight, -1.0f));
        this.setDrawableMode(a.getInt(R.styleable.CenterTextView_cv_drawableMode, 0));
        this.setSizeMode(a.getInt(R.styleable.CenterTextView_cv_sizeMode, 0));
        a.recycle();
    }

    public void setDebugDraw(boolean debug) {
        this.debug = debug;
        this.invalidate();
    }

    public void setSizeMode(int mode) {
        this.sizeMode = mode;
        this.invalidate();
    }

    public void setDrawableMode(int mode) {
        this.drawableMode = mode;
        this.invalidate();
    }

    public void setDrawableWidth(int width) {
        this.drawableWidth = width;
        this.invalidate();
    }

    public void setDrawableHeight(int height) {
        this.drawableHeight = height;
        this.invalidate();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(null, type);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.text = text;
        }
    }

    public void setTextEmpty() {
        this.text = null;
        this.invalidate();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Drawable[] compoundDrawables = this.compoundDrawables;
        for (int i = 0; i < compoundDrawables.length; ++i) {
            if (null == compoundDrawables[i]) continue;
            compoundDrawables[i].setState(enabled ? ENABLED_STATE_SET : EMPTY_STATE_SET);
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        Drawable[] compoundDrawables = this.compoundDrawables;
        for (int i = 0; i < compoundDrawables.length; ++i) {
            if (null == compoundDrawables[i]) continue;
            compoundDrawables[i].setState(selected ? SELECTED_STATE_SET : EMPTY_STATE_SET);
        }
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        super.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        if (null == this.compoundDrawables) {
            this.compoundDrawables = new Drawable[4];
        }
        this.compoundDrawables[0] = left;
        this.compoundDrawables[1] = top;
        this.compoundDrawables[2] = right;
        this.compoundDrawables[3] = bottom;
        this.invalidate();
    }

    @NonNull
    public Drawable[] getCompoundDrawables() {
        return this.compoundDrawables;
    }

    public CharSequence getText() {
        return this.text;
    }

    private int getDrawableHeight(Drawable drawable, boolean isMode) {
        if (null == drawable) {
            return -1;
        }
        int intrinsicHeight = drawable.getIntrinsicHeight();
        return isMode ? this.drawableHeight : intrinsicHeight;
    }

    private int getDrawableWidth(Drawable drawable, boolean isMode) {
        if (null == drawable) {
            return -1;
        }
        int intrinsicWidth = drawable.getIntrinsicWidth();
        return isMode ? this.drawableWidth : intrinsicWidth;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        TextPaint paint = this.getPaint();
        CharSequence text = this.text;
        int textWidth = 0;
        int textHeight = 0;
        if (!TextUtils.isEmpty((CharSequence)text)) {
            textWidth = (int)paint.measureText(text.toString());
            Rect textRect = new Rect();
            paint.getTextBounds(text.toString(), 0, text.length(), textRect);
            textHeight = textRect.height();
        }
        int width = this.getPaddingLeft() + this.getPaddingRight() + textWidth;
        Drawable[] compoundDrawables = this.compoundDrawables;
        if (null != compoundDrawables[0] || null != compoundDrawables[2]) {
            width += this.getCompoundDrawablePadding();
            if (null != compoundDrawables[0]) {
                width += compoundDrawables[0].getIntrinsicWidth();
            }
            if (null != compoundDrawables[2]) {
                width += compoundDrawables[2].getIntrinsicWidth();
            }
        }
        int height = this.getPaddingTop() + this.getPaddingBottom() + textHeight;
        if (null != compoundDrawables[1] || null != compoundDrawables[3]) {
            height += this.getCompoundDrawablePadding();
            if (null != compoundDrawables[1]) {
                height += compoundDrawables[1].getIntrinsicHeight();
            }
            if (null != compoundDrawables[3]) {
                height += compoundDrawables[3].getIntrinsicHeight();
            }
        }
        this.setMeasuredDimension(CenterTextView.resolveSize((int)width, (int)widthMeasureSpec), CenterTextView.resolveSize((int)height, (int)heightMeasureSpec));
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable[] drawables = this.compoundDrawables;
        int drawablePadding = this.getCompoundDrawablePadding();
        if (4 != this.drawableMode) {
            this.draw(0, drawables, this.drawableMode == 0 || this.drawableMode == 4, canvas, drawablePadding, this.getDrawableWidth(drawables[0], this.sizeMode == (this.sizeMode | 1)), this.getDrawableHeight(drawables[0], this.sizeMode == (this.sizeMode | 1)));
            this.draw(1, drawables, this.drawableMode == 1 || this.drawableMode == 4, canvas, drawablePadding, this.getDrawableWidth(drawables[1], this.sizeMode == (this.sizeMode | 2)), this.getDrawableHeight(drawables[1], this.sizeMode == (this.sizeMode | 2)));
            this.draw(2, drawables, this.drawableMode == 2 || this.drawableMode == 4, canvas, drawablePadding, this.getDrawableWidth(drawables[2], this.sizeMode == (this.sizeMode | 4)), this.getDrawableHeight(drawables[2], this.sizeMode == (this.sizeMode | 4)));
            this.draw(3, drawables, this.drawableMode == 3 || this.drawableMode == 4, canvas, drawablePadding, this.getDrawableWidth(drawables[3], this.sizeMode == (this.sizeMode | 8)), this.getDrawableHeight(drawables[3], this.sizeMode == (this.sizeMode | 8)));
        } else {
            this.drawCenterDrawables(canvas);
        }
        this.drawText(this.drawableMode, canvas, drawablePadding);
        if (this.debug) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.paint.setColor(-16776961);
            this.paint.setStrokeWidth(4.0f);
            canvas.drawLine(0.0f, (float)(height / 2), (float)width, (float)(height / 2), this.paint);
            canvas.drawLine((float)(width / 2), 0.0f, (float)(width / 2), (float)height, this.paint);
        }
    }

    private void drawCenterDrawables(Canvas canvas) {
        int drawableHeight;
        int drawableWidth;
        Drawable[] drawables;
        TextPaint paint = this.getPaint();
        int width = this.getWidth();
        int height = this.getHeight();
        int textWidth = 0;
        int textHeight = 0;
        int centerX = width / 2;
        int centerY = 0;
        int drawablePadding = this.getCompoundDrawablePadding();
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            String text = this.text.toString();
            textWidth = (int)paint.measureText(text);
            Rect textRect = new Rect();
            paint.getTextBounds(text, 0, text.length(), textRect);
            textHeight = textRect.height();
            centerX = (width - textWidth) / 2;
            centerY = (height - textHeight) / 2;
        }
        if (null != (drawables = this.compoundDrawables)[0]) {
            drawableWidth = this.getDrawableWidth(drawables[0], this.sizeMode == (this.sizeMode | 1));
            drawableHeight = this.getDrawableHeight(drawables[0], this.sizeMode == (this.sizeMode | 1));
            int leftCenterY = (height - drawableHeight) / 2;
            drawables[0].setBounds(centerX - drawablePadding - drawableWidth, leftCenterY, centerX - drawablePadding, leftCenterY + drawableHeight);
            drawables[0].draw(canvas);
        }
        if (null != drawables[1]) {
            drawableWidth = this.getDrawableWidth(drawables[1], this.sizeMode == (this.sizeMode | 2));
            drawableHeight = this.getDrawableHeight(drawables[1], this.sizeMode == (this.sizeMode | 2));
            int topCenterX = (width - drawableWidth) / 2;
            drawables[1].setBounds(topCenterX, centerY - drawablePadding - drawableHeight, topCenterX + drawableWidth, centerY - drawablePadding);
            drawables[1].draw(canvas);
        }
        if (null != drawables[2]) {
            drawableWidth = this.getDrawableWidth(drawables[2], this.sizeMode == (this.sizeMode | 4));
            drawableHeight = this.getDrawableHeight(drawables[2], this.sizeMode == (this.sizeMode | 4));
            int rightCenterY = (height - drawableHeight) / 2;
            drawables[2].setBounds(centerX + drawablePadding + textWidth, rightCenterY, centerX + textWidth + drawablePadding + drawableWidth, rightCenterY + drawableHeight);
            drawables[2].draw(canvas);
        }
        if (null != drawables[3]) {
            drawableWidth = this.getDrawableWidth(drawables[3], this.sizeMode == (this.sizeMode | 8));
            drawableHeight = this.getDrawableHeight(drawables[3], this.sizeMode == (this.sizeMode | 8));
            int bottomCenterX = (width - drawableWidth) / 2;
            drawables[3].setBounds(bottomCenterX, centerY + drawablePadding + textHeight, bottomCenterX + drawableWidth, centerY + drawablePadding + drawableHeight + textHeight);
            drawables[3].draw(canvas);
        }
    }

    private void drawText(int mode, Canvas canvas, int drawablePadding) {
        TextPaint paint = this.getPaint();
        int width = this.getWidth();
        int height = this.getHeight();
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            String text = this.text.toString();
            Drawable[] drawables = this.compoundDrawables;
            float textWidth = paint.measureText(text);
            Rect textRect = new Rect();
            paint.getTextBounds(text, 0, text.length(), textRect);
            float centerY = ((float)height - (paint.descent() + paint.ascent())) / 2.0f;
            switch (mode) {
                case 4: {
                    canvas.drawText(text, ((float)width - textWidth) / 2.0f, centerY, (Paint)paint);
                    break;
                }
                case 0: {
                    int drawableWidth = this.getDrawableWidth(drawables[0], this.sizeMode == (this.sizeMode | 1));
                    drawablePadding = 0 == drawableWidth ? 0 : drawablePadding;
                    float centerX = ((float)(width - drawableWidth - drawablePadding) - textWidth) / 2.0f;
                    canvas.drawText(text, centerX + (float)drawableWidth + (float)drawablePadding, centerY, (Paint)paint);
                    break;
                }
                case 1: {
                    int drawableHeight = this.getDrawableHeight(drawables[1], this.sizeMode == (this.sizeMode | 2));
                    drawablePadding = 0 == drawableHeight ? 0 : drawablePadding;
                    float centerX = ((float)width - textWidth) / 2.0f;
                    canvas.drawText(text, centerX, (centerY -= (float)((drawableHeight + drawablePadding) / 2)) + (float)drawableHeight + (float)drawablePadding, (Paint)paint);
                    break;
                }
                case 2: {
                    int drawableWidth = this.getDrawableWidth(drawables[2], this.sizeMode == (this.sizeMode | 4));
                    drawablePadding = 0 == drawableWidth ? 0 : drawablePadding;
                    float centerX = ((float)(width - drawableWidth - drawablePadding) - textWidth) / 2.0f;
                    canvas.drawText(text, centerX, centerY, (Paint)paint);
                    break;
                }
                case 3: {
                    int drawableHeight = this.getDrawableHeight(drawables[3], this.sizeMode == (this.sizeMode | 8));
                    drawablePadding = 0 == drawableHeight ? 0 : drawablePadding;
                    float centerX = ((float)width - textWidth) / 2.0f;
                    canvas.drawText(text, centerX, centerY -= (float)((drawableHeight + drawablePadding) / 2), (Paint)paint);
                }
            }
        }
    }

    private void draw(int index, Drawable[] drawables, boolean mode, Canvas canvas, int drawablePadding, int drawableWidth, int drawableHeight) {
        if (null == drawables[index]) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            String text = this.text.toString();
            TextPaint paint = this.getPaint();
            textWidth = paint.measureText(text);
            Rect textRect = new Rect();
            paint.getTextBounds(text, 0, text.length(), textRect);
            textHeight = textRect.height();
        }
        Drawable drawable = drawables[index];
        this.drawCompoundDrawable(index, mode, canvas, drawablePadding, drawableWidth, drawableHeight, drawable, width, height, textWidth, textHeight);
    }

    private void drawCompoundDrawable(int index, boolean mode, Canvas canvas, int drawablePadding, int drawableWidth, int drawableHeight, Drawable drawable, int width, int height, float textWidth, float textHeight) {
        int centerX = (int)(((float)(width - drawableWidth - drawablePadding) - textWidth) / 2.0f);
        int centerY = (int)(((float)(height - drawableHeight - drawablePadding) - textHeight) / 2.0f);
        if (mode) {
            switch (index) {
                case 0: {
                    centerY = (height - drawableHeight) / 2;
                    drawable.setBounds(centerX, centerY, centerX + drawableWidth, centerY + drawableHeight);
                    break;
                }
                case 1: {
                    centerX = (width - drawableWidth) / 2;
                    drawable.setBounds(centerX, centerY, centerX + drawableWidth, centerY + drawableHeight);
                    break;
                }
                case 2: {
                    centerY = (height - drawableHeight) / 2;
                    drawable.setBounds(centerX + drawablePadding + (int)textWidth, centerY, centerX + drawablePadding + (int)textWidth + drawableWidth, centerY + drawableHeight);
                    break;
                }
                case 3: {
                    centerX = (width - drawableWidth) / 2;
                    drawable.setBounds(centerX, centerY + drawablePadding + (int)textHeight, centerX + drawableWidth, centerY + drawablePadding + (int)textHeight + drawableHeight);
                }
            }
            if (this.debug) {
                switch (index) {
                    case 0: 
                    case 2: {
                        centerY = (int)(((float)height - Math.max((float)drawableHeight, textHeight)) / 2.0f);
                        canvas.drawRect((float)centerX, (float)centerY, (float)(centerX + drawableWidth) + textWidth + (float)drawablePadding, (float)centerY + Math.max((float)drawableHeight, textHeight), this.paint);
                        break;
                    }
                    case 1: 
                    case 3: {
                        centerX = (int)(((float)width - Math.max((float)drawableWidth, textWidth)) / 2.0f);
                        canvas.drawRect((float)centerX, (float)centerY, (float)centerX + Math.max((float)drawableWidth, textWidth), (float)(centerY + drawableHeight) + textHeight + (float)drawablePadding, this.paint);
                    }
                }
            }
        } else {
            int paddingLeft = this.getPaddingLeft();
            int paddingTop = this.getPaddingTop();
            int paddingRight = this.getPaddingRight();
            int paddingBottom = this.getPaddingBottom();
            switch (index) {
                case 0: {
                    centerY = (height - drawableHeight) / 2;
                    drawable.setBounds(paddingLeft, centerY, paddingLeft + drawableWidth, centerY + drawableHeight);
                    break;
                }
                case 1: {
                    centerX = (width - drawableWidth) / 2;
                    drawable.setBounds(centerX, paddingTop, centerX + drawableWidth, paddingTop + drawableHeight);
                    break;
                }
                case 2: {
                    centerY = (height - drawableHeight) / 2;
                    drawable.setBounds(width - paddingRight - drawableWidth, centerY, width - paddingRight, centerY + drawableHeight);
                    break;
                }
                case 3: {
                    centerX = (width - drawableWidth) / 2;
                    drawable.setBounds(centerX, height - paddingBottom - drawableHeight, centerX + drawableWidth, height - paddingBottom);
                }
            }
        }
        drawable.draw(canvas);
    }
}

