/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.StringRes;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.cz.library.R;
import com.cz.library.widget.DivideTextView;

public class BothTextView
extends DivideTextView {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private static final String TAG = "BothTextView";
    private int imageGravity;
    private Drawable imageDrawable;
    private int imageDrawableWidth;
    private int imageDrawableHeight;
    private int drawablePadding;
    private TextPaint textPaint = new TextPaint(1);
    private String subText;
    private int textColor;
    private int textSize;
    private int rightPadding;
    private boolean defaultSet;

    public BothTextView(Context context) {
        this(context, null, 0);
    }

    public BothTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BothTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BothTextView);
        this.setSubImageDrawablePadding((int)a.getDimension(R.styleable.BothTextView_bv_subImageDrawablePadding, 0.0f));
        this.setSubImageDrawable(a.getDrawable(R.styleable.BothTextView_bv_subImageDrawable));
        this.setImageDrawableWidth((int)a.getDimension(R.styleable.BothTextView_bv_subImageDrawableWidth, 0.0f));
        this.setImageDrawableHeight((int)a.getDimension(R.styleable.BothTextView_bv_subImageDrawableHeight, 0.0f));
        this.setImageGravityInner(a.getInt(R.styleable.BothTextView_bv_subImageGravity, 1));
        this.setSubText(a.getString(R.styleable.BothTextView_bv_subText));
        this.setSubTextSize(a.getDimensionPixelSize(R.styleable.BothTextView_bv_subTextSize, 0));
        this.setSubTextColor(a.getColor(R.styleable.BothTextView_bv_subTextColor, -16777216));
        this.setSubTextRightPadding((int)a.getDimension(R.styleable.BothTextView_bv_subTextRightPadding, 0.0f));
        this.setDefaultSet(a.getBoolean(R.styleable.BothTextView_bv_subDefaultSet, true));
        a.recycle();
    }

    public void setSubImageDrawablePadding(int padding) {
        this.drawablePadding = padding;
        this.requestLayout();
    }

    public void setSubImageDrawable(Drawable drawable) {
        this.imageDrawable = drawable;
        this.invalidate();
    }

    public void setImageDrawableWidth(int width) {
        this.imageDrawableWidth = width;
        this.invalidate();
    }

    public void setImageDrawableHeight(int height) {
        this.imageDrawableHeight = height;
        this.invalidate();
    }

    public void setImageGravity(@ImageGravity int gravity) {
        this.setImageGravityInner(gravity);
    }

    private void setImageGravityInner(int gravity) {
        this.imageGravity = gravity;
        this.invalidate();
    }

    public void setSubTextRightPadding(int dimension) {
        this.rightPadding = dimension;
        this.invalidate();
    }

    public void setSubTextColor(int color) {
        this.textColor = color;
        this.invalidate();
    }

    public void setSubTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void setSubText(@StringRes int resId) {
        this.subText = this.getContext().getString(resId);
        this.invalidate();
    }

    public void setSubText(String text) {
        this.subText = text;
        this.invalidate();
    }

    public String getSubText() {
        return this.subText;
    }

    public void setDefaultSet(boolean defaultSet) {
        this.defaultSet = defaultSet;
        this.invalidate();
    }

    public void setDefaultSetPaint() {
        TextPaint textPaint = this.getPaint();
        if (null != textPaint && this.defaultSet) {
            this.textPaint.setColor(textPaint.getColor());
            this.textPaint.setTextSize(textPaint.getTextSize());
        } else {
            this.textPaint.setColor(this.textColor);
            this.textPaint.setTextSize((float)this.textSize);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        int textWidth = 0;
        if (!TextUtils.isEmpty((CharSequence)this.subText)) {
            this.setDefaultSetPaint();
            textWidth = Math.round(this.textPaint.measureText(this.subText, 0, this.subText.length()));
        }
        int compoundDrawablesWidth = null == compoundDrawables[2] ? 0 : compoundDrawables[2].getIntrinsicWidth();
        int textRight = width - this.getPaddingRight() - this.rightPadding - compoundDrawablesWidth - textWidth;
        if (null != this.imageDrawable) {
            int intrinsicWidth = this.imageDrawable.getIntrinsicWidth();
            int intrinsicHeight = this.imageDrawable.getIntrinsicHeight();
            int drawableWidth = 0 == this.imageDrawableWidth ? intrinsicWidth : this.imageDrawableWidth;
            int drawableHeight = 0 == this.imageDrawableHeight ? intrinsicHeight : this.imageDrawableHeight;
            int startX = (height - drawableHeight) / 2;
            if (1 == this.imageGravity) {
                this.imageDrawable.setBounds(textRight - this.drawablePadding - drawableWidth, startX, textRight - this.drawablePadding, startX + drawableHeight);
            } else if (2 == this.imageGravity) {
                int rightDrawableStart = width - this.getPaddingRight() - compoundDrawablesWidth;
                textRight -= drawableWidth + this.drawablePadding;
                this.imageDrawable.setBounds(rightDrawableStart - this.drawablePadding - drawableWidth, startX, rightDrawableStart - this.drawablePadding, startX + drawableHeight);
            }
            this.imageDrawable.draw(canvas);
        }
        if (!TextUtils.isEmpty((CharSequence)this.subText)) {
            canvas.drawText(this.subText, (float)textRight, ((float)height - (this.textPaint.descent() + this.textPaint.ascent())) / 2.0f, (Paint)this.textPaint);
        }
    }

    private static @interface ImageGravity {
    }
}

