/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.cz.library.R;
import com.cz.library.callback.ViewCallback;
import com.cz.library.util.Utils;

public class BadgerHelper {
    private static final boolean DEBUG = false;
    public static final int L_T = 0;
    public static final int R_T = 1;
    public static final int L_B = 2;
    public static final int R_B = 3;
    public static final int CENTER = 4;
    private final ViewCallback callback;
    private Drawable labelDrawable;
    private int textColor;
    private float textSize;
    private int horizontalPadding;
    private int verticalPadding;
    private float leftPadding;
    private float topPadding;
    private float rightPadding;
    private float bottomPadding;
    private int drawableWidth;
    private int drawableHeight;
    private int gravity;
    private String text;
    private Paint paint;
    private boolean enable = true;

    public BadgerHelper(ViewCallback callback, Context context, AttributeSet attrs, int defStyleAttr) {
        this.callback = callback;
        this.paint = new Paint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BadgerView);
        this.setBadgerDrawable(a.getDrawable(R.styleable.BadgerView_lt_badgerDrawable));
        this.setBadgerWidth((int)a.getDimension(R.styleable.BadgerView_lt_badgerWidth, 0.0f));
        this.setBadgerHeight((int)a.getDimension(R.styleable.BadgerView_lt_badgerHeight, 0.0f));
        this.setTextColor(a.getColor(R.styleable.BadgerView_lt_textColor, -12303292));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.BadgerView_lt_textSize, Utils.sp2px(12.0f)));
        this.setHorizontalPadding((int)a.getDimension(R.styleable.BadgerView_lt_horizontalPadding, 0.0f));
        this.setVerticalPadding((int)a.getDimension(R.styleable.BadgerView_lt_verticalPadding, 0.0f));
        this.setTextPadding(a.getDimension(R.styleable.BadgerView_lt_textPadding, 0.0f));
        this.setTextLeftPadding(a.getDimension(R.styleable.BadgerView_lt_textLeftPadding, 0.0f));
        this.setTextTopPadding(a.getDimension(R.styleable.BadgerView_lt_textTopPadding, 0.0f));
        this.setTextRightPadding(a.getDimension(R.styleable.BadgerView_lt_textRightPadding, 0.0f));
        this.setTextBottomPadding(a.getDimension(R.styleable.BadgerView_lt_textBottomPadding, 0.0f));
        this.setBadgerGravity(a.getInt(R.styleable.BadgerView_lt_badgerGravity, 0));
        this.setBadgerText(a.getString(R.styleable.BadgerView_lt_badgerText));
        a.recycle();
    }

    public void setTextPadding(float padding) {
        this.leftPadding = padding;
        this.topPadding = padding;
        this.rightPadding = padding;
        this.bottomPadding = padding;
        this.callback.invalidate();
    }

    public void setVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
        this.callback.invalidate();
    }

    public void setBadgerDrawable(@DrawableRes int labelDrawable) {
        this.labelDrawable = ContextCompat.getDrawable((Context)this.callback.getContext(), (int)labelDrawable);
        this.callback.invalidate();
    }

    public void setBadgerDrawable(Drawable drawable) {
        this.labelDrawable = drawable;
        this.callback.invalidate();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.callback.invalidate();
    }

    public void setBadgerText(String text) {
        this.text = text;
        this.callback.invalidate();
    }

    public void setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
        this.callback.invalidate();
    }

    public void setBadgerEnable(boolean enable) {
        this.enable = enable;
        this.callback.invalidate();
    }

    public void setBadgerGravity(int gravity) {
        this.gravity = gravity;
        this.callback.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.callback.invalidate();
    }

    public void setTextLeftPadding(float padding) {
        this.leftPadding = padding;
        this.callback.invalidate();
    }

    public void setTextTopPadding(float padding) {
        this.topPadding = padding;
        this.callback.invalidate();
    }

    public void setTextRightPadding(float padding) {
        this.rightPadding = padding;
        this.callback.invalidate();
    }

    public void setTextBottomPadding(float padding) {
        this.bottomPadding = padding;
        this.callback.invalidate();
    }

    public void setBadgerWidth(int width) {
        this.drawableWidth = width;
        this.callback.invalidate();
    }

    public void setBadgerHeight(int height) {
        this.drawableHeight = height;
        this.callback.invalidate();
    }

    public void onDraw(Canvas canvas) {
        if (!this.enable) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.text)) {
            this.drawDrawable(canvas, this.drawableWidth, this.drawableHeight, 0.0f, 0.0f);
        } else {
            this.paint.setTextSize(this.textSize);
            float textWidth = this.paint.measureText(this.text);
            Rect bounds = new Rect();
            this.paint.getTextBounds(this.text, 0, this.text.length(), bounds);
            int textHeight = bounds.height() * 2;
            int drawableWidth = (int)(textWidth + this.leftPadding + this.rightPadding);
            int drawableHeight = (int)((float)textHeight + this.topPadding + this.bottomPadding);
            if (textWidth < (float)textHeight) {
                drawableWidth = textHeight;
            }
            this.drawDrawable(canvas, drawableWidth, drawableHeight, textWidth, bounds.height());
        }
    }

    private void drawDrawable(Canvas canvas, int drawableWidth, int drawableHeight, float textWidth, float textHeight) {
        if (null != this.labelDrawable) {
            Rect rect;
            int width = this.callback.getWidth();
            int height = this.callback.getHeight();
            switch (this.gravity) {
                case 2: {
                    rect = new Rect(this.horizontalPadding, height - drawableHeight - this.verticalPadding, drawableWidth + this.horizontalPadding, height - this.verticalPadding);
                    break;
                }
                case 1: {
                    rect = new Rect(width - this.horizontalPadding - drawableWidth, this.verticalPadding, width - this.horizontalPadding, drawableHeight + this.verticalPadding);
                    break;
                }
                case 3: {
                    rect = new Rect(width - this.horizontalPadding - drawableWidth, height - drawableHeight - this.verticalPadding, width - this.horizontalPadding, height - this.verticalPadding);
                    break;
                }
                case 4: {
                    rect = new Rect(this.horizontalPadding + (width - drawableWidth) / 2, this.verticalPadding + (height - drawableHeight) / 2, this.horizontalPadding + (width + drawableWidth) / 2, this.verticalPadding + (height + drawableHeight) / 2);
                    break;
                }
                default: {
                    rect = new Rect(this.horizontalPadding, this.verticalPadding, drawableWidth + this.horizontalPadding, drawableHeight + this.verticalPadding);
                }
            }
            this.labelDrawable.setBounds(rect);
            this.labelDrawable.draw(canvas);
            if (!TextUtils.isEmpty((CharSequence)this.text)) {
                this.paint.setColor(this.textColor);
                Paint.FontMetrics fm = this.paint.getFontMetrics();
                float centerVerticalBaselineY = (float)(rect.height() / 2) - fm.descent + (fm.descent - fm.ascent) / 2.0f;
                canvas.drawText(this.text, (float)rect.left + ((float)drawableWidth - textWidth) / 2.0f, (float)rect.top + centerVerticalBaselineY, this.paint);
            }
        }
    }
}

