package com.cz.library.widget.badger;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewTreeObserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by czz on 2017/1/20.
 */

public class Badger {
    private static final HashMap<View,List<View>> decorItems;
    private static final HashMap<View,List<View>> dependItems;

    static {
        decorItems =new HashMap<>();
        dependItems=new HashMap<>();
    }

    public static Badger create(Activity activity, @IdRes int id){
        View decorView =null;
        View findView=null;
        if(null!=activity){
            findView = activity.findViewById(id);
            decorView = activity.getWindow().getDecorView();
        }
        return new Badger(decorView,null,findView);
    }

    public static Badger create(Fragment fragment, @IdRes int id){
        View decorView =null;
        View dependView =null;
        View findView=null;
        if(null!=fragment){
            dependView = fragment.getView();
            if(null!=dependView){
                findView = dependView.findViewById(id);
                FragmentActivity activity = fragment.getActivity();
                if(null!=activity&&null!=findView){
                    decorView = activity.getWindow().getDecorView();
                }
            }
        }
        return new Badger(decorView,dependView,findView);
    }


    private Badger(final View decorView,View dependView,View findView){
        dependToView(dependView,findView);
        dependToDecorView(decorView,findView);

    }

    /**
     * 设置当前弹出消息依赖view
     * @param dependView
     */
    private void dependToView(final View dependView,final View findView) {
        ensureAndAddItem(dependItems,dependView, findView);
        final ViewTreeObserver viewTreeObserver = dependView.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                if(View.GONE == dependView.getVisibility()){
                    //控件隐藏
                    List<View> views = dependItems.get(dependView);
                    if(null!=views){
                        for(View view:views){

                        }
                    }
                } else if (dependView==dependView.getRootView()) {
                    //控件移除
                    dependItems.remove(dependView);
                    if(Build.VERSION.SDK_INT<Build.VERSION_CODES.JELLY_BEAN){
                        viewTreeObserver.removeGlobalOnLayoutListener(this);
                    } else {
                        viewTreeObserver.removeOnGlobalLayoutListener(this);
                    }
                }
            }
        });
    }

    private void dependToDecorView(final View decorView,final View findView) {
        ensureAndAddItem(decorItems,decorView, findView);
        final ViewTreeObserver viewTreeObserver = decorView.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                if (decorView==decorView.getRootView()) {
                    //activity移除
                    decorItems.remove(decorView);
                    if(Build.VERSION.SDK_INT<Build.VERSION_CODES.JELLY_BEAN){
                        viewTreeObserver.removeGlobalOnLayoutListener(this);
                    } else {
                        viewTreeObserver.removeOnGlobalLayoutListener(this);
                    }
                }
            }
        });
    }

    /**
     * 确认并添加新的控件控制
     * @param items
     * @param dependView
     * @param findView
     */
    private void ensureAndAddItem(Map<View,List<View>> items, View dependView, View findView) {
        List<View> views = items.get(dependView);
        if(null==views){
            items.put(dependView,views=new ArrayList<>());
        }
        views.add(findView);
    }

}
