package com.cz.library.widget;

import android.support.annotation.IntDef;
import android.view.View;

import com.cz.library.callback.OnMultiSelectListener;
import com.cz.library.callback.OnRectangleSelectListener;
import com.cz.library.callback.OnSingleSelectListener;
import com.cz.library.callback.Selectable;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by cz on 1/9/17.
 */

public class SelectHelper {
    public static final int STATE_SELECTED=0x00;
    public static final int STATE1=0x01;
    public static final int STATE2=0x02;
    public static final int STATE3=0x03;
    public static final int STATE4=0x04;
    public static final int STATE5=0x05;
    public static final int STATE6=0x06;
    public static final int STATE7=0x07;
    public static final int STATE8=0x08;
    public static final int STATE9=0x09;
    // 三种选择状态
    public static final int SINGLE = 0;//单选
    public static final int MULTI = 1;//多选
    public static final int RECTANGLE = 2;//块选择

    private final Selectable selectable;
    private int singleCheckedIndex =-1;// 选中位置
    private ArrayList<Integer> multiItems;//选中集
    private int start, end;
    private int selectMode;// 选择状态

    private OnRectangleSelectListener rectangleSelectListener;
    private OnMultiSelectListener multiSelectListener;
    private OnSingleSelectListener singleSelectListener;

    public int getSelectMode() {
        return selectMode;
    }

    @IntDef(value = {SINGLE, MULTI, RECTANGLE})
    public @interface SelectMode {
    }

    public SelectHelper(Selectable selectable) {
        this.selectable=selectable;
        multiItems = new ArrayList<>();
    }

    /**
     * 设置选择模式
     *
     * @param mode
     */
    public void setSelectMode(@SelectMode int mode) {
        this.selectMode = mode;
        switch (selectMode) {
            case MULTI:
                singleCheckedIndex = start = end = -1;
                break;
            case RECTANGLE:
                singleCheckedIndex =-1;
                multiItems.clear();
                break;
            case SINGLE:
            default:
                start = end = -1;
                multiItems.clear();
                break;
        }
        selectable.setItemSelect(false);
    }

    /**
     * 设置选中位置
     * @param index
     */
    public void setSingleSelectIndex(int index){
        if(singleCheckedIndex !=index){
            if(-1!=index){
                selectable.setItemSelect(index,true);
            }
            if(-1!= singleCheckedIndex) {
                selectable.setItemSelect(singleCheckedIndex,false);
            }
            singleCheckedIndex = index;
        }
    }

    /**
     * 设置选中位置,且回调信息
     * @param index
     */
    public void setSingleSelectIndexCallback(View v,int index) {
        if(null!=singleSelectListener){
            singleSelectListener.onSelected(v,index,singleCheckedIndex);
        }
        setSingleSelectIndex(index);
    }



    public void setSelectIndex(View v, int index){
        switch (selectMode) {
            case MULTI:
                if (multiItems.contains(index)) {
                    selectable.setItemSelect(index,false);
                    multiItems.remove(Integer.valueOf(index));
                } else {
                    selectable.setItemSelect(index,true);
                    multiItems.add(Integer.valueOf(index));
                }
                if (null != multiSelectListener) {
                    multiSelectListener.onMultiSelected(v, multiItems);
                }
                break;
            case RECTANGLE:
                if (-1 != start && -1 != end) {
                    selectable.setItemSelect(false);
                    start = end = -1;//重置
                } else if (-1 == start) {
                    start = index;
                    selectable.setItemSelect(index,true);
                } else if (-1 == end) {
                    end = index;
                    for(int i=Math.min(start,end);i<=Math.max(start,end);i++){
                        selectable.setItemSelect(i,true);
                    }
                    if (null != rectangleSelectListener) {
                        rectangleSelectListener.onRectangleSelected(start, end);
                    }
                }
                break;
            case SINGLE:
            default:
                setSingleSelectIndexCallback(v,index);
                break;
        }
    }

    /**
     * 设置选择监听
     *
     * @param listener
     */
    public void setOnSingleCheckListener(OnSingleSelectListener listener) {
        this.singleSelectListener = listener;
    }

    public void setOnMultiCheckListener(OnMultiSelectListener listener){
        this.multiSelectListener =listener;
    }

    public void setOnRectangleCheckListener(OnRectangleSelectListener listener){
        this.rectangleSelectListener =listener;
    }

    /**
     * 获得单选位置
     *
     * @return
     */
    public int getSingleCheckedIndex() {
        return singleCheckedIndex;
    }

    /**
     * 获得多选位置
     *
     * @return
     */
    public List<Integer> getMultiSelectIndex() {
        return this.multiItems;
    }

    /**
     * 获得截取开始位置
     *
     * @return
     */
    public int getRectangleStartIndex() {
        return start;
    }

    /**
     * 获得截取结束位置
     *
     * @return
     */
    public int getRectangleEndIndex() {
        return end;
    }
}
