package com.cz.library.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.cz.library.callback.ViewCallback;


/**
 * Created by czz on 16/02/25.
 */
public class BadgerImageView extends ImageView implements ViewCallback{
    public static final int L_T = BadgerHelper.L_T;
    public static final int R_T = BadgerHelper.R_T;
    public static final int L_B = BadgerHelper.L_B;
    public static final int R_B = BadgerHelper.R_B;
    public static final int CENTER = BadgerHelper.CENTER;
    private final BadgerHelper helper;

    public BadgerImageView(Context context) {
        this(context, null, 0);
    }

    public BadgerImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BadgerImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        helper=new BadgerHelper(this,context,attrs,defStyleAttr);
    }

    public BadgerHelper getBadgerHelper(){
        return helper;
    }


    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        helper.onDraw(canvas);
    }

}
