/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.validator;

import android.text.TextWatcher;
import com.cz.library.widget.editlayout.EditLayout;
import com.cz.library.widget.editlayout.IEditText;
import com.cz.library.widget.validator.Editable;
import com.cz.library.widget.validator.ValidatorCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ValidatorObserver<V extends ValidatorCondition, E extends ValidatorCondition & Editable> {
    private final List<V> layouts = new ArrayList<V>();
    private final HashMap<ValidatorCondition, ValidatorTextWatcher> itemTextWatchers = new HashMap();
    private String errorMessage;
    private ValidatorAction validatorAction;

    private ValidatorObserver(E[] layouts) {
        if (null != layouts) {
            this.layouts.addAll(Arrays.asList(layouts));
            for (int i = 0; i < layouts.length; ++i) {
                E layout2 = layouts[i];
                IEditText editor = ((Editable)layout2).getEditor();
                ValidatorTextWatcher textWatcher = new ValidatorTextWatcher(this, layout2);
                this.itemTextWatchers.put((ValidatorCondition)layout2, textWatcher);
                editor.addTextChangedListener(textWatcher);
            }
        }
    }

    public static ValidatorObserver create(EditLayout ... layouts) {
        return new ValidatorObserver((ValidatorCondition[])layouts);
    }

    public ValidatorObserver addValidatorCondition(V condition) {
        this.layouts.add(condition);
        return this;
    }

    public ValidatorObserver subscribe(ValidatorAction action) {
        this.validatorAction = action;
        return this;
    }

    public ValidatorObserver addEditLayout(E layout2) {
        if (null != layout2) {
            IEditText editor = ((Editable)layout2).getEditor();
            ValidatorTextWatcher textWatcher = new ValidatorTextWatcher(this, layout2);
            editor.addTextChangedListener(textWatcher);
            this.itemTextWatchers.put((ValidatorCondition)layout2, textWatcher);
            this.layouts.add(layout2);
        }
        return this;
    }

    public ValidatorObserver removeEditLayout(E layout2) {
        if (null != layout2) {
            this.layouts.remove(layout2);
            ValidatorTextWatcher textWatcher = this.itemTextWatchers.remove(layout2);
            if (null != textWatcher) {
                IEditText editor = ((Editable)layout2).getEditor();
                editor.removeTextChangedListener(textWatcher);
            }
        }
        return this;
    }

    public boolean isValid() {
        boolean result = true;
        for (int i = 0; i < this.layouts.size(); ++i) {
            ValidatorCondition layout2 = (ValidatorCondition)this.layouts.get(i);
            if (result &= layout2.isValid()) continue;
            this.errorMessage = layout2.getEditError();
            break;
        }
        return result;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    static class ValidatorTextWatcher
    implements TextWatcher {
        private boolean isValid;
        private final E layout;
        final /* synthetic */ ValidatorObserver this$0;

        public ValidatorTextWatcher(E layout2) {
            this.this$0 = this$0;
            this.layout = layout2;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            if (this.isValid ^ this.layout.isValid()) {
                boolean bl = this.isValid = !this.isValid;
                if (null != this.this$0.validatorAction) {
                    this.this$0.validatorAction.onChanged(this.layout, this.isValid);
                }
            }
        }

        public void afterTextChanged(android.text.Editable editable) {
        }
    }

    public static interface ValidatorAction<E extends ValidatorCondition & Editable> {
        public void onChanged(E var1, boolean var2);
    }
}

