/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.translation;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import com.cz.library.widget.translation.ITextTranslation;

public class TranslationTextTranslation
extends ITextTranslation {
    private Rect textBounds = new Rect();
    private float fraction;

    public TranslationTextTranslation(View target) {
        super(target);
    }

    @Override
    public void preTranslation(String newValue, String oldValue) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                TranslationTextTranslation.this.fraction = valueAnimator.getAnimatedFraction();
                TranslationTextTranslation.this.target.invalidate();
            }
        });
        valueAnimator.start();
    }

    @Override
    public void drawFrame(Canvas canvas, Paint paint, float x, float y, String newValue, String oldValue) {
        paint.getTextBounds(newValue, 0, newValue.length(), this.textBounds);
        int newTextHeight = this.textBounds.height();
        paint.getTextBounds(oldValue, 0, oldValue.length(), this.textBounds);
        int oldTextHeight = this.textBounds.height();
        canvas.drawText(newValue, x, y - (float)newTextHeight * (1.0f - this.fraction), paint);
        canvas.drawText(oldValue, x, y + (float)oldTextHeight * this.fraction, paint);
    }
}

