/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.editlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import com.cz.library.R;
import com.cz.library.widget.DivideLinearLayout;
import com.cz.library.widget.editlayout.IEditText;
import com.cz.library.widget.validator.Editable;
import com.cz.library.widget.validator.Validator;
import com.cz.library.widget.validator.ValidatorCondition;
import com.cz.library.widget.validator.impl.LengthValidator;
import com.cz.library.widget.validator.impl.NotEmptyValidator;
import com.cz.library.widget.validator.impl.RangeValidator;
import com.cz.library.widget.validator.impl.pattern.CharacterValidator;
import com.cz.library.widget.validator.impl.pattern.EmailValidator;
import com.cz.library.widget.validator.impl.pattern.IdValidator;
import com.cz.library.widget.validator.impl.pattern.NumberValidator;
import com.cz.library.widget.validator.impl.pattern.PatternValidator;
import com.cz.library.widget.validator.impl.pattern.PatternValueValidator;
import com.cz.library.widget.validator.impl.pattern.PhoneValidator;
import com.cz.library.widget.validator.impl.pattern.WebUrlValidator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EditLayout<V extends IEditText>
extends DivideLinearLayout
implements ValidatorCondition,
Editable {
    private static final String TAG = "EditLayout";
    public static final int VALIDATOR_NOT_EMPTY = 1;
    public static final int VALIDATOR_LENGTH = 2;
    public static final int VALIDATOR_RANGE = 4;
    public static final int PATTERN_CHARACTER = 8;
    public static final int PATTERN_EMAIL = 16;
    public static final int PATTERN_NUMBER = 32;
    public static final int PATTERN_PHONE = 64;
    public static final int PATTERN_WEB_URL = 128;
    public static final int PATTERN_ID = 256;
    public static final int INPUT_NUMBER = 1;
    public static final int INPUT_TEXT = 2;
    public static final int INPUT_NUMBER_PASSWORD = 3;
    public static final int INPUT_TEXT_PASSWORD = 4;
    static final int STYLE_NUM_ENTRIES = 6;
    private static final HashMap<String, Integer> validatorFlags = new HashMap();
    private final List<Validator> validatorItems;
    private final SparseArray<String> validatorItemValues;
    private View.OnFocusChangeListener onFocusChangeListener;
    private ImageView hintView;
    private V editor;
    private ImageView deleteView;
    private int errorTextColor;
    private OnTextChangeListener listener;
    private String editError;
    private String emptyError;
    private String errorInfo;
    private int textColor;

    public EditLayout(Context context) {
        this(context, null);
    }

    public EditLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        EditLayout.inflate((Context)context, (int)R.layout.edit_layout, (ViewGroup)this);
        this.setGravity(16);
        this.validatorItems = new ArrayList<Validator>();
        this.validatorItemValues = new SparseArray();
        this.initView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EditLayout);
        this.setHintDrawable(a.getDrawable(R.styleable.EditLayout_sv_hintDrawable));
        this.setEditHint(a.getString(R.styleable.EditLayout_sv_editHint));
        this.setEditText(a.getString(R.styleable.EditLayout_sv_editText));
        this.setEditHintTextColor(a.getColor(R.styleable.EditLayout_sv_editHintTextColor, -12303292));
        this.setEditTextColor(a.getColor(R.styleable.EditLayout_sv_editTextColor, -7829368));
        this.setEditTextSize(a.getDimensionPixelSize(R.styleable.EditLayout_sv_editTextSize, 0));
        this.setSearchDeleteDrawable(a.getDrawable(R.styleable.EditLayout_sv_editDeleteDrawable));
        this.setEditPadding((int)a.getDimension(R.styleable.EditLayout_sv_editPadding, 0.0f));
        this.setEditErrorTextColor(a.getColor(R.styleable.EditLayout_sv_editErrorTextColor, -1));
        this.setEditError(a.getString(R.styleable.EditLayout_sv_editError));
        this.setEditEmptyError(a.getString(R.styleable.EditLayout_sv_editEmptyError));
        this.setEditValidatorValue(a.getString(R.styleable.EditLayout_sv_validatorValue));
        this.setEditValidator(a.getInt(R.styleable.EditLayout_sv_validator, 1));
        this.setPatternValidator(a.getString(R.styleable.EditLayout_sv_patternValidator));
        this.setEditInputType(a.getInt(R.styleable.EditLayout_sv_editInputType, 2));
        this.setEditMaxLength(a.getInteger(R.styleable.EditLayout_sv_editMaxLength, Short.MAX_VALUE));
        this.setEditMaxLine(a.getInteger(R.styleable.EditLayout_sv_editMaxLine, 1));
        a.recycle();
    }

    private void initView() {
        ViewStub editViewStub = (ViewStub)this.findViewById(R.id.view_stub);
        editViewStub.inflate();
        this.hintView = (ImageView)this.findViewById(R.id.iv_hint_icon);
        this.editor = (IEditText)this.findViewById(R.id.et_editor);
        this.deleteView = (ImageView)this.findViewById(R.id.iv_delete_icon);
        this.deleteView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)EditLayout.this.editor.getText())) {
                    EditLayout.this.editor.setText(null);
                    v.setVisibility(8);
                }
            }
        });
        this.editor.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (null != EditLayout.this.onFocusChangeListener) {
                    EditLayout.this.onFocusChangeListener.onFocusChange(view, b);
                }
                EditLayout.this.setSelected(b);
                EditLayout.this.hintView.setSelected(b);
            }
        });
        this.editor.addTextChangedListener(new TextWatcher(){
            private CharSequence lastItem = null;

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (-1 != EditLayout.this.errorTextColor) {
                    EditLayout.this.editor.setTextColor(EditLayout.this.isValid() ? EditLayout.this.textColor : EditLayout.this.errorTextColor);
                }
                EditLayout.this.deleteView.setVisibility(TextUtils.isEmpty((CharSequence)EditLayout.this.editor.getText()) ? 8 : 0);
                if (null != EditLayout.this.listener) {
                    EditLayout.this.listener.onTextChanged(s, this.lastItem, count);
                }
                this.lastItem = s;
            }

            public void afterTextChanged(android.text.Editable s) {
            }
        });
    }

    private void setPatternValidator(String patternValue) {
        String[] patternArray;
        if (!TextUtils.isEmpty((CharSequence)patternValue) && null != (patternArray = patternValue.split("\\s+"))) {
            for (int i = 0; i < patternArray.length; ++i) {
                this.validatorItems.add(new PatternValueValidator(patternArray[i]));
            }
        }
    }

    private int getAttrType(TypedArray typedArray, int index) {
        int attrType = 0;
        Class<TypedArray> clazz = TypedArray.class;
        try {
            Field field = clazz.getDeclaredField("mData");
            field.setAccessible(true);
            Object obj = field.get(typedArray);
            if (null != obj) {
                int[] data = (int[])obj;
                int type = data[index *= 6];
                if (type >= 16 && type <= 31) {
                    attrType = 17;
                } else if (type == 3) {
                    attrType = 3;
                }
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return attrType;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener listener) {
        this.onFocusChangeListener = listener;
    }

    public void setHintDrawableResource(@DrawableRes int res) {
        this.setHintDrawable(this.getResources().getDrawable(res));
    }

    public void setHintDrawable(Drawable drawable) {
        if (null != drawable) {
            this.hintView.setVisibility(0);
            this.hintView.setImageDrawable(drawable);
        } else {
            this.hintView.setVisibility(8);
        }
    }

    public void setEditHint(String text) {
        this.editor.setHint(text);
    }

    public void setEditText(String text) {
        this.editor.setText(text);
        this.editor.setSelection(TextUtils.isEmpty((CharSequence)text) ? 0 : text.length());
    }

    public void setEditHintTextColor(int color) {
        this.editor.setHintTextColor(color);
    }

    public void setEditTextColor(int color) {
        this.textColor = color;
        this.editor.setTextColor(color);
    }

    public void setEditErrorTextColor(int color) {
        this.errorTextColor = color;
    }

    public void setEditTextSize(int textSize) {
        this.editor.setTextSize(0, textSize);
    }

    public void setEditEnabled(boolean enabled) {
        this.editor.setEnabled(enabled);
    }

    public void setEditInputType(int inputType) {
        switch (inputType) {
            case 1: 
            case 3: {
                this.editor.setInputType(2);
                break;
            }
            default: {
                this.editor.setInputType(1);
            }
        }
        this.setEditPasswordTransformation(1 == inputType || 2 == inputType);
    }

    public void setEditPasswordTransformation(boolean show) {
        if (show) {
            this.editor.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
        } else {
            this.editor.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
    }

    public TransformationMethod getTransformationMethod() {
        return this.editor.getTransformationMethod();
    }

    public void toggleEditPasswordTransformation() {
        android.text.Editable text = this.editor.getText();
        TransformationMethod transformationMethod = this.getTransformationMethod();
        if (transformationMethod == HideReturnsTransformationMethod.getInstance()) {
            this.editor.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        } else {
            this.editor.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.editor.setSelection(text.length());
        }
    }

    public void setEditPadding(int padding) {
        this.editor.setPadding(padding, 0, padding, 0);
    }

    public void setEditError(String text) {
        this.editError = text;
    }

    public void setEditEmptyError(String emptyError) {
        this.emptyError = emptyError;
    }

    public void setEditMaxLength(int maxLength) {
        this.editor.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
    }

    public void setEditMaxLine(int maxLine) {
        this.editor.setMaxLines(maxLine);
    }

    private void setEditValidator(int flag) {
        Pattern pattern;
        Matcher matcher;
        String propertyValue;
        this.validatorItems.clear();
        if (0 != (1 & flag)) {
            this.validatorItems.add(new NotEmptyValidator());
        }
        if (0 != (2 & flag) && !TextUtils.isEmpty((CharSequence)(propertyValue = (String)this.validatorItemValues.get(2)))) {
            this.validatorItems.add(new LengthValidator(Integer.valueOf(propertyValue)));
        }
        if (0 != (4 & flag) && !TextUtils.isEmpty((CharSequence)(propertyValue = (String)this.validatorItemValues.get(4))) && (matcher = (pattern = Pattern.compile("(\\d+)-(\\d+)")).matcher(propertyValue)).find()) {
            String start = matcher.group(1);
            String end = matcher.group(2);
            this.validatorItems.add(new RangeValidator(Integer.valueOf(start), Integer.valueOf(end)));
        }
        if (0 != (0x10 & flag)) {
            this.validatorItems.add(new EmailValidator());
        }
        if (0 != (0x20 & flag)) {
            this.validatorItems.add(new NumberValidator());
        }
        if (0 != (0x40 & flag)) {
            this.validatorItems.add(new PhoneValidator());
        }
        if (0 != (0x80 & flag)) {
            this.validatorItems.add(new WebUrlValidator());
        }
        if (0 != (8 & flag)) {
            this.validatorItems.add(new CharacterValidator());
        }
        if (0 != (0x100 & flag)) {
            this.validatorItems.add(new IdValidator());
        }
    }

    private void setEditValidatorValue(String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            Pattern pattern = Pattern.compile("(\\w+):([\\w-]+)\\s*");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String property = matcher.group(1);
                String propertyValue = matcher.group(2);
                if (!validatorFlags.containsKey(property)) continue;
                Integer flag = validatorFlags.get(property);
                if (TextUtils.isEmpty((CharSequence)propertyValue)) continue;
                this.validatorItemValues.put(flag.intValue(), (Object)propertyValue);
            }
        }
    }

    @Override
    public String getEditError() {
        return this.errorInfo;
    }

    @Override
    public boolean isValid() {
        boolean result;
        android.text.Editable text = this.getText();
        boolean validatorResult = true;
        boolean patternResult = false;
        boolean patternMatched = false;
        for (int i = 0; i < this.validatorItems.size(); ++i) {
            Validator validator = this.validatorItems.get(i);
            if (!patternResult && validator instanceof PatternValidator) {
                patternMatched = true;
                if (!(patternResult |= validator.validator(text))) continue;
                break;
            }
            if (!(validatorResult &= validator.validator(text))) break;
        }
        if (!(result = validatorResult & (!patternMatched || patternResult))) {
            if (TextUtils.isEmpty((CharSequence)text) && !TextUtils.isEmpty((CharSequence)this.emptyError)) {
                this.errorInfo = this.emptyError;
            } else if (!TextUtils.isEmpty((CharSequence)this.editError)) {
                this.errorInfo = this.editError;
            }
        }
        return result;
    }

    public V getEditor() {
        return this.editor;
    }

    public android.text.Editable getText() {
        return this.editor.getText();
    }

    public void setSearchDeleteDrawable(Drawable drawable) {
        if (null != drawable) {
            this.deleteView.setImageDrawable(drawable);
        } else {
            this.deleteView.setVisibility(8);
        }
    }

    @Override
    public void setOnTextChangeListener(OnTextChangeListener listener) {
        this.listener = listener;
    }

    static {
        validatorFlags.put("not_empty", 1);
        validatorFlags.put("length", 2);
        validatorFlags.put("range", 4);
    }

    public static interface OnTextChangeListener {
        public void onTextChanged(CharSequence var1, CharSequence var2, int var3);
    }
}

