/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget.drawable;

import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import com.cz.library.annotation.UnitDp;
import com.cz.library.util.ReflectUtils;
import com.cz.library.util.Utils;
import com.cz.library.widget.drawable.GradientBuilder;
import com.cz.library.widget.drawable.LineBuilder;
import com.cz.library.widget.drawable.OvalBuilder;
import com.cz.library.widget.drawable.RectDrawableBuilder;
import com.cz.library.widget.drawable.RingBuilder;

public class DrawableBuilder {
    private static final String TAG = "DrawableBuilder";
    private int shape;
    private int solidColor;
    private int strokeWidth;
    private int strokeColor;
    private int dashWidth;
    private int dashGap;
    private int width;
    private int height;
    private int leftPadding;
    private int topPadding;
    private int rightPadding;
    private int bottomPadding;
    private GradientBuilder gradientBuilder;

    protected DrawableBuilder(@Shape int shape) {
        this.shape = shape;
    }

    public static OvalBuilder oval() {
        return new OvalBuilder();
    }

    public static LineBuilder line() {
        return new LineBuilder();
    }

    public static RectDrawableBuilder rect() {
        return new RectDrawableBuilder();
    }

    public static RingBuilder ring() {
        return new RingBuilder();
    }

    public GradientBuilder setGradientType(@GradientBuilder.GradientType int gradientType) {
        this.gradientBuilder = new GradientBuilder(this, gradientType);
        return this.gradientBuilder;
    }

    public DrawableBuilder setSolidColor(int solidColor) {
        this.solidColor = solidColor;
        return this;
    }

    public DrawableBuilder setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    public DrawableBuilder setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        return this;
    }

    public DrawableBuilder setDashGap(@UnitDp int dashGap) {
        this.dashGap = Utils.dip2px(dashGap);
        return this;
    }

    public DrawableBuilder setDashWidth(@UnitDp int dashWidth) {
        this.dashWidth = Utils.dip2px(dashWidth);
        return this;
    }

    public DrawableBuilder setHeight(@UnitDp int height) {
        this.height = Utils.dip2px(height);
        return this;
    }

    public DrawableBuilder setWidth(@UnitDp int width) {
        this.width = Utils.dip2px(width);
        return this;
    }

    public DrawableBuilder setLeftPadding(int padding) {
        this.leftPadding = padding;
        return this;
    }

    public DrawableBuilder setTopPadding(int padding) {
        this.topPadding = padding;
        return this;
    }

    public DrawableBuilder setRightPadding(int padding) {
        this.rightPadding = padding;
        return this;
    }

    public DrawableBuilder setBottomPadding(int padding) {
        this.bottomPadding = padding;
        return this;
    }

    public DrawableBuilder setPadding(int padding) {
        this.leftPadding = padding;
        this.topPadding = padding;
        this.rightPadding = padding;
        this.bottomPadding = padding;
        return this;
    }

    public GradientDrawable build() {
        GradientDrawable drawable;
        if (null == this.gradientBuilder) {
            drawable = new GradientDrawable();
            drawable.setColor(this.solidColor);
        } else {
            drawable = this.gradientBuilder.create();
        }
        drawable.setShape(this.shape);
        drawable.setStroke(this.strokeWidth, this.strokeColor, (float)this.dashGap, (float)this.dashWidth);
        drawable.setSize(this.width, this.height);
        ReflectUtils.setValue(drawable, "mPadding", new Rect(this.leftPadding, this.topPadding, this.rightPadding, this.bottomPadding));
        return drawable;
    }

    public static @interface Shape {
    }
}

