/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.translation.ITextTranslation;
import java.text.DecimalFormat;

public class TimeDownView
extends View {
    private static final int NO_COLOR = 65536;
    private final String DEFAULT_VALUE = "00";
    public final int MINUTES = 60000;
    public final int HOUR = 3600000;
    public final int DAY = 86400000;
    private final int TYPE_HOUR = 1;
    private final int TYPE_MINUTE = 2;
    private final int TYPE_SECOND = 3;
    public static final int CIRCLE = 0;
    public static final int RECTANGLE = 1;
    private float itemPadding;
    private int intervalMode;
    private int timeValue;
    private float intervalFlagSize;
    private Drawable itemDrawable;
    private Drawable hourItemDrawable;
    private Drawable minuteItemDrawable;
    private Drawable secondItemDrawable;
    private DecimalFormat decimalFormatter;
    private float horizontalIntervalPadding;
    private float verticalIntervalPadding;
    private float itemIntervalRoundRadius;
    private ITextTranslation translation;
    private OnCountDownListener listener;
    private CountDownTimer timer;
    private TextPaint textPaint;
    private int textColor;
    private int hourTextColor;
    private int minuteTextColor;
    private int secondTextColor;
    private Paint paint = new Paint(1);

    public TimeDownView(Context context) {
        this(context, null, 0);
    }

    public TimeDownView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TimeDownView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.textPaint = new TextPaint(1);
        this.decimalFormatter = new DecimalFormat("00");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimeDownView);
        this.setTextColor(a.getColor(R.styleable.TimeDownView_tv_textColor, -1));
        this.setHourTextColor(a.getColor(R.styleable.TimeDownView_tv_hourTextColor, 65536));
        this.setMinuteTextColor(a.getColor(R.styleable.TimeDownView_tv_minuteTextColor, 65536));
        this.setSecondTextColor(a.getColor(R.styleable.TimeDownView_tv_secondTextColor, 65536));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.TimeDownView_tv_textSize, Utils.sp2px(12.0f)));
        this.setItemPadding(a.getDimension(R.styleable.TimeDownView_tv_itemPadding, (float)Utils.dip2px(4.0f)));
        this.setHorizontalItemPadding(a.getDimension(R.styleable.TimeDownView_tv_horizontalItemPadding, 0.0f));
        this.setVerticalItemPadding(a.getDimension(R.styleable.TimeDownView_tv_verticalItemPadding, 0.0f));
        this.setItemIntervalColor(a.getColor(R.styleable.TimeDownView_tv_itemIntervalColor, 0));
        this.setItemIntervalRoundRadius(a.getDimension(R.styleable.TimeDownView_tv_itemIntervalRoundRadius, 0.0f));
        this.setItemDrawable(a.getDrawable(R.styleable.TimeDownView_tv_itemDrawable));
        this.setHourItemDrawable(a.getDrawable(R.styleable.TimeDownView_tv_hourItemDrawable));
        this.setMinuteItemDrawable(a.getDrawable(R.styleable.TimeDownView_tv_minuteItemDrawable));
        this.setSecondItemDrawable(a.getDrawable(R.styleable.TimeDownView_tv_secondItemDrawable));
        this.setTimeValue(a.getInteger(R.styleable.TimeDownView_tv_timeValue, 86400000));
        this.setIntervalMode(a.getInt(R.styleable.TimeDownView_tv_intervalMode, 0));
        this.setIntervalFlagSize(a.getDimension(R.styleable.TimeDownView_tv_intervalFlagSize, (float)Utils.dip2px(1.0f)));
        a.recycle();
    }

    public void setItemIntervalColor(int color2) {
        this.paint.setColor(color2);
        this.invalidate();
    }

    public void setItemIntervalRoundRadius(float radius) {
        this.itemIntervalRoundRadius = radius;
        this.invalidate();
    }

    public void setItemPadding(float itemPadding) {
        this.itemPadding = itemPadding;
        this.invalidate();
    }

    public void setHorizontalItemPadding(float padding) {
        this.horizontalIntervalPadding = padding;
        this.invalidate();
    }

    public void setVerticalItemPadding(float padding) {
        this.verticalIntervalPadding = padding;
        this.invalidate();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public void setHourTextColor(int color2) {
        this.hourTextColor = color2;
        this.invalidate();
    }

    public void setMinuteTextColor(int color2) {
        this.minuteTextColor = color2;
        this.invalidate();
    }

    public void setSecondTextColor(int color2) {
        this.secondTextColor = color2;
        this.invalidate();
    }

    public void setItemDrawable(Drawable drawable) {
        this.itemDrawable = drawable;
        this.invalidate();
    }

    public void setHourItemDrawable(Drawable drawable) {
        this.hourItemDrawable = drawable;
        this.invalidate();
    }

    public void setMinuteItemDrawable(Drawable drawable) {
        this.minuteItemDrawable = drawable;
        this.invalidate();
    }

    public void setSecondItemDrawable(Drawable drawable) {
        this.secondItemDrawable = drawable;
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textPaint.setTextSize(textSize);
        this.invalidate();
    }

    public void setTimeValue(int time) {
        this.timeValue = time;
        this.initTimer(this.timeValue);
        this.invalidate();
    }

    public void setIntervalMode(int mode) {
        this.intervalMode = mode;
        this.invalidate();
    }

    public void setIntervalFlagSize(float size) {
        this.intervalFlagSize = size;
        this.invalidate();
    }

    public void setTextTransaltion(ITextTranslation transaltion) {
        this.translation = transaltion;
    }

    private void initTimer(final int total) {
        if (null != this.timer) {
            this.timer.cancel();
        }
        this.timer = new CountDownTimer(total, 1000L){

            public void onTick(long millisUntilFinished) {
                TimeDownView.this.timeValue = (int)millisUntilFinished;
                if (null != TimeDownView.this.listener) {
                    TimeDownView.this.listener.onTick(total, millisUntilFinished);
                }
                TimeDownView.this.invalidate();
            }

            public void onFinish() {
                if (null != TimeDownView.this.listener) {
                    TimeDownView.this.listener.onFinish(total);
                }
            }
        };
        this.timer.start();
    }

    public void invalidate() {
        if (this.hasWindowFocus()) {
            super.invalidate();
        }
    }

    public void postInvalidate() {
        if (this.hasWindowFocus()) {
            super.postInvalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        String text = "00";
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)text)) {
            textWidth = this.textPaint.measureText(text.toString());
            Rect textRect = new Rect();
            this.textPaint.getTextBounds(text.toString(), 0, text.length(), textRect);
            textHeight = textRect.height();
        }
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        this.setMeasuredDimension((int)((float)paddingLeft + textWidth * 3.0f + this.itemPadding * 2.0f + this.horizontalIntervalPadding * 6.0f + (float)paddingRight), (int)((float)paddingTop + textHeight + this.verticalIntervalPadding * 2.0f + (float)paddingBottom));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int timeMillis = this.timeValue;
        int hour = timeMillis / 3600000;
        int minute = (timeMillis - hour * 3600000) / 60000;
        int second = timeMillis / 1000 % 60;
        float hourOffset = this.drawTimeValue(canvas, hour, this.getPaddingLeft(), 1);
        this.drawInterval(canvas, hourOffset);
        float minuteOffset = this.drawTimeValue(canvas, minute, hourOffset + this.itemPadding, 2);
        this.drawInterval(canvas, minuteOffset);
        this.drawTimeValue(canvas, second, minuteOffset + this.itemPadding, 3);
    }

    private float drawTimeValue(Canvas canvas, int value, float offset, int type) {
        int height = this.getHeight();
        int paddingTop = this.getPaddingTop();
        String text = this.decimalFormatter.format(value);
        float textWidth = this.textPaint.measureText(text);
        float right = offset + textWidth + this.horizontalIntervalPadding * 2.0f;
        Drawable drawable = null;
        if (1 == type) {
            drawable = this.getItemDrawable(this.hourItemDrawable, this.itemDrawable);
        } else if (2 == type) {
            drawable = this.getItemDrawable(this.minuteItemDrawable, this.itemDrawable);
        } else if (3 == type) {
            drawable = this.getItemDrawable(this.secondItemDrawable, this.itemDrawable);
        }
        if (null != drawable) {
            drawable.setBounds((int)offset, paddingTop, (int)right, height - this.getPaddingBottom());
            drawable.draw(canvas);
        }
        float centerY = ((float)height - (this.textPaint.descent() + this.textPaint.ascent())) / 2.0f;
        int color2 = this.textColor;
        if (1 == type) {
            color2 = this.getItemTextColor(this.hourTextColor, this.textColor);
        } else if (2 == type) {
            color2 = this.getItemTextColor(this.minuteTextColor, this.textColor);
        } else if (3 == type) {
            color2 = this.getItemTextColor(this.secondTextColor, this.textColor);
        }
        this.textPaint.setColor(color2);
        canvas.drawText(text, offset + this.horizontalIntervalPadding, centerY, (Paint)this.textPaint);
        return right;
    }

    private int getItemTextColor(int itemColor, int textColor) {
        int color2 = textColor;
        if (itemColor != 65536) {
            color2 = itemColor;
        }
        return color2;
    }

    private Drawable getItemDrawable(Drawable typeItemDrawable, Drawable itemDrawable) {
        Drawable drawable = null;
        if (null != typeItemDrawable) {
            drawable = typeItemDrawable;
        } else if (null != itemDrawable) {
            drawable = itemDrawable;
        }
        return drawable;
    }

    private void drawInterval(Canvas canvas, float offset) {
        this.paint.setStyle(Paint.Style.FILL);
        int itemHeight = this.getHeight() / 3;
        float halfPadding = this.itemPadding / 2.0f;
        if (0 == this.intervalMode) {
            canvas.drawCircle(offset + halfPadding, (float)itemHeight, this.intervalFlagSize, this.paint);
            canvas.drawCircle(offset + halfPadding, (float)(itemHeight * 2), this.intervalFlagSize, this.paint);
        } else {
            canvas.drawRoundRect(new RectF(offset + halfPadding - this.intervalFlagSize / 2.0f, (float)itemHeight - this.intervalFlagSize, offset + halfPadding + this.intervalFlagSize / 2.0f, (float)itemHeight + this.intervalFlagSize), this.itemIntervalRoundRadius, this.itemIntervalRoundRadius, this.paint);
            canvas.drawRoundRect(new RectF(offset + halfPadding - this.intervalFlagSize / 2.0f, (float)(itemHeight * 2) - this.intervalFlagSize, offset + halfPadding + this.intervalFlagSize / 2.0f, (float)(itemHeight * 2) + this.intervalFlagSize), this.itemIntervalRoundRadius, this.itemIntervalRoundRadius, this.paint);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        Parcelable data = super.onSaveInstanceState();
        bundle.putParcelable("data", data);
        bundle.putInt("time", this.timeValue);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        Parcelable superData = bundle.getParcelable("data");
        this.timeValue = bundle.getInt("time");
        super.onRestoreInstanceState(superData);
    }

    public void setOnCountDownListener(OnCountDownListener listener) {
        this.listener = listener;
    }

    public static interface OnCountDownListener {
        public void onTick(long var1, long var3);

        public void onFinish(long var1);
    }
}

