/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.LayoutTransition;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.DivideLinearLayout;

public class TabLinearLayout
extends DivideLinearLayout {
    public static final int TEMPLATE_NONE = 0;
    public static final int TEMPLATE_TEXT = 1;
    public static final int TEMPLATE_IMAGE = 2;
    public static final int STRIP = 0;
    public static final int CLIP = 1;
    public static final int FULL = 2;
    public static final String TAG = "TabLinearLayout";
    private Drawable tabDrawable;
    private int tabWidth;
    private int tabHeight;
    private int horizontalPadding;
    private int verticalPadding;
    private float fraction;
    private int tabMode;
    private ValueAnimator valueAnimator;
    private OnSelectListener listener;
    private LayoutTransition layoutTransition;
    private int selectPosition;
    private int lastPosition;
    private boolean tabSelectReverse;
    private final SparseArray<View> templateItems;

    public TabLinearLayout(Context context) {
        this(context, null);
    }

    public TabLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initTransition();
        this.setWillNotDraw(false);
        this.setClipChildren(false);
        this.templateItems = new SparseArray();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabLinearLayout);
        this.setTabImage(a.getDrawable(R.styleable.TabLinearLayout_tll_tabImage));
        this.setTabWidth((int)a.getDimension(R.styleable.TabLinearLayout_tll_tabWidth, 0.0f));
        this.setTabHeight((int)a.getDimension(R.styleable.TabLinearLayout_tll_tabHeight, (float)Utils.dip2px(2.0f)));
        this.setTabMode(a.getInt(R.styleable.TabLinearLayout_tll_tabMode, 0));
        this.setHorizontalPadding((int)a.getDimension(R.styleable.TabLinearLayout_tll_horizontalPadding, 0.0f));
        this.setVerticalPadding((int)a.getDimension(R.styleable.TabLinearLayout_tll_verticalPadding, 0.0f));
        this.setTabSelectReverse(a.getBoolean(R.styleable.TabLinearLayout_tll_tabSelectReverse, false));
        a.recycle();
    }

    public void setHorizontalPadding(int padding) {
        this.horizontalPadding = padding;
        this.invalidate();
    }

    public void setVerticalPadding(int padding) {
        this.verticalPadding = padding;
        this.invalidate();
    }

    public void setTabWidth(int width) {
        this.tabWidth = width;
        this.invalidate();
    }

    public void setTabHeight(int height) {
        this.tabHeight = height;
        this.invalidate();
    }

    public void setTabImage(Drawable drawable) {
        this.tabDrawable = drawable;
        this.invalidate();
    }

    public void setTabMode(int mode) {
        this.tabMode = mode;
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup viewParent = (ViewGroup)parent;
            viewParent.setClipChildren(1 != mode);
        }
        this.invalidate();
    }

    public void setTabSelectReverse(boolean reverse) {
        this.tabSelectReverse = reverse;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup viewParent = (ViewGroup)parent;
            viewParent.setClipChildren(1 != this.tabMode);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            childView.setSelected(i == this.selectPosition);
            LayoutParams layoutParams = (LayoutParams)childView.getLayoutParams();
            if (1 == layoutParams.mode && childView instanceof TextView) {
                this.templateItems.append(layoutParams.mode, (Object)childView);
                continue;
            }
            if (2 != layoutParams.mode || !(childView instanceof TextView)) continue;
            this.templateItems.append(layoutParams.mode, (Object)childView);
        }
    }

    private void initTransition() {
        this.layoutTransition = new LayoutTransition();
        ObjectAnimator animator1 = ObjectAnimator.ofFloat(null, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(this.layoutTransition.getDuration(2));
        this.layoutTransition.setAnimator(2, (Animator)animator1);
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(null, (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(this.layoutTransition.getDuration(3));
        this.layoutTransition.setAnimator(3, (Animator)animator2);
        this.layoutTransition.setStagger(0, 30L);
        this.layoutTransition.setStagger(1, 30L);
        PropertyValuesHolder pvhLeft = PropertyValuesHolder.ofInt((String)"left", (int[])new int[]{0, 1});
        PropertyValuesHolder pvhTop = PropertyValuesHolder.ofInt((String)"top", (int[])new int[]{0, 1});
        PropertyValuesHolder pvhRight = PropertyValuesHolder.ofInt((String)"right", (int[])new int[]{0, 1});
        PropertyValuesHolder pvhBottom = PropertyValuesHolder.ofInt((String)"bottom", (int[])new int[]{0, 1});
        ObjectAnimator changeIn = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhLeft, pvhTop, pvhRight, pvhBottom}).setDuration(this.layoutTransition.getDuration(0));
        this.layoutTransition.setAnimator(0, (Animator)changeIn);
        ObjectAnimator changeOut = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhLeft, pvhTop, pvhRight, pvhBottom}).setDuration(this.layoutTransition.getDuration(1));
        this.layoutTransition.setAnimator(1, (Animator)changeOut);
        this.setLayoutTransition(this.layoutTransition);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        child.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TabLinearLayout.this.setSelectPosition(TabLinearLayout.this.indexOfChild(v));
            }
        });
    }

    public void removeView(View view) {
        int index = this.indexOfChild(view);
        if (this.selectPosition == index && 0 < this.getChildCount()) {
            this.setCurrentPosition(0);
        }
        super.removeView(view);
    }

    public void removeViewAt(int index) {
        if (this.selectPosition == index && 0 < this.getChildCount()) {
            this.setCurrentPosition(0);
        }
        super.removeViewAt(index);
    }

    public void setSelectPosition(int index) {
        View selectView = this.getChildAt(index);
        if (index != this.selectPosition) {
            if (null != this.valueAnimator) {
                this.valueAnimator.cancel();
            }
            this.selectPosition = index;
            Log.e((String)"valueAnimator", (String)("selectPosition:" + this.selectPosition));
            this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
            this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    TabLinearLayout.this.fraction = valueAnimator.getAnimatedFraction();
                    Log.e((String)"valueAnimator_update", (String)("lastPosition:" + TabLinearLayout.this.lastPosition + " selectPosition:" + TabLinearLayout.this.selectPosition));
                    TabLinearLayout.this.invalidate();
                }
            });
            this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    Log.e((String)"valueAnimator_end", (String)("lastPosition:" + TabLinearLayout.this.lastPosition + " selectPosition:" + TabLinearLayout.this.selectPosition));
                    TabLinearLayout.this.lastPosition = TabLinearLayout.this.selectPosition;
                }
            });
            this.valueAnimator.start();
            View lastView = this.getChildAt(this.lastPosition);
            if (null != selectView) {
                selectView.setSelected(true);
            }
            if (null != lastView) {
                lastView.setSelected(false);
            }
        } else if (this.tabSelectReverse) {
            this.lastPosition = this.selectPosition;
            selectView.setSelected(!selectView.isSelected());
        }
        if (null != this.listener) {
            this.listener.onSelectTab(selectView, this.selectPosition, this.lastPosition);
        }
    }

    public void setCurrentPosition(int index) {
        this.lastPosition = this.selectPosition = index;
        if (null != this.listener) {
            this.listener.onSelectTab(this.getChildAt(index), this.selectPosition, this.lastPosition);
        }
        this.invalidate();
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        int childCount = this.getChildCount();
        if (0 >= childCount || null == this.tabDrawable) {
            return;
        }
        View lastView = this.getChildAt(this.lastPosition);
        View selectView = this.getChildAt(this.selectPosition);
        Rect outRect1 = new Rect();
        Rect outRect2 = new Rect();
        lastView.getHitRect(outRect1);
        selectView.getHitRect(outRect2);
        this.tabDrawable.setBounds(this.getBoundLeft(outRect1, outRect2), this.getBoundTop(outRect1, outRect2), this.getBoundRight(outRect1, outRect2), this.getBoundBottom(outRect1, outRect2));
        this.tabDrawable.draw(canvas);
    }

    private int getBoundLeft(Rect rect1, Rect rect2) {
        int orientation = this.getOrientation();
        int start = 0;
        int end = 0;
        if (0 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerX() - this.tabWidth / 2;
                end = rect2.centerX() - this.tabWidth / 2;
            } else {
                start = rect1.left + this.horizontalPadding;
                end = rect2.left + this.horizontalPadding;
            }
        } else if (1 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.right - this.verticalPadding - this.tabHeight;
                    end = rect2.right - this.verticalPadding - this.tabHeight;
                    break;
                }
                case 1: {
                    start = rect1.right + this.verticalPadding;
                    end = rect2.right + this.verticalPadding;
                    break;
                }
                case 2: {
                    start = rect1.left + this.verticalPadding;
                    end = rect2.left + this.verticalPadding;
                }
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    private int getBoundTop(Rect rect1, Rect rect2) {
        int start = 0;
        int end = 0;
        int orientation = this.getOrientation();
        if (0 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.bottom - this.verticalPadding - this.tabHeight;
                    end = rect2.bottom - this.verticalPadding - this.tabHeight;
                    break;
                }
                case 1: {
                    start = rect1.bottom + this.verticalPadding;
                    end = rect2.bottom + this.verticalPadding;
                    break;
                }
                case 2: {
                    start = rect1.top + this.verticalPadding;
                    end = rect2.top + this.verticalPadding;
                }
            }
        } else if (1 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerY() - this.tabWidth / 2;
                end = rect2.centerY() - this.tabWidth / 2;
            } else {
                start = rect1.top + this.horizontalPadding;
                end = rect2.top + this.horizontalPadding;
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    private int getBoundRight(Rect rect1, Rect rect2) {
        int orientation = this.getOrientation();
        int start = 0;
        int end = 0;
        if (0 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerX() + this.tabWidth / 2;
                end = rect2.centerX() + this.tabWidth / 2;
            } else {
                start = rect1.right - this.horizontalPadding;
                end = rect2.right - this.horizontalPadding;
            }
        } else if (1 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.right - this.verticalPadding;
                    end = rect2.right - this.verticalPadding;
                    break;
                }
                case 1: {
                    start = rect1.right + this.verticalPadding + this.tabHeight;
                    end = rect2.right + this.verticalPadding + this.tabHeight;
                    break;
                }
                case 2: {
                    start = rect1.right - this.verticalPadding;
                    end = rect2.right - this.verticalPadding;
                }
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    private int getBoundBottom(Rect rect1, Rect rect2) {
        int start = 0;
        int end = 0;
        int orientation = this.getOrientation();
        if (0 == orientation) {
            switch (this.tabMode) {
                case 0: {
                    start = rect1.bottom - this.verticalPadding;
                    end = rect2.bottom - this.verticalPadding;
                    break;
                }
                case 1: {
                    start = rect1.bottom + this.verticalPadding + this.tabHeight;
                    end = rect2.bottom + this.verticalPadding + this.tabHeight;
                    break;
                }
                case 2: {
                    start = rect1.bottom - this.verticalPadding;
                    end = rect2.bottom - this.verticalPadding;
                }
            }
        } else if (1 == orientation) {
            if (0 < this.tabWidth) {
                start = rect1.centerY() + this.tabWidth / 2;
                end = rect2.centerY() + this.tabWidth / 2;
            } else {
                start = rect1.bottom - this.horizontalPadding;
                end = rect2.bottom - this.horizontalPadding;
            }
        }
        return start + (int)((float)(end - start) * this.fraction);
    }

    public void scrollToPosition(int position, int fraction) {
        this.lastPosition = this.selectPosition;
        this.selectPosition = position;
        this.fraction = fraction;
        this.invalidate();
    }

    public int getSelectPosition() {
        return this.selectPosition;
    }

    public void addTemplateTextView(String text) {
        TextView textView = this.getTemplateTextView();
        if (null != textView) {
            textView.setText((CharSequence)text);
            this.addView((View)textView);
        }
    }

    public void addTemplateTextView(@StringRes int res) {
        TextView textView = this.getTemplateTextView();
        if (null != textView) {
            textView.setText(res);
            this.addView((View)textView);
        }
    }

    private TextView getTemplateTextView() {
        TextView newTextView = null;
        View childView = (View)this.templateItems.get(1);
        if (null != childView) {
            TextView textView = (TextView)childView;
            newTextView = new TextView(this.getContext());
            newTextView.setTextColor(textView.getTextColors());
            newTextView.setGravity(textView.getGravity());
            newTextView.setTextSize(0, textView.getTextSize());
            Drawable newDrawable = textView.getBackground().getConstantState().newDrawable();
            if (null != newDrawable) {
                if (Build.VERSION.SDK_INT < 16) {
                    newTextView.setBackgroundDrawable(newDrawable);
                } else {
                    newTextView.setBackground(newDrawable);
                }
            }
            newTextView.setPadding(textView.getPaddingLeft(), textView.getPaddingTop(), textView.getPaddingRight(), textView.getPaddingBottom());
        }
        return newTextView;
    }

    public void addTemplateImageView(@DrawableRes int res) {
        ImageView templateImageView = this.getTemplateImageView();
        if (null != templateImageView) {
            templateImageView.setImageResource(res);
        }
    }

    public void addTemplateImageView(Drawable drawable) {
        ImageView templateImageView = this.getTemplateImageView();
        if (null != templateImageView) {
            templateImageView.setImageDrawable(drawable);
        }
    }

    public void setTabText(int index, String text) {
        View childView;
        if (0 <= index && index < this.getChildCount() && null != (childView = this.getChildAt(index)) && childView instanceof TextView) {
            TextView textView = (TextView)childView;
            textView.setText((CharSequence)text);
        }
    }

    public void setTabText(int index, @StringRes int res) {
        View childView;
        if (0 <= index && index < this.getChildCount() && null != (childView = this.getChildAt(index)) && childView instanceof TextView) {
            TextView textView = (TextView)childView;
            textView.setText(res);
        }
    }

    private ImageView getTemplateImageView() {
        ImageView newImageView = null;
        View childView = (View)this.templateItems.get(2);
        if (null != childView) {
            ImageView imageView = (ImageView)childView;
            newImageView = new ImageView(this.getContext());
            newImageView.setScaleType(imageView.getScaleType());
            Drawable newDrawable = imageView.getBackground().getConstantState().newDrawable();
            if (null != newDrawable) {
                if (Build.VERSION.SDK_INT < 16) {
                    newImageView.setBackgroundDrawable(newDrawable);
                } else {
                    newImageView.setBackground(newDrawable);
                }
            }
            newImageView.setPadding(imageView.getPaddingLeft(), imageView.getPaddingTop(), imageView.getPaddingRight(), imageView.getPaddingBottom());
        }
        return newImageView;
    }

    public void setOnSelectListener(OnSelectListener listener) {
        this.listener = listener;
    }

    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LinearLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public int mode;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.TabLinearLayout);
            this.mode = a.getInt(R.styleable.TabLinearLayout_layout_templateView, 0);
            a.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
            this.mode = 0;
        }
    }

    public static interface OnSelectListener {
        public void onSelectTab(View var1, int var2, int var3);
    }
}

