/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.IdRes;
import android.support.v4.view.ViewPager;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.CenterTextView;
import com.cz.library.widget.DivideLinearLayout;

public class TabHost
extends DivideLinearLayout {
    private int color;
    private int selectColor;
    private int padding;
    private int textSize;
    private int indicateColor;
    private float indicateSize;
    private int indicateBackGround;
    private int position;
    private int lastPosition;
    private boolean[] showIndicates;
    private float[] indicateFractions;
    private ViewPager viewPager;
    private OnTabItemClickListener listener;
    private Paint paint;

    public TabHost(Context context) {
        this(context, null);
    }

    public TabHost(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.paint = new Paint(1);
        this.setOrientation(0);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabHost);
        this.setColor(a.getColor(R.styleable.TabHost_th_color, -1));
        this.setSelectColor(a.getColor(R.styleable.TabHost_th_selectColor, -16776961));
        this.setVerticalPadding((int)a.getDimension(R.styleable.TabHost_th_verticalPadding, (float)Utils.dip2px(8.0f)));
        this.setTextSize((int)a.getDimension(R.styleable.TabHost_th_textSize, 10.0f));
        a.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.setOnSpecClickListener(this.getChildAt(i));
        }
    }

    public void setColor(int color2) {
        this.color = color2;
        this.notifyDataChange();
    }

    public void setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        this.notifyDataChange();
    }

    public void setVerticalPadding(int padding) {
        this.padding = padding;
        this.notifyDataChange();
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.notifyDataChange();
    }

    private void notifyDataChange() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView instanceof TextView) {
                TextView textSpec = (TextView)childView;
                textSpec.setTextColor(i == this.lastPosition ? this.selectColor : this.color);
                textSpec.setTextSize((float)this.textSize);
                continue;
            }
            if (!(childView instanceof ImageView)) continue;
            childView.setPadding(this.padding, this.padding, this.padding, this.padding);
        }
    }

    public TextView addTextSpec(@IdRes int id2, String text, int drawableResId) {
        Context context = this.getContext();
        CenterTextView tabSpec = new CenterTextView(context);
        tabSpec.setId(id2);
        tabSpec.setCompoundDrawablePadding(Utils.dip2px(4.0f));
        tabSpec.setDrawableMode(1);
        tabSpec.setCompoundDrawablesWithIntrinsicBounds(0, drawableResId, 0, 0);
        tabSpec.setTextSize(this.textSize);
        boolean isSelect = 0 == this.getChildCount();
        tabSpec.setTextColor(isSelect ? this.selectColor : this.color);
        tabSpec.setSelected(isSelect);
        tabSpec.setText(text);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
        layoutParams.gravity = 17;
        this.addView((View)tabSpec, (ViewGroup.LayoutParams)layoutParams);
        this.setOnSpecClickListener((View)tabSpec);
        return tabSpec;
    }

    public void addImageSpec(int drawableResId) {
        Context context = this.getContext();
        ImageView tabSpec = new ImageView(context);
        tabSpec.setPadding(this.padding, this.padding, this.padding, this.padding);
        tabSpec.setScaleType(ImageView.ScaleType.FIT_CENTER);
        tabSpec.setImageResource(drawableResId);
        tabSpec.setSelected(0 == this.getChildCount());
        this.addView((View)tabSpec, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.setOnSpecClickListener((View)tabSpec);
    }

    public int getCount() {
        return this.getChildCount();
    }

    private void setOnSpecClickListener(View tabSpec) {
        if (null != tabSpec) {
            tabSpec.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int position = TabHost.this.indexOfChild(v);
                    if (null != TabHost.this.listener) {
                        if (position != TabHost.this.lastPosition) {
                            TabHost.this.setSelectPosition(position, true);
                            TabHost.this.setSelectPosition(TabHost.this.lastPosition, false);
                        }
                        TabHost.this.listener.onTabItemClick(v, position, TabHost.this.lastPosition);
                        TabHost.this.lastPosition = position;
                    }
                    if (null != TabHost.this.viewPager) {
                        TabHost.this.viewPager.setCurrentItem(position);
                    }
                }
            });
        }
    }

    public void setSelectPosition(int position, boolean isSelect) {
        if (position >= this.getChildCount()) {
            return;
        }
        View selectView = this.getChildAt(position);
        if (selectView instanceof TextView) {
            selectView.setSelected(isSelect);
            ((TextView)selectView).setTextColor(isSelect ? this.selectColor : this.color);
        } else if (selectView instanceof ImageView) {
            selectView.setSelected(isSelect);
            selectView.setSelected(isSelect);
        }
    }

    public void setOnTabItemClickListener(OnTabItemClickListener listener) {
        this.listener = listener;
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (null == this.showIndicates) {
            return;
        }
        this.paint.setColor(this.indicateBackGround);
        int width = this.getWidth();
        int length = this.showIndicates.length;
        int itemSize = width / length;
        Rect bounds = new Rect();
        for (int i = 0; i < length; ++i) {
            View childView = this.getChildAt(i);
            if (!this.showIndicates[i] || !(childView instanceof TextView)) continue;
            TextView textView = (TextView)childView;
            TextPaint paint = textView.getPaint();
            String text = textView.getText().toString();
            paint.getTextBounds(text, 0, text.length(), bounds);
            int textWidth = bounds.width();
            canvas.drawCircle((float)(i * itemSize + itemSize / 2 + textWidth / 2) + this.indicateSize, this.indicateSize * 2.0f, this.indicateSize, this.paint);
        }
    }

    public static interface OnTabItemClickListener {
        public void onTabItemClick(View var1, int var2, int var3);
    }
}

