/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.cz.library.R;
import com.cz.library.callback.OnMultiSelectListener;
import com.cz.library.callback.OnRectangleSelectListener;
import com.cz.library.callback.OnSingleSelectListener;
import com.cz.library.callback.Selectable;
import com.cz.library.widget.CenterGridLayout;
import com.cz.library.widget.SelectHelper;
import com.cz.library.widget.state.StateTextView;
import java.util.List;

public class SelectGridLayout
extends CenterGridLayout
implements Selectable {
    public static final int LEFT = 3;
    public static final int TOP = 48;
    public static final int RIGHT = 5;
    public static final int BOTTOM = 80;
    private Drawable buttonDrawable;
    private Drawable itemSelectorDrawable;
    private int imageWidth;
    private int imageHeight;
    private int horizontalPadding;
    private int verticalPadding;
    private int imageGravity;
    private final SelectHelper selectHelper;
    private int itemLayoutResourceId;
    private int state;

    public SelectGridLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SelectGridLayout(Context context) {
        this(context, null, 0);
    }

    public SelectGridLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.selectHelper = new SelectHelper(this);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SelectGridLayout);
        this.setButtonImage(a.getDrawable(R.styleable.SelectGridLayout_rl_buttonImage));
        this.setButtonItemSelector(a.getDrawable(R.styleable.SelectGridLayout_rl_buttonItemSelector));
        this.setButtonWidth((int)a.getDimension(R.styleable.SelectGridLayout_rl_imageWidth, 0.0f));
        this.setButtonHeight((int)a.getDimension(R.styleable.SelectGridLayout_rl_imageHeight, 0.0f));
        this.setItemLayout(a.getResourceId(R.styleable.SelectGridLayout_rl_itemLayout, -1));
        this.setButtonHorizontalPadding((int)a.getDimension(R.styleable.SelectGridLayout_rl_buttonHorizontalPadding, 0.0f));
        this.setButtonVerticalPadding((int)a.getDimension(R.styleable.SelectGridLayout_rl_buttonVerticalPadding, 0.0f));
        this.setImageGravity(a.getInt(R.styleable.SelectGridLayout_rl_imageGravity, 85));
        this.setSelectModeInner(a.getInt(R.styleable.SelectGridLayout_rl_selectMode, 0));
        this.setState(a.getInt(R.styleable.SelectGridLayout_rl_state, 0));
        a.recycle();
    }

    public void setItemLayout(@LayoutRes int resourceId) {
        this.itemLayoutResourceId = resourceId;
    }

    public void addTextItems(String[] items) {
        this.addTextItems(items, -1);
    }

    public void addTextItems(String[] items, @IdRes int textIdRes) {
        if (null != items && -1 != this.itemLayoutResourceId) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            for (String item : items) {
                View inflateView = layoutInflater.inflate(this.itemLayoutResourceId, (ViewGroup)this, false);
                TextView textView = null;
                if (-1 != textIdRes) {
                    textView = (TextView)inflateView.findViewById(textIdRes);
                } else if (inflateView instanceof TextView) {
                    textView = (TextView)inflateView;
                }
                if (null != textView) {
                    textView.setText((CharSequence)item);
                }
                this.addView(inflateView);
            }
        }
    }

    public void setButtonItemSelector(Drawable itemSelector) {
        this.itemSelectorDrawable = itemSelector;
        this.refreshItemSelector();
    }

    public void setButtonImage(@DrawableRes int res) {
        this.buttonDrawable = this.getResources().getDrawable(res);
        this.invalidate();
    }

    public void setButtonImage(Drawable drawable) {
        this.buttonDrawable = drawable;
        this.invalidate();
    }

    public void setButtonWidth(int width) {
        this.imageWidth = width;
        this.invalidate();
    }

    public void setButtonHeight(int height) {
        this.imageHeight = height;
        this.invalidate();
    }

    public void setButtonHorizontalPadding(int padding) {
        this.horizontalPadding = padding;
        this.invalidate();
    }

    public void setButtonVerticalPadding(int padding) {
        this.verticalPadding = padding;
        this.invalidate();
    }

    public void setImageGravity(int gravity) {
        this.imageGravity = gravity;
        this.invalidate();
    }

    public void setCheckedMode(@SelectHelper.SelectMode int mode) {
        this.selectHelper.setSelectMode(mode);
        this.invalidate();
    }

    public void setState(int state) {
        this.state = state;
    }

    private void setSelectModeInner(int mode) {
        this.setCheckedMode(mode);
    }

    public void addView(View child, int index) {
        super.addView(child, index);
        this.setViewListener(child);
        this.setBackgroundDrawableCompat(child);
    }

    private void refreshItemSelector() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.setBackgroundDrawableCompat(this.getChildAt(i));
        }
    }

    private void setBackgroundDrawableCompat(View childView) {
        if (null != this.itemSelectorDrawable) {
            Drawable newDrawable = this.itemSelectorDrawable.getConstantState().newDrawable();
            if (Build.VERSION.SDK_INT < 16) {
                childView.setBackgroundDrawable(newDrawable);
            } else {
                childView.setBackground(newDrawable);
            }
        }
    }

    private void setViewListener(View view) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectGridLayout.this.selectHelper.setSelectIndex(v, SelectGridLayout.this.indexOfChild(v));
                SelectGridLayout.this.invalidate();
            }
        });
    }

    public void setSingleSelectIndex(int index) {
        this.selectHelper.setSingleSelectIndex(index);
    }

    public void setSingleSelectIndexCallback(int index) {
        this.selectHelper.setSingleSelectIndexCallback(this.getChildAt(index), index);
    }

    @Override
    public void setItemSelect(boolean select) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.setItemSelect(i, select);
        }
    }

    @Override
    public void setItemSelect(int index, boolean select) {
        View childView = this.getChildAt(index);
        if (0 == this.state) {
            childView.setSelected(select);
        } else if (childView instanceof StateTextView) {
            StateTextView stateTextView = (StateTextView)childView;
            stateTextView.setStateEnabled(this.state, select);
        }
    }

    public SelectHelper getSelectHelper() {
        return this.selectHelper;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (0 >= this.getChildCount() || null == this.buttonDrawable) {
            return;
        }
        int mode = this.selectHelper.getSelectMode();
        switch (mode) {
            case 1: {
                List<Integer> items = this.getMultiSelectedIndex();
                for (Integer index : items) {
                    this.drawChoiceView(canvas, this.getChildAt(index));
                }
                break;
            }
            case 2: {
                int start = this.getRectangleStartIndex();
                int end = this.getRectangleEndIndex();
                if (-1 != start && -1 != end) {
                    for (int i = Math.min(start, end); i <= Math.max(start, end); ++i) {
                        this.drawChoiceView(canvas, this.getChildAt(i));
                    }
                    break;
                }
                if (-1 == start) break;
                this.drawChoiceView(canvas, this.getChildAt(start));
                break;
            }
            default: {
                int singleCheckedIndex = this.getSingleSelectedIndex();
                if (0 > singleCheckedIndex) break;
                this.drawChoiceView(canvas, this.getChildAt(singleCheckedIndex));
            }
        }
    }

    private void drawChoiceView(Canvas canvas, View childView) {
        Rect outRect = new Rect();
        childView.getHitRect(outRect);
        this.imageWidth = 0 == this.imageWidth ? this.buttonDrawable.getIntrinsicWidth() : this.imageWidth;
        this.imageHeight = 0 == this.imageHeight ? this.buttonDrawable.getIntrinsicHeight() : this.imageHeight;
        switch (this.imageGravity) {
            case 3: 
            case 48: 
            case 51: {
                this.drawDrawable(canvas, outRect.left + this.horizontalPadding, outRect.top + this.verticalPadding, outRect.left + this.imageWidth + this.horizontalPadding, outRect.top + this.imageHeight + this.verticalPadding);
                break;
            }
            case 5: 
            case 53: {
                this.drawDrawable(canvas, outRect.right - this.horizontalPadding - this.imageWidth, outRect.top + this.verticalPadding, outRect.right - this.horizontalPadding, outRect.top + this.imageHeight + this.verticalPadding);
                break;
            }
            case 7: 
            case 55: {
                this.drawDrawable(canvas, outRect.centerX() - this.imageWidth / 2, outRect.top + this.verticalPadding, outRect.centerX() + this.imageWidth / 2, outRect.top + this.imageHeight + this.verticalPadding);
                break;
            }
            case 87: {
                this.drawDrawable(canvas, outRect.centerX() - this.imageWidth / 2, outRect.bottom - this.verticalPadding - this.imageHeight, outRect.centerX() + this.imageWidth / 2, outRect.bottom - this.verticalPadding);
                break;
            }
            case 112: 
            case 115: {
                this.drawDrawable(canvas, outRect.left + this.horizontalPadding, outRect.centerY() - this.imageHeight / 2, outRect.left + this.horizontalPadding + this.imageWidth, outRect.centerY() + this.imageHeight / 2);
                break;
            }
            case 117: {
                this.drawDrawable(canvas, outRect.right - this.horizontalPadding - this.imageWidth, outRect.centerY() - this.imageHeight / 2, outRect.right - this.horizontalPadding, outRect.centerY() + this.imageHeight / 2);
                break;
            }
            case 80: 
            case 83: {
                this.drawDrawable(canvas, outRect.left + this.horizontalPadding, outRect.bottom - this.verticalPadding - this.imageHeight, outRect.left + this.horizontalPadding + this.imageWidth, outRect.bottom - this.verticalPadding);
                break;
            }
            case 85: {
                this.drawDrawable(canvas, outRect.right - this.horizontalPadding - this.imageWidth, outRect.bottom - this.verticalPadding - this.imageHeight, outRect.right - this.horizontalPadding, outRect.bottom - this.verticalPadding);
                break;
            }
            case 119: {
                this.drawDrawable(canvas, outRect.centerX() - this.imageWidth / 2, outRect.centerY() - this.imageHeight / 2, outRect.centerX() + this.imageWidth / 2, outRect.centerY() + this.imageHeight / 2);
            }
        }
    }

    private void drawDrawable(Canvas canvas, int left, int top, int right, int bottom) {
        this.buttonDrawable.setBounds(left, top, right, bottom);
        this.buttonDrawable.draw(canvas);
    }

    @Override
    public void setOnSingleSelectListener(OnSingleSelectListener listener) {
        this.selectHelper.setOnSingleCheckListener(listener);
    }

    @Override
    public void setOnMultiSelectListener(OnMultiSelectListener listener) {
        this.selectHelper.setOnMultiCheckListener(listener);
    }

    @Override
    public void setOnRectangleSelectListener(OnRectangleSelectListener listener) {
        this.selectHelper.setOnRectangleCheckListener(listener);
    }

    @Override
    public int getSingleSelectedIndex() {
        return this.selectHelper.getSingleCheckedIndex();
    }

    @Override
    public List<Integer> getMultiSelectedIndex() {
        return this.selectHelper.getMultiSelectIndex();
    }

    @Override
    public int getRectangleStartIndex() {
        return this.selectHelper.getRectangleStartIndex();
    }

    @Override
    public int getRectangleEndIndex() {
        return this.selectHelper.getRectangleEndIndex();
    }
}

