/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import com.cz.library.R;
import java.util.ArrayList;

public class PrivacyLockView
extends View {
    public static final int AUTO = 0;
    public static final int ITEM_PADDING = 1;
    private final StringBuilder editable;
    private final ArrayList<OnTextChangedListener> listeners = new ArrayList();
    private OnTextSubmitListener submitListener;
    private Drawable itemDrawable;
    private int itemPadding;
    private int itemCount;
    private Drawable privacyDrawable;
    private int privacyDrawableWidth;
    private int privacyDrawableHeight;
    private int itemDrawableSize;
    private int intervalMode;

    public PrivacyLockView(Context context) {
        this(context, null);
    }

    public PrivacyLockView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PrivacyLockView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.editable = new StringBuilder();
        this.setFocusableInTouchMode(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PrivacyLockView);
        this.setItemDrawable(a.getDrawable(R.styleable.PrivacyLockView_pv_itemDrawable));
        this.setItemDrawableSize((int)a.getDimension(R.styleable.PrivacyLockView_pv_itemDrawableSize, 0.0f));
        this.setItemPadding((int)a.getDimension(R.styleable.PrivacyLockView_pv_itemPadding, 0.0f));
        this.setItemCount(a.getInteger(R.styleable.PrivacyLockView_pv_itemCount, 4));
        this.setPrivacyDrawable(a.getDrawable(R.styleable.PrivacyLockView_pv_privacyDrawable));
        this.setPrivacyDrawableWidth((int)a.getDimension(R.styleable.PrivacyLockView_pv_privacyDrawableWidth, 0.0f));
        this.setPrivacyDrawableHeight((int)a.getDimension(R.styleable.PrivacyLockView_pv_privacyDrawableHeight, 0.0f));
        this.setIntervalMode(a.getInt(R.styleable.PrivacyLockView_pv_intervalMode, 0));
        a.recycle();
    }

    public void setItemDrawable(Drawable drawable) {
        this.itemDrawable = drawable;
        this.invalidate();
    }

    public void setItemPadding(int itemPadding) {
        this.itemPadding = itemPadding;
        this.invalidate();
    }

    public void setItemCount(int count) {
        this.itemCount = count;
        this.requestLayout();
    }

    public void setPrivacyDrawable(Drawable drawable) {
        this.privacyDrawable = drawable;
        this.invalidate();
    }

    public void setPrivacyDrawableWidth(int drawableWidth) {
        this.privacyDrawableWidth = drawableWidth;
        this.invalidate();
    }

    public void setItemDrawableSize(int size) {
        this.itemDrawableSize = size;
        this.invalidate();
    }

    public void setPrivacyDrawableHeight(int drawableHeight) {
        this.privacyDrawableHeight = drawableHeight;
        this.invalidate();
    }

    public void setIntervalMode(int mode) {
        this.intervalMode = mode;
        this.invalidate();
    }

    private void appendEditText(CharSequence text) {
        if (this.editable.length() < this.itemCount) {
            this.editable.append(text);
            for (OnTextChangedListener listener : this.listeners) {
                listener.onTextChanged(this.editable, this.editable.length() - 1, this.editable.length());
            }
            if (this.editable.length() == this.itemCount) {
                this.hideSortInput();
                if (null != this.submitListener) {
                    this.submitListener.onSubmit(this.editable);
                }
            }
            this.invalidate();
        }
    }

    private void deleteLastEditText() {
        if (!TextUtils.isEmpty((CharSequence)this.editable)) {
            this.editable.deleteCharAt(this.editable.length() - 1);
            for (OnTextChangedListener listener : this.listeners) {
                listener.onTextChanged(this.editable, this.editable.length() + 1, this.editable.length());
            }
            this.invalidate();
        }
    }

    public void clearEditText() {
        this.editable.delete(0, this.editable.length());
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measureHeight = this.getPaddingTop() + this.getPaddingBottom();
        if (0x40000000 == heightMode) {
            measureHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else if (null != this.itemDrawable) {
            if (0 == this.itemDrawableSize || 0 == this.intervalMode) {
                measureHeight += (measureWidth - this.getPaddingLeft() - this.getPaddingRight() - (this.itemCount - 1) * this.itemPadding) / this.itemCount;
            } else if (1 == this.intervalMode) {
                measureHeight += this.itemDrawableSize;
            }
        }
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (gainFocus && this.isFocusableInTouchMode()) {
            imm.showSoftInput((View)this, 2);
        } else {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (hasWindowFocus && this.isFocusableInTouchMode()) {
            imm.showSoftInput((View)this, 2);
        } else {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (event.getAction() == 1 && this.hasFocus()) {
            this.setFocusableInTouchMode(true);
            InputMethodManager input = (InputMethodManager)this.getContext().getSystemService("input_method");
            input.showSoftInput((View)this, 2);
        }
        return true;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        Object inputConnection = super.onCreateInputConnection(outAttrs);
        if (this.onCheckIsTextEditor() && this.isEnabled()) {
            outAttrs.inputType = 4098;
            outAttrs.imeOptions = 6;
            inputConnection = new MyBaseInputConnection(this, true);
        }
        return inputConnection;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (67 == keyCode) {
            this.deleteLastEditText();
            return true;
        }
        if (66 == keyCode) {
            this.hideSortInput();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawItemDrawable(canvas);
        this.drawPrivacyDrawable(canvas);
    }

    private void drawItemDrawable(Canvas canvas) {
        if (null != this.itemDrawable) {
            int width = this.getWidth();
            int paddingTop = this.getPaddingTop();
            int itemSize = 0;
            if (0 == this.itemDrawableSize || 0 == this.intervalMode) {
                itemSize = (width - this.getPaddingLeft() - this.getPaddingRight() - (this.itemCount - 1) * this.itemPadding) / this.itemCount;
            } else if (1 == this.intervalMode) {
                itemSize = this.itemDrawableSize;
            }
            int offsetLeft = this.getPaddingLeft();
            for (int i = 0; i < this.itemCount; ++i) {
                this.itemDrawable.setBounds(offsetLeft, paddingTop, offsetLeft + itemSize, paddingTop + itemSize);
                offsetLeft += itemSize + this.itemPadding;
                this.itemDrawable.draw(canvas);
            }
        }
    }

    private void drawPrivacyDrawable(Canvas canvas) {
        if (null != this.privacyDrawable && 0 != this.privacyDrawableWidth && 0 != this.privacyDrawableHeight) {
            int width = this.getWidth();
            int paddingTop = this.getPaddingTop();
            int itemSize = 0;
            if (0 == this.itemDrawableSize || 0 == this.intervalMode) {
                itemSize = (width - this.getPaddingLeft() - this.getPaddingRight() - (this.itemCount - 1) * this.itemPadding) / this.itemCount;
            } else if (1 == this.intervalMode) {
                itemSize = this.itemDrawableSize;
            }
            int offsetLeft = this.getPaddingLeft();
            for (int i = 0; i < this.editable.length(); ++i) {
                this.privacyDrawable.setBounds(offsetLeft + itemSize / 2 - this.privacyDrawableWidth / 2, paddingTop + itemSize / 2 - this.privacyDrawableHeight / 2, offsetLeft + itemSize / 2 + this.privacyDrawableWidth / 2, paddingTop + itemSize / 2 + this.privacyDrawableHeight / 2);
                offsetLeft += itemSize + this.itemPadding;
                this.privacyDrawable.draw(canvas);
            }
        }
    }

    public boolean onCheckIsTextEditor() {
        return true;
    }

    protected void onDetachedFromWindow() {
        this.hideSortInput();
        super.onDetachedFromWindow();
    }

    private void hideSortInput() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    public void addOnTextChangedListener(OnTextChangedListener listener) {
        if (null != listener && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeOnTextChangedListener(OnTextChangedListener listener) {
        if (null != listener) {
            this.listeners.remove(listener);
        }
    }

    public void setOnTextSubmitListener(OnTextSubmitListener listener) {
        this.submitListener = listener;
    }

    public static interface OnTextSubmitListener {
        public void onSubmit(CharSequence var1);
    }

    public static interface OnTextChangedListener {
        public void onTextChanged(CharSequence var1, int var2, int var3);
    }

    public class MyBaseInputConnection
    extends BaseInputConnection {
        public MyBaseInputConnection(View targetView, boolean fullEditor) {
            super(targetView, fullEditor);
        }

        public boolean commitText(CharSequence text, int newCursorPosition) {
            PrivacyLockView.this.appendEditText(text);
            return true;
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            boolean result = Build.VERSION.SDK_INT >= 14 && beforeLength == 1 && afterLength == 0 ? super.sendKeyEvent(new KeyEvent(0, 67)) && super.sendKeyEvent(new KeyEvent(1, 67)) : super.deleteSurroundingText(beforeLength, afterLength);
            return result;
        }
    }
}

