/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.cz.library.R;

public class LoadView
extends View {
    private static final int AUTO_WIDTH = -1;
    private static final int AUTO_HEIGHT = -1;
    private final Paint circlePaint = new Paint(1);
    private final Paint outRingPaint = new Paint(1);
    private final Paint ringPaint;
    private final Paint arcPaint;
    private AnimatorSet animationSet;
    private int drawableHeight;
    private int drawableWidth;
    private float drawablePadding;
    private Drawable drawable;
    private int ringAngle;
    private int rotateAnimDuration;
    private int scaleAnimDuration;
    private float fraction;
    private float scale;

    public LoadView(Context context) {
        this(context, null, R.attr.loadView);
    }

    public LoadView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.loadView);
    }

    public LoadView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.outRingPaint.setStyle(Paint.Style.STROKE);
        this.ringPaint = new Paint(1);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.arcPaint = new Paint(1);
        this.arcPaint.setStyle(Paint.Style.STROKE);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadView, R.attr.loadView, R.style.LoadView);
        this.setDrawableWidth(a.getLayoutDimension(R.styleable.LoadView_lv_drawableWidth, -1));
        this.setDrawableHeight(a.getLayoutDimension(R.styleable.LoadView_lv_drawableHeight, -1));
        this.setDrawablePadding(a.getDimension(R.styleable.LoadView_lv_drawablePadding, 0.0f));
        this.setDrawableBackgroundColor(a.getColor(R.styleable.LoadView_lv_drawableBackgroundColor, -1));
        this.setRingColor(a.getColor(R.styleable.LoadView_lv_ringColor, -1));
        this.setRingArcColor(a.getColor(R.styleable.LoadView_lv_ringArcColor, -1));
        this.setOutRingColor(a.getColor(R.styleable.LoadView_lv_outRingColor, -1));
        this.setRingAngle(a.getInteger(R.styleable.LoadView_lv_ringAngle, 0));
        this.setRingSize(a.getDimension(R.styleable.LoadView_lv_ringSize, 0.0f));
        this.setOutRingSize(a.getDimension(R.styleable.LoadView_lv_outRingSize, 0.0f));
        this.setDrawable(a.getDrawable(R.styleable.LoadView_lv_drawable));
        this.setRotateAnimDuration(a.getInteger(R.styleable.LoadView_lv_rotateAnimDuration, 2000));
        this.setScaleAnimDuration(a.getInteger(R.styleable.LoadView_lv_scaleAnimDuration, 1000));
        this.setScale(a.getFloat(R.styleable.LoadView_lv_scale, 0.0f));
        a.recycle();
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setDrawableWidth(int width) {
        this.drawableWidth = width;
        this.requestLayout();
    }

    public void setDrawableHeight(int height) {
        this.drawableHeight = height;
        this.requestLayout();
    }

    public void setDrawablePadding(float padding) {
        this.drawablePadding = padding;
        this.invalidate();
    }

    public void setDrawableBackgroundColor(int color2) {
        this.circlePaint.setColor(color2);
    }

    public void setRingColor(int color2) {
        this.ringPaint.setColor(color2);
    }

    public void setRingArcColor(int color2) {
        this.arcPaint.setColor(color2);
    }

    public void setOutRingColor(int color2) {
        this.outRingPaint.setColor(color2);
    }

    public void setRingAngle(int angle) {
        this.ringAngle = angle;
    }

    public void setRingSize(float size) {
        this.arcPaint.setStrokeWidth(size);
        this.ringPaint.setStrokeWidth(size);
    }

    public void setOutRingSize(float size) {
        this.outRingPaint.setStrokeWidth(size);
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
        this.invalidate();
    }

    public void setRotateAnimDuration(int duration) {
        this.rotateAnimDuration = duration;
    }

    public void setScaleAnimDuration(int duration) {
        this.scaleAnimDuration = duration;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = 0;
        int height = 0;
        if (null != this.drawable) {
            width = -1 == this.drawableWidth ? this.drawable.getIntrinsicWidth() : this.drawableWidth;
            height = -1 == this.drawableHeight ? this.drawable.getIntrinsicHeight() : this.drawableHeight;
        }
        width = (int)((float)width + (this.drawablePadding * 2.0f + this.ringPaint.getStrokeWidth() + this.outRingPaint.getStrokeWidth()));
        height = (int)((float)height + (this.drawablePadding * 2.0f + this.ringPaint.getStrokeWidth() + this.outRingPaint.getStrokeWidth()));
        this.setMeasuredDimension(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public void startRotateAnimation() {
        if (null == this.animationSet) {
            this.animationSet = new AnimatorSet();
            ValueAnimator valueAnimator1 = ValueAnimator.ofFloat((float[])new float[]{1.0f});
            valueAnimator1.setDuration((long)this.rotateAnimDuration);
            valueAnimator1.setInterpolator((TimeInterpolator)new LinearInterpolator());
            valueAnimator1.setRepeatCount(-1);
            valueAnimator1.setRepeatMode(1);
            valueAnimator1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    LoadView.this.fraction = animation.getAnimatedFraction();
                    LoadView.this.invalidate();
                }
            });
            ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{1.0f});
            valueAnimator2.setDuration((long)this.scaleAnimDuration);
            valueAnimator2.setRepeatCount(-1);
            valueAnimator2.setRepeatMode(2);
            valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    LoadView.this.setScaleX(1.0f + LoadView.this.scale * animation.getAnimatedFraction());
                    LoadView.this.setScaleY(1.0f + LoadView.this.scale * animation.getAnimatedFraction());
                }
            });
            this.animationSet.play((Animator)valueAnimator1).with((Animator)valueAnimator2);
        }
        this.animationSet.start();
    }

    public void stopRotateAnimation() {
        if (null != this.animationSet) {
            this.animationSet.cancel();
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (null != this.animationSet) {
            if (hasWindowFocus && this.isShown()) {
                this.startRotateAnimation();
            } else {
                this.stopRotateAnimation();
            }
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (null != this.animationSet) {
            if (this.isShown()) {
                this.startRotateAnimation();
            } else {
                this.stopRotateAnimation();
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        int drawableWidth = 0;
        int drawableHeight = 0;
        if (null != this.drawable) {
            drawableWidth = -1 == this.drawableWidth ? this.drawable.getIntrinsicWidth() : this.drawableWidth;
            drawableHeight = -1 == this.drawableHeight ? this.drawable.getIntrinsicHeight() : this.drawableHeight;
        }
        float radius = (float)(Math.min(drawableWidth, drawableHeight) / 2) + this.drawablePadding;
        float ringSize = this.ringPaint.getStrokeWidth();
        canvas.drawCircle((float)centerX, (float)centerY, radius + ringSize / 2.0f, this.outRingPaint);
        canvas.drawCircle((float)centerX, (float)centerY, radius, this.circlePaint);
        canvas.drawCircle((float)centerX, (float)centerY, radius, this.ringPaint);
        int angle = (int)(this.fraction * 360.0f);
        if (Build.VERSION.SDK_INT < 21) {
            canvas.drawArc(new RectF((float)centerX - radius, (float)centerY - radius, (float)centerX + radius, (float)centerY + radius), (float)angle, (float)this.ringAngle, false, this.arcPaint);
        } else {
            canvas.drawArc((float)centerX - radius, (float)centerY - radius, (float)centerX + radius, (float)centerY + radius, (float)angle, (float)this.ringAngle, false, this.arcPaint);
        }
        if (null != this.drawable) {
            this.drawable.setBounds(centerX - drawableWidth / 2, centerY - drawableHeight / 2, centerX + drawableWidth / 2, centerY + drawableHeight / 2);
            this.drawable.draw(canvas);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        Parcelable parcelable = super.onSaveInstanceState();
        bundle.putParcelable("super", parcelable);
        bundle.putInt("drawableWidth", this.drawableWidth);
        bundle.putInt("drawableHeight", this.drawableHeight);
        bundle.putInt("drawableBackgroundColor", this.circlePaint.getColor());
        bundle.putInt("ringColor", this.ringPaint.getColor());
        bundle.putInt("ringArcColor", this.arcPaint.getColor());
        bundle.putInt("ringAngle", this.ringAngle);
        bundle.putInt("outRingColor", this.outRingPaint.getColor());
        bundle.putFloat("outRingSize", this.outRingPaint.getStrokeWidth());
        bundle.putInt("rotateAnimDuration", this.rotateAnimDuration);
        bundle.putInt("scaleAnimDuration", this.scaleAnimDuration);
        bundle.putFloat("scale", this.scale);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        Parcelable parcelable = bundle.getParcelable("super");
        super.onRestoreInstanceState(parcelable);
        this.drawableWidth = bundle.getInt("drawableWidth", -1);
        this.drawableHeight = bundle.getInt("drawableHeight", -1);
        this.circlePaint.setColor(bundle.getInt("drawableBackgroundColor"));
        this.ringPaint.setColor(bundle.getInt("ringColor"));
        this.arcPaint.setColor(bundle.getInt("ringArcColor"));
        this.ringAngle = bundle.getInt("ringAngle");
        this.outRingPaint.setColor(bundle.getInt("outRingColor"));
        this.outRingPaint.setStrokeWidth(bundle.getFloat("outRingSize"));
        this.rotateAnimDuration = bundle.getInt("rotateAnimDuration");
        this.scaleAnimDuration = bundle.getInt("scaleAnimDuration");
        this.scale = bundle.getFloat("scale");
        this.requestLayout();
    }
}

