/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.cz.library.R;
import com.cz.library.util.Utils;

public class ListIndicator
extends View {
    private static final boolean DEBUG = false;
    private static final int PRESS_INDEX = 0;
    private static final int SCALE_COUNT = 5;
    private static final int CIRCLE = 0;
    private static final int RECTANGLE = 1;
    private static final int SCALE_CIRCLE = 2;
    private String[] datum;
    private int type;
    private int color;
    private int textColor;
    private float textSize;
    private float textScale;
    private int textSelectColor;
    private Paint paint;
    private int position;
    private OnIndicatorListener listener;
    private float[] fractions = new float[3];
    private int angle;

    public ListIndicator(Context context) {
        this(context, null, 0);
    }

    public ListIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ListIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.paint = new Paint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ListIndicator);
        this.setType(a.getInt(R.styleable.ListIndicator_li_type, 0));
        this.setColor(a.getColor(R.styleable.ListIndicator_li_color, -16776961));
        this.setTextColor(a.getColor(R.styleable.ListIndicator_li_text_color, -12303292));
        this.setTextSelectColor(a.getColor(R.styleable.ListIndicator_li_select_color, -16776961));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.ListIndicator_li_text_size, Utils.sp2px(12.0f)));
        this.setTextScale(a.getDimensionPixelSize(R.styleable.ListIndicator_li_textScale, Utils.sp2px(20.0f)));
        a.recycle();
    }

    public void setType(int type) {
        this.type = type;
        this.invalidate();
    }

    public void setColor(int color2) {
        this.color = color2;
        this.invalidate();
    }

    public void setTextColor(int color2) {
        this.textColor = color2;
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public void setTextSelectColor(int color2) {
        this.textSelectColor = color2;
        this.invalidate();
    }

    public void setSelectPosition(int position) {
        if (0 > position || position >= this.datum.length) {
            return;
        }
        this.position = position;
        this.invalidate();
    }

    public void setTextScale(float scale) {
        this.textScale = scale;
        this.invalidate();
    }

    public void setAngle(int angle) {
        this.angle = angle;
        this.invalidate();
    }

    public void setData(String[] data) {
        this.datum = data;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (null == this.datum || 0 == this.datum.length) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int length = this.datum.length;
        float itemHeight = (float)height * 1.0f / (float)length;
        Rect bounds = new Rect();
        int position = this.position;
        int scaleCount = 5;
        float scaleWidth = (float)((scaleCount - 1) * 2) * itemHeight;
        this.paint.setStyle(Paint.Style.FILL);
        for (int i = 0; i < length; ++i) {
            if (2 == this.type) {
                int textColor;
                float textSize;
                float y;
                float x;
                float angle;
                float radius = scaleWidth / 2.0f;
                String data = this.datum[i];
                this.paint.setTextSize(this.textSize);
                this.paint.getTextBounds(data, 0, data.length(), bounds);
                if (i > position - scaleCount && i < position) {
                    angle = 180.0f - (float)(position - i) * (90.0f / (float)scaleCount);
                    x = (int)((double)(width / 2) + Math.cos((double)(angle / 360.0f * 2.0f) * Math.PI) * (double)radius);
                    y = (int)((double)((float)position * itemHeight + itemHeight) - Math.sin((double)(angle / 360.0f * 2.0f) * Math.PI) * (double)radius);
                    textSize = this.textSize + (float)(scaleCount - (position - i)) * (this.textScale / (float)scaleCount);
                    textColor = this.evaluate((float)(scaleCount - (position - i)) * 1.0f / (float)scaleCount, this.textColor, this.textSelectColor);
                } else if (i < position + scaleCount && i > position) {
                    angle = 180.0f + (float)(i - position) * (90.0f / (float)scaleCount);
                    x = (int)((double)(width / 2) + Math.cos((double)(angle / 360.0f * 2.0f) * Math.PI) * (double)radius);
                    y = (int)((double)((float)position * itemHeight + itemHeight) - Math.sin((double)(angle / 360.0f * 2.0f) * Math.PI) * (double)radius);
                    textSize = this.textSize + (float)(scaleCount - (i - position)) * (this.textScale / (float)scaleCount);
                    textColor = this.evaluate((float)(scaleCount - (i - position)) * 1.0f / (float)scaleCount, this.textColor, this.textSelectColor);
                } else if (i == position) {
                    x = (int)((double)(width / 2) + Math.cos(Math.PI) * (double)radius);
                    y = (int)((double)((float)position * itemHeight + itemHeight) - Math.sin(Math.PI) * (double)radius);
                    textSize = this.textSize + this.textScale;
                    textColor = this.textSelectColor;
                } else {
                    textSize = this.textSize;
                    x = width / 2 - bounds.centerX();
                    y = itemHeight * (float)i + itemHeight / 2.0f - (float)bounds.centerY();
                    textColor = this.textColor;
                }
                if (i == position) {
                    this.paint.setColor(this.color);
                    RectF rect = this.getBlockRect(width, itemHeight, i);
                    canvas.drawCircle(rect.centerX(), rect.centerY(), Math.min(rect.width(), rect.height()) / 2.0f * (1.0f - this.fractions[0]), this.paint);
                }
                this.paint.setTextSize(this.textSize + (textSize - this.textSize) * this.fractions[0]);
                float targetX = width / 2 - bounds.centerX();
                float targetY = itemHeight * (float)i + itemHeight / 2.0f - (float)bounds.centerY();
                x = targetX + (x - targetX) * this.fractions[0];
                y = targetY + (y - targetY) * this.fractions[0];
                this.paint.setColor(this.evaluate(this.fractions[0], this.textColor, textColor));
                canvas.drawText(data, x, y, this.paint);
            } else if (i == this.position) {
                this.paint.setColor(this.color);
                RectF rect = this.getBlockRect(width, itemHeight, i);
                switch (this.type) {
                    case 1: {
                        canvas.drawRect(rect, this.paint);
                        break;
                    }
                    case 0: {
                        canvas.drawCircle(rect.centerX(), rect.centerY(), Math.min(rect.width(), rect.height()) / 2.0f, this.paint);
                    }
                }
            }
            if (2 == this.type) continue;
            this.paint.setAlpha(255);
            this.paint.setColor(this.textColor);
            this.paint.setTextSize(this.textSize);
            String data = this.datum[i];
            this.paint.getTextBounds(data, 0, data.length(), bounds);
            float x = width / 2 - bounds.centerX();
            float y = itemHeight * (float)i + itemHeight / 2.0f - (float)bounds.centerY();
            canvas.drawText(this.datum[i], x, y, this.paint);
        }
    }

    @NonNull
    private RectF getBlockRect(int width, float itemHeight, int i) {
        RectF rect = (float)width >= itemHeight ? new RectF(((float)width - itemHeight) / 2.0f, itemHeight * (float)i, (float)width - ((float)width - itemHeight) / 2.0f, itemHeight * (float)(i + 1)) : new RectF(0.0f, itemHeight * (float)i + (itemHeight - (float)width) / 2.0f, (float)width, itemHeight * (float)(i + 1) - (itemHeight - (float)width) / 2.0f);
        return rect;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (null == this.datum) {
            return true;
        }
        int action = event.getAction();
        switch (action) {
            case 0: {
                if (null != this.listener) {
                    this.listener.onPress();
                    this.startAnim(0, false);
                }
            }
            case 2: {
                float y = event.getY();
                int position = this.getPosition(y);
                if (0 > position) {
                    position = 0;
                } else if (position >= this.datum.length) {
                    position = this.datum.length - 1;
                }
                if (position != this.position) {
                    if (null != this.listener) {
                        this.listener.onSelect(this.datum[position], position);
                    }
                    this.position = position;
                }
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                if (null == this.listener) break;
                this.listener.onCancel();
                this.startAnim(0, true);
            }
        }
        return true;
    }

    private void startAnim(final int index, final boolean reversal) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float fraction = valueAnimator.getAnimatedFraction();
                ((ListIndicator)ListIndicator.this).fractions[index] = reversal ? 1.0f - fraction : fraction;
                ListIndicator.this.invalidate();
            }
        });
        valueAnimator.start();
    }

    public int evaluate(float fraction, int startColor, int endColor) {
        int startInt = startColor;
        int startA = startInt >> 24;
        int startR = startInt >> 16 & 0xFF;
        int startG = startInt >> 8 & 0xFF;
        int startB = startInt & 0xFF;
        int endInt = endColor;
        int endA = endInt >> 24;
        int endR = endInt >> 16 & 0xFF;
        int endG = endInt >> 8 & 0xFF;
        int endB = endInt & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }

    private int getPosition(float y) {
        return (int)y / (this.getHeight() / this.datum.length);
    }

    public void setOnIndicatorListener(OnIndicatorListener listener) {
        this.listener = listener;
    }

    public static interface OnIndicatorListener {
        public void onPress();

        public void onSelect(String var1, int var2);

        public void onCancel();
    }
}

