/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.StringRes;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.DivideTextView;

public class LabelTextView
extends DivideTextView {
    private static final int DEFAULT_TEXT_SIZE = Utils.sp2px(15.0f);
    private int labelSize;
    private int labelColor;
    private float labelPadding;
    private int labelGravity;
    private boolean defaultSet;
    private String label;
    private Paint paint = new Paint(1);

    public LabelTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LabelTextView);
        this.setLabelSize(a.getDimensionPixelSize(R.styleable.LabelTextView_bv_labelSize, DEFAULT_TEXT_SIZE));
        this.setLabelColor(a.getColorStateList(R.styleable.LabelTextView_bv_labelColor));
        this.setLabelColor(a.getColor(R.styleable.LabelTextView_bv_labelColor, -16777216));
        this.setLabelPadding(a.getDimension(R.styleable.LabelTextView_bv_labelPadding, 0.0f));
        this.setLabel(a.getString(R.styleable.LabelTextView_bv_label));
        this.setBothDefault(a.getBoolean(R.styleable.LabelTextView_bv_labelDefault, true));
        this.setLabelGravity(a.getInt(R.styleable.LabelTextView_bv_labelGravity, 5));
        a.recycle();
    }

    public LabelTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LabelTextView(Context context) {
        this(context, null, 0);
    }

    public void setLabelGravity(int gravity) {
        this.labelGravity = gravity;
        this.invalidate();
    }

    public void setLabelPadding(float padding) {
        this.labelPadding = padding;
    }

    public void setLabelColor(int color2) {
        this.labelColor = color2;
        this.invalidate();
    }

    public void setLabelColor(ColorStateList colorStateList) {
        if (null != colorStateList) {
            // empty if block
        }
    }

    public void setLabelSize(int textSize) {
        this.labelSize = textSize;
        this.invalidate();
    }

    public void setLabel(@StringRes int res) {
        this.label = this.getContext().getString(res);
        this.invalidate();
    }

    public void setLabel(String text) {
        this.label = text;
        this.invalidate();
    }

    private void setBothDefault(boolean isDefault) {
        this.defaultSet = isDefault;
    }

    public String getLabel() {
        return this.label;
    }

    private void initPaint(boolean isDefault) {
        TextPaint textPaint = this.getPaint();
        this.paint.reset();
        if (null != textPaint && isDefault) {
            this.paint.setColor(textPaint.getColor());
            this.paint.setTextSize(textPaint.getTextSize());
        } else {
            this.paint.setColor(this.labelColor);
            this.paint.setTextSize((float)this.labelSize);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.label)) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this.initPaint(this.defaultSet);
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        CharSequence text = this.getText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            TextPaint paint = this.getPaint();
            textWidth = paint.measureText(text.toString());
            Rect bounds = new Rect();
            paint.getTextBounds(text.toString(), 0, text.length(), bounds);
            textHeight = bounds.height();
        }
        float labelTextWidth = this.paint.measureText(this.label);
        Rect textRect = new Rect();
        this.paint.getTextBounds(this.label, 0, this.label.length(), textRect);
        float centerX = ((float)width - labelTextWidth) / 2.0f;
        float centerY = ((float)height - (this.paint.descent() + this.paint.ascent())) / 2.0f;
        int drawableSize = 0;
        int gravity = this.getGravity();
        int drawablePadding = this.getCompoundDrawablePadding();
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        switch (this.labelGravity) {
            case 3: {
                int paddingLeft = this.getPaddingLeft();
                Drawable leftDrawable = compoundDrawables[0];
                if (null != leftDrawable) {
                    drawableSize = leftDrawable.getIntrinsicWidth() + drawablePadding;
                }
                canvas.drawText(this.label, gravity == this.labelGravity ? textWidth : (float)(0 + paddingLeft + drawableSize), centerY, this.paint);
                break;
            }
            case 48: {
                int paddingTop = this.getPaddingLeft();
                Drawable topDrawable = compoundDrawables[0];
                if (null != topDrawable) {
                    drawableSize = topDrawable.getIntrinsicHeight() + drawablePadding;
                }
                canvas.drawText(this.label, centerX, gravity == this.labelGravity ? textHeight : (float)(0 + paddingTop + drawableSize), this.paint);
                break;
            }
            case 5: {
                int paddingRight = this.getPaddingLeft();
                Drawable rightDrawable = compoundDrawables[0];
                if (null != rightDrawable) {
                    drawableSize = rightDrawable.getIntrinsicWidth() + drawablePadding;
                }
                canvas.drawText(this.label, gravity == this.labelGravity ? textWidth : (float)(0 + paddingRight + drawableSize), centerY, this.paint);
                break;
            }
            case 80: {
                int paddingBottom = this.getPaddingLeft();
                Drawable bottomDrawable = compoundDrawables[0];
                if (null != bottomDrawable) {
                    drawableSize = bottomDrawable.getIntrinsicHeight() + drawablePadding;
                }
                canvas.drawText(this.label, centerX, gravity == this.labelGravity ? textHeight : (float)(0 + paddingBottom + drawableSize), this.paint);
                break;
            }
            case 17: {
                break;
            }
        }
    }
}

