/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.cz.library.R;
import com.cz.library.util.Utils;
import com.cz.library.widget.DivideLinearLayout;

public class LabelLinearLayout
extends DivideLinearLayout {
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int CENTER = 16;
    private float textSize;
    private int textColor;
    private float horizontalPadding;
    private float verticalPadding;
    private int gravity;
    private String text;
    private Paint paint;

    public LabelLinearLayout(Context context) {
        this(context, null);
    }

    public LabelLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.paint = new Paint(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LabelLinearLayout);
        this.setTextSize(a.getDimensionPixelSize(R.styleable.LabelLinearLayout_ll_textSize, Utils.sp2px(9.0f)));
        this.setTextColor(a.getColor(R.styleable.LabelLinearLayout_ll_textColor, -12303292));
        this.setHorizontalPadding(a.getDimension(R.styleable.LabelLinearLayout_ll_horizontalPadding, 0.0f));
        this.setVerticalPadding(a.getDimension(R.styleable.LabelLinearLayout_ll_verticalPadding, 0.0f));
        this.setGravity(a.getInt(R.styleable.LabelLinearLayout_ll_gravity, 0));
        a.recycle();
    }

    public void setHorizontalPadding(float padding) {
        this.horizontalPadding = padding;
        this.invalidate();
    }

    public void setVerticalPadding(float padding) {
        this.verticalPadding = padding;
        this.invalidate();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawText(canvas, 1 == (1 | this.gravity), 2 == (2 | this.gravity), 4 == (4 | this.gravity), 8 == (8 | this.gravity), 16 == (0x10 | this.gravity));
    }

    private void drawText(Canvas canvas, boolean left, boolean top, boolean right, boolean bottom, boolean center) {
        if (TextUtils.isEmpty((CharSequence)this.text)) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this.paint.setTextSize(this.textSize);
        this.paint.setColor(this.textColor);
        float textWidth = this.paint.measureText(this.text);
        float x = this.horizontalPadding;
        float y = 0.0f;
        if (left) {
            x = this.horizontalPadding;
        } else if (right) {
            x = (float)width - this.horizontalPadding;
        } else if (center) {
            x = ((float)width - textWidth) / 2.0f;
        }
        float textHeight = -(this.paint.descent() + this.paint.ascent());
        if (top) {
            y = textHeight + this.verticalPadding;
        } else if (bottom) {
            y = (float)height - this.verticalPadding;
        } else if (center) {
            y = ((float)height + textHeight) / 2.0f;
        }
        canvas.drawText(this.text, x, y, this.paint);
    }
}

