/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.cz.library.R;
import com.cz.library.callback.OnItemClickListener;
import com.cz.library.util.ViewCompat;
import java.util.ArrayList;

public class FlowLayout
extends ViewGroup {
    private static final String TAG = "FlowLayout";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int horizontalPadding;
    private int minHorizontalPadding;
    private int verticalPadding;
    private int layoutGravity;
    private boolean debug;
    private final SparseArray<FlowInfomation> flowInformations;
    private OnItemClickListener listener;

    public FlowLayout(Context context) {
        this(context, null, 0);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.debug) {
            this.setWillNotDraw(false);
        }
        ViewCompat.setDefaultViewTranslation(this);
        this.flowInformations = new SparseArray();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlowLayout);
        this.setHorizontalPadding((int)a.getDimension(R.styleable.FlowLayout_fl_horizontalPadding, 0.0f));
        this.setMinHorizontalPadding((int)a.getDimension(R.styleable.FlowLayout_fl_minHorizontalPadding, 0.0f));
        this.setVerticalPadding((int)a.getDimension(R.styleable.FlowLayout_fl_verticalPadding, 0.0f));
        this.setLayoutGravityInner(a.getInteger(R.styleable.FlowLayout_fl_layoutGravity, 0));
        a.recycle();
    }

    public void setHorizontalPadding(int padding) {
        this.horizontalPadding = padding;
        this.requestLayout();
    }

    public void setMinHorizontalPadding(int padding) {
        this.minHorizontalPadding = padding;
        this.requestLayout();
    }

    public void setVerticalPadding(int padding) {
        this.verticalPadding = padding;
        this.requestLayout();
    }

    public void setLayoutGravity(@LayoutGravity int gravity) {
        this.setLayoutGravityInner(gravity);
    }

    public void setLayoutGravityInner(int gravity) {
        this.layoutGravity = gravity;
        this.requestLayout();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int i;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measureHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int childCount = this.getChildCount();
        int rowCount = 0;
        int columnCount = 0;
        int offsetLeft = 0;
        int wrapHeight = this.getPaddingTop();
        this.flowInformations.clear();
        ArrayList<FlowInfomation> currentRowItems = new ArrayList<FlowInfomation>();
        for (i = 0; i < childCount; ++i) {
            FlowInfomation flowInfomation = new FlowInfomation();
            View childView = this.getChildAt(i);
            int childWidth = childView.getMeasuredWidth();
            int childHeight = childView.getMeasuredHeight();
            if (paddingLeft + offsetLeft + childWidth + paddingRight + this.horizontalPadding * (columnCount + 1) <= measureWidth || paddingLeft + offsetLeft + childWidth + paddingRight + this.minHorizontalPadding * (columnCount + 1) <= measureWidth) {
                flowInfomation.column = columnCount++;
                currentRowItems.add(flowInfomation);
                if (paddingLeft + (offsetLeft += childWidth) + paddingRight + this.horizontalPadding * columnCount > measureWidth) {
                    flowInfomation.padding = Math.min((measureWidth - offsetLeft - paddingLeft - paddingRight) / columnCount, this.horizontalPadding);
                    for (FlowInfomation item : currentRowItems) {
                        item.padding = flowInfomation.padding;
                    }
                }
            } else {
                ++rowCount;
                flowInfomation.padding = Math.min((measureWidth - offsetLeft - paddingLeft - paddingRight) / columnCount, this.horizontalPadding);
                for (FlowInfomation item : currentRowItems) {
                    item.offset = offsetLeft;
                    item.columnCount = columnCount;
                    item.padding = flowInfomation.padding;
                }
                currentRowItems.clear();
                currentRowItems.add(flowInfomation);
                wrapHeight += childHeight + this.verticalPadding;
                offsetLeft = childWidth;
                columnCount = 1;
            }
            flowInfomation.rect.left = paddingLeft + offsetLeft - childWidth;
            flowInfomation.rect.top = wrapHeight;
            flowInfomation.rect.right = paddingLeft + offsetLeft;
            flowInfomation.rect.bottom = wrapHeight + childHeight;
            flowInfomation.row = rowCount;
            this.flowInformations.put(i, (Object)flowInfomation);
            if (offsetLeft > measureWidth || i != childCount - 1) continue;
            wrapHeight += childHeight;
            for (FlowInfomation item : currentRowItems) {
                item.columnCount = columnCount;
                item.offset = offsetLeft;
            }
        }
        for (i = 0; this.debug && i < this.flowInformations.size(); ++i) {
            Log.e((String)TAG, (String)("index:" + i + " " + ((FlowInfomation)this.flowInformations.valueAt((int)i)).offset + " " + ((FlowInfomation)this.flowInformations.valueAt((int)i)).columnCount));
        }
        if (0x40000000 == heightMode) {
            this.setMeasuredDimension(measureWidth, measureHeight);
        } else {
            this.setMeasuredDimension(measureWidth, wrapHeight + this.getPaddingBottom());
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        int columnWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        for (int i = 0; i < childCount; ++i) {
            int itemRight;
            int itemLeft;
            int itemPadding;
            View childView = this.getChildAt(i);
            FlowInfomation item = (FlowInfomation)this.flowInformations.get(i);
            if (0 == this.layoutGravity) {
                itemPadding = -1 == item.padding ? this.horizontalPadding : item.padding;
                itemLeft = item.rect.left + itemPadding * item.column;
                itemRight = item.rect.right + itemPadding * item.column;
                childView.layout(itemLeft, item.rect.top, itemRight, item.rect.bottom);
                continue;
            }
            if (1 == this.layoutGravity) {
                itemPadding = (columnWidth - item.offset) / item.columnCount;
                itemLeft = item.rect.left + itemPadding * item.column + itemPadding / 2;
                itemRight = item.rect.right + itemPadding * item.column + itemPadding / 2;
                childView.layout(itemLeft, item.rect.top, itemRight, item.rect.bottom);
                continue;
            }
            if (2 != this.layoutGravity) continue;
            itemPadding = -1 == item.padding ? this.horizontalPadding : item.padding;
            int offsetLeft = (item.column == item.columnCount - 1 ? 0 : item.columnCount - item.column - 1) * itemPadding;
            int itemLeft2 = columnWidth - item.offset + item.rect.left - offsetLeft;
            int itemRight2 = columnWidth - item.offset + item.rect.right - offsetLeft;
            childView.layout(itemLeft2, item.rect.top, itemRight2, item.rect.bottom);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        child.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != FlowLayout.this.listener) {
                    FlowLayout.this.listener.onItemClick(v, FlowLayout.this.indexOfChild(v));
                }
            }
        });
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.debug) {
            int width = this.getWidth();
            int height = this.getHeight();
            Paint paint = new Paint();
            paint.setColor(-65536);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(4.0f);
            canvas.drawLine(0.0f, (float)(height / 2), (float)width, (float)(height / 2), paint);
            canvas.drawLine((float)(width / 2), 0.0f, (float)(width / 2), (float)height, paint);
            canvas.drawRect((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(width - this.getPaddingRight()), (float)(height - this.getPaddingBottom()), paint);
        }
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    class FlowInfomation {
        public int row;
        public int column;
        public int padding = -1;
        public int columnCount;
        public int offset;
        public final Rect rect = new Rect();
    }

    public static @interface LayoutGravity {
    }
}

