/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.cz.library.R;
import com.cz.library.widget.CenterGridLayout;
import java.util.ArrayList;
import java.util.List;

public class FixedGridLayout
extends CenterGridLayout {
    public static final int TYPE_START = 0;
    public static final int TYPE_END = 1;
    private final SparseArray<List<View>> typeItems = new SparseArray();

    public FixedGridLayout(Context context) {
        this(context, null, 0);
    }

    public FixedGridLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FixedGridLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int i = 0;
        while (i < this.getChildCount()) {
            List<View> viewItems;
            View childView = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)childView.getLayoutParams();
            if (0 == layoutParams.itemType) {
                viewItems = this.getViewItems(0);
                super.removeView(childView);
                viewItems.add(childView);
                continue;
            }
            if (1 == layoutParams.itemType) {
                viewItems = this.getViewItems(1);
                super.removeView(childView);
                viewItems.add(childView);
                continue;
            }
            ++i;
        }
        List<View> viewItems = this.getViewItems(0);
        for (int i2 = viewItems.size() - 1; i2 >= 0; --i2) {
            super.addView(viewItems.get(i2), 0, this.generateDefaultLayoutParams());
        }
        viewItems = this.getViewItems(1);
        for (View childView : viewItems) {
            super.addView(childView, this.getChildCount(), this.generateDefaultLayoutParams());
        }
    }

    private List<View> getViewItems(int type) {
        ArrayList views = (ArrayList)this.typeItems.get(type);
        if (null == views) {
            views = new ArrayList();
            this.typeItems.put(type, views);
        }
        return views;
    }

    private int getViewItemSize(int type) {
        List views = (List)this.typeItems.get(type);
        return null == views ? 0 : views.size();
    }

    public void removeStartView(int index) {
        this.removeStartView(this.getTypeViewByIndex(0, index));
    }

    private View getTypeViewByIndex(int type, int index) {
        List<View> viewItems = this.getViewItems(type);
        View view = null;
        if (0 <= index && index < viewItems.size()) {
            view = viewItems.get(index);
        }
        return view;
    }

    public void removeStartView(View view) {
        if (this.isTypeView(view)) {
            super.removeView(view);
            List<View> viewItems = this.getViewItems(0);
            viewItems.remove(view);
        }
    }

    public void removeEndView(int index) {
        this.removeEndView(this.getTypeViewByIndex(1, index));
    }

    public void removeEndView(View view) {
        if (this.isTypeView(view)) {
            super.removeView(view);
            List<View> viewItems = this.getViewItems(1);
            viewItems.remove(view);
        }
    }

    private boolean isTypeView(View view) {
        boolean result = false;
        for (int i = 0; i < this.typeItems.size(); ++i) {
            int key = this.typeItems.keyAt(i);
            List views = (List)this.typeItems.get(key);
            if (null == view || !views.contains(view)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        boolean addLast;
        int childCount = this.getChildCount();
        int startCount = this.getViewItemSize(0);
        int endCount = this.getViewItemSize(1);
        boolean bl = addLast = -1 == index;
        if (0 != startCount && !addLast && index <= startCount) {
            index += startCount;
        } else if (0 != endCount) {
            if (addLast) {
                index = childCount - endCount;
            } else if (index >= childCount - endCount) {
                index -= endCount;
            }
        }
        super.addView(child, index, params);
    }

    public void removeViewAt(int index) {
        int childCount = this.getChildCount();
        int startCount = this.getViewItemSize(0);
        int endCount = this.getViewItemSize(1);
        if (0 != startCount && index <= startCount) {
            index += startCount;
        } else if (0 != endCount && index >= childCount - endCount) {
            index -= endCount;
        }
        super.removeViewAt(index);
    }

    public void removeView(View view) {
        if (!this.isTypeView(view)) {
            super.removeView(view);
        }
    }

    public void removeViews(int start, int count) {
        for (int i = start; i < start + count; ++i) {
            View childView = this.getChildAt(i);
            if (this.isTypeView(childView)) continue;
            super.removeView(childView);
        }
    }

    public void removeAllViews() {
        this.removeViews(0, this.getChildCount());
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return super.generateLayoutParams(p);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int itemType;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FixedGridLayout);
            this.setItemType(a.getInt(R.styleable.FixedGridLayout_layout_itemType, 0));
            a.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        private void setItemType(int itemType) {
            this.itemType = itemType;
        }
    }
}

