/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import com.cz.library.R;

public class CutterLayout
extends FrameLayout {
    public static final String TAG = "CutterLayout";
    private final int MAX_POINT = 2;
    private final Paint paint;
    private final Paint outPaint;
    private float cutSize;
    private float dragEdgeSize;
    private boolean isBeginDragging;
    private final RectF clipRect;

    public CutterLayout(Context context) {
        this(context, null, 0);
    }

    public CutterLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CutterLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.clipRect = new RectF();
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.outPaint = new Paint(1);
        if (Build.VERSION.SDK_INT <= 16) {
            this.setLayerType(1, null);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CutterLayout);
        this.setCutSize(a.getDimension(R.styleable.CutterLayout_cv_cutSize, 0.0f));
        this.setDragEdgeSize(a.getDimension(R.styleable.CutterLayout_cv_dragEdgeSize, 0.0f));
        this.setBorderWidth(a.getDimension(R.styleable.CutterLayout_cv_borderWidth, 0.0f));
        this.setBorderColor(a.getColor(R.styleable.CutterLayout_cv_borderColor, -1));
        this.setOutRectColor(a.getColor(R.styleable.CutterLayout_cv_outRectColor, -1));
        a.recycle();
    }

    public void setCutSize(float size) {
        this.cutSize = size;
        this.invalidate();
    }

    public void setDragEdgeSize(float edgeSize) {
        this.dragEdgeSize = edgeSize;
        this.invalidate();
    }

    public void setBorderWidth(float borderWidth) {
        this.paint.setStrokeWidth(borderWidth);
        this.invalidate();
    }

    public void setBorderColor(int color) {
        this.paint.setColor(color);
        this.invalidate();
    }

    private void setOutRectColor(int color) {
        this.outPaint.setColor(color);
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float left = ((float)w - this.cutSize) / 2.0f;
        float paintHalfStrokeWidth = this.paint.getStrokeWidth() / 2.0f;
        this.clipRect.set(left, paintHalfStrokeWidth, left + this.cutSize, (float)h - paintHalfStrokeWidth);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        canvas.clipRect(this.clipRect, Region.Op.DIFFERENCE);
        float halfStrokeWidth = this.outPaint.getStrokeWidth();
        canvas.drawRect(halfStrokeWidth, halfStrokeWidth, (float)width - halfStrokeWidth, (float)height - halfStrokeWidth, this.outPaint);
        canvas.drawRect(this.clipRect, this.paint);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        int actionMasked = ev.getActionMasked();
        switch (actionMasked) {
            case 0: {
                RectF leftRect = new RectF(this.clipRect.left - this.dragEdgeSize, this.clipRect.top, this.clipRect.left + this.dragEdgeSize, this.clipRect.bottom);
                RectF rightRect = new RectF(this.clipRect.right - this.dragEdgeSize, this.clipRect.top, this.clipRect.right + this.dragEdgeSize, this.clipRect.bottom);
                this.isBeginDragging = leftRect.contains(x, y) || rightRect.contains(x, y);
                break;
            }
            case 1: 
            case 3: {
                this.isBeginDragging = false;
            }
        }
        return this.isBeginDragging;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int actionMasked = event.getActionMasked();
        if (2 == actionMasked && this.isBeginDragging) {
            int pointerCount = Math.min(event.getPointerCount(), 2);
            for (int i = 0; i < pointerCount; ++i) {
                int pointerId = event.getPointerId(i);
                int pointerIndex = event.findPointerIndex(pointerId);
                float x = event.getX(pointerIndex);
                float width = this.clipRect.width();
                if (x < this.clipRect.centerX() && width >= this.cutSize) {
                    this.clipRect.left = this.clipRect.right - x < this.cutSize ? this.clipRect.right - this.cutSize : x;
                }
                if (x > this.clipRect.centerX() && width >= this.cutSize) {
                    this.clipRect.right = x - this.clipRect.left < this.cutSize ? this.clipRect.left + this.cutSize : x;
                }
                this.invalidate();
            }
        }
        return true;
    }
}

