/*
 * Decompiled with CFR 0.152.
 */
package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.cz.library.R;
import com.cz.library.callback.OnItemClickListener;
import com.cz.library.util.ViewCompat;

public class CenterGridLayout
extends ViewGroup {
    public static final int AUTO_HEIGHT = -1;
    public static final int ITEM_WIDTH = 0;
    public static final int HORIZONTAL_PADDING = 1;
    private int fixRaw;
    private int raw;
    private int itemWidth;
    private int fixItemWidth;
    private int itemHeight;
    private int horizontalPadding;
    private int fixHorizontalPadding;
    private int verticalPadding;
    private int itemSizeMode;
    private OnItemClickListener listener;

    public CenterGridLayout(Context context) {
        this(context, null, 0);
    }

    public CenterGridLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CenterGridLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ViewCompat.setDefaultViewTranslation(this);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CenterGridLayout);
        this.setFixRaw(a.getInteger(R.styleable.CenterGridLayout_cl_fixRaw, 0));
        this.setItemWidth((int)a.getDimension(R.styleable.CenterGridLayout_cl_itemWidth, 0.0f));
        this.setItemHeight(a.getLayoutDimension(R.styleable.CenterGridLayout_cl_itemHeight, 0));
        this.setItemHorizontalPadding((int)a.getDimension(R.styleable.CenterGridLayout_cl_itemHorizontalPadding, 0.0f));
        this.setItemVerticalPadding((int)a.getDimension(R.styleable.CenterGridLayout_cl_itemVerticalPadding, 0.0f));
        this.setItemSizeMode(a.getInt(R.styleable.CenterGridLayout_cl_itemSizeMode, 0));
        a.recycle();
    }

    public void setItemSizeMode(int mode) {
        this.itemSizeMode = mode;
        this.requestLayout();
    }

    public void setFixRaw(int fixRaw) {
        this.fixRaw = fixRaw;
        this.requestLayout();
    }

    public void setItemVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
        this.requestLayout();
    }

    public void setItemHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
        this.fixHorizontalPadding = horizontalPadding;
        this.requestLayout();
    }

    public void setItemWidth(int itemWidth) {
        this.itemWidth = itemWidth;
        this.fixItemWidth = itemWidth;
        this.requestLayout();
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minHeight;
        int childWidth;
        int childCount = this.getChildCount();
        int childHeight = 0;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec) - paddingLeft - paddingRight;
        if (0 < this.fixRaw) {
            if (0 < this.itemWidth) {
                switch (this.itemSizeMode) {
                    case 0: {
                        this.itemWidth = width < this.fixItemWidth * this.fixRaw ? (width - (this.fixRaw + 1) * this.fixHorizontalPadding) / this.fixRaw : this.fixItemWidth;
                        this.horizontalPadding = (width - this.fixRaw * this.itemWidth) / (this.fixRaw + 1);
                        break;
                    }
                    case 1: {
                        this.horizontalPadding = this.fixHorizontalPadding;
                        this.itemWidth = (width - (this.fixRaw + 1) * this.fixHorizontalPadding) / this.fixRaw;
                    }
                }
                childWidth = this.itemWidth;
            } else {
                childWidth = (width - (this.fixRaw + 1) * this.fixHorizontalPadding) / this.fixRaw;
            }
            this.raw = this.fixRaw;
        } else {
            childWidth = this.fixItemWidth;
            switch (this.itemSizeMode) {
                case 0: {
                    this.raw = width / childWidth;
                    if (0 < childCount && childCount < this.raw) {
                        this.raw = childCount;
                    }
                    this.horizontalPadding = (width - childWidth * this.raw) / (this.raw + 1);
                    break;
                }
                case 1: {
                    this.horizontalPadding = this.fixHorizontalPadding;
                    this.raw = width / (childWidth + this.horizontalPadding);
                    if (width < width - this.raw * this.fixItemWidth - (this.raw + 1) * this.fixHorizontalPadding) {
                        --this.raw;
                    }
                    childWidth = this.itemWidth = (width - (this.raw + 1) * this.fixHorizontalPadding) / this.raw;
                }
            }
        }
        int row = 0 == childCount % this.raw ? childCount / this.raw : childCount / this.raw + 1;
        int cellWidthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
        int cellHeightSpec = heightMeasureSpec;
        if (-1 != this.itemHeight) {
            childHeight = this.itemHeight;
            cellHeightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
        }
        for (int index = 0; index < childCount; ++index) {
            View child = this.getChildAt(index);
            child.measure(cellWidthSpec, cellHeightSpec);
            if (0 <= this.itemHeight) continue;
            childHeight = this.itemHeight = child.getMeasuredHeight();
        }
        int totalHeight = 0;
        if (0 < childCount) {
            totalHeight = paddingTop + paddingBottom + childHeight * row + this.verticalPadding * (row + 1);
        }
        if (totalHeight < (minHeight = this.getSuggestedMinimumHeight())) {
            totalHeight = minHeight;
        }
        this.setMeasuredDimension(CenterGridLayout.resolveSize((int)width, (int)widthMeasureSpec), CenterGridLayout.resolveSize((int)totalHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int x = paddingLeft + this.horizontalPadding;
        int y = paddingTop + this.verticalPadding;
        int index = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int itemWidth = child.getMeasuredWidth();
            int itemHeight = child.getMeasuredHeight();
            child.layout(x, y, x + itemWidth, y + itemHeight);
            if (index >= this.raw - 1) {
                index = 0;
                x = paddingLeft + this.horizontalPadding;
                y += itemHeight + this.verticalPadding;
                continue;
            }
            ++index;
            x += itemWidth + this.horizontalPadding;
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        child.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != CenterGridLayout.this.listener) {
                    CenterGridLayout.this.listener.onItemClick(v, CenterGridLayout.this.indexOfChild(v));
                }
            }
        });
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }
}

