package com.cz.library.widget.validator;

import android.text.Editable;
import android.text.TextWatcher;

import com.cz.library.widget.editlayout.EditLayout;
import com.cz.library.widget.editlayout.IEditText;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;


/**
 * Created by czz on 2016/9/23.
 * 匹配信息检测观察者对象
 */
public class ValidatorObserver<V extends ValidatorCondition,E extends ValidatorCondition & com.cz.library.widget.validator.Editable> {
    private final List<V> layouts;
    private final HashMap<ValidatorCondition,ValidatorTextWatcher> itemTextWatchers;
    private String errorMessage;
    private ValidatorAction validatorAction;

    private ValidatorObserver(E[] layouts) {
        this.layouts = new ArrayList<>();
        this.itemTextWatchers=new HashMap<>();
        if(null!=layouts){
            this.layouts.addAll((Collection<V>) Arrays.asList(layouts));
            for(int i=0;i<layouts.length;i++){
                E layout = layouts[i];
                IEditText editor = layout.getEditor();
                ValidatorTextWatcher textWatcher = new ValidatorTextWatcher(layout);
                itemTextWatchers.put(layout,textWatcher);
                editor.addTextChangedListener(textWatcher);
            }
        }
    }
    public static ValidatorObserver create(EditLayout... layouts){
        return new ValidatorObserver(layouts);
    }

    public ValidatorObserver addValidatorCondition(V condition){
        layouts.add(condition);
        return this;
    }

    public ValidatorObserver subscribe(ValidatorAction action){
        this.validatorAction=action;
        return this;
    }

    public ValidatorObserver addEditLayout(E layout){
        if(null!=layout){
            IEditText editor = layout.getEditor();
            ValidatorTextWatcher textWatcher = new ValidatorTextWatcher(layout);
            editor.addTextChangedListener(textWatcher);
            itemTextWatchers.put(layout, textWatcher);
            layouts.add((V) layout);
        }
        return this;
    }

    public ValidatorObserver removeEditLayout(E layout){
        if(null!=layout){
            layouts.remove(layout);
            ValidatorTextWatcher textWatcher = itemTextWatchers.remove(layout);
            if(null!=textWatcher){
                IEditText editor = layout.getEditor();
                editor.removeTextChangedListener(textWatcher);
            }
        }
        return this;
    }

    /**
     * 判断所有布局条件是否匹配
     * @return
     */
    public boolean isValid(){
        boolean result=true;
        for(int i=0;i<layouts.size();i++){
            V layout = layouts.get(i);
            if(!(result&=layout.isValid())){
                errorMessage=layout.getEditError();
                break;
            }
        }
        return result;
    }

    /**
     * 获得检测失败异常信息
     * @return
     */
    public String getErrorMessage(){
        return errorMessage;
    }

    public interface ValidatorAction<E extends ValidatorCondition & com.cz.library.widget.validator.Editable>{
        void onChanged(E editLayout,boolean changed);
    }

    class ValidatorTextWatcher implements TextWatcher {
        private boolean isValid;
        private final E layout;

        public ValidatorTextWatcher(E layout) {
            this.layout = layout;
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            if(isValid^layout.isValid()){
                isValid=!isValid;
                if(null!=validatorAction){
                    validatorAction.onChanged(layout,isValid);
                }
            }
        }

        @Override
        public void afterTextChanged(Editable editable) {
        }
    }
}
