package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

import com.cz.library.R;
import com.cz.library.callback.OnMultiSelectListener;
import com.cz.library.callback.OnRectangleSelectListener;
import com.cz.library.callback.OnSingleSelectListener;
import com.cz.library.callback.Selectable;
import com.cz.library.widget.state.StateTextView;

import java.util.List;

/**
 * Created by cz on 1/9/17.
 */

public class SelectFlowLayout extends FlowLayout implements Selectable{
    private final SelectHelper selectHelper;
    private Drawable itemSelectorDrawable;
    private int state;

    public SelectFlowLayout(Context context) {
        this(context,null,0);
    }

    public SelectFlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs,0);
    }

    public SelectFlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        selectHelper=new SelectHelper(this);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SelectFlowLayout);
        setButtonItemSelector(a.getDrawable(R.styleable.SelectFlowLayout_sl_buttonItemSelector));
        setState(a.getInt(R.styleable.SelectFlowLayout_sl_state,SelectHelper.STATE_SELECTED));
        a.recycle();

    }

    public void setButtonItemSelector(Drawable itemSelector) {
        this.itemSelectorDrawable=itemSelector;
        refreshItemSelector();
    }
    public void setState(int state){
        this.state=state;
    }


    @Override
    public void setItemSelect(boolean select) {
        int childCount = getChildCount();
        for(int i=0;i<childCount;i++){
            setItemSelect(i,select);
        }
    }

    @Override
    public void setItemSelect(int index, boolean select) {
        View childView = getChildAt(index);
        if(SelectHelper.STATE_SELECTED==state){
            childView.setSelected(select);
        } else if(childView instanceof StateTextView){
            StateTextView stateTextView = (StateTextView) childView;
            stateTextView.setStateEnabled(state,select);
        }
    }

    /**
     * 设置选中位置
     * @param index
     */
    public void setSingleSelectIndex(int index){
        selectHelper.setSingleSelectIndex(index);
    }

    /**
     * 设置选中位置,且回调信息
     * @param index
     */
    public void setSingleSelectIndexCallback(int index) {
        selectHelper.setSingleSelectIndexCallback(getChildAt(index),index);
    }

    @Override
    public void addView(View child, int index, LayoutParams params) {
        super.addView(child, index, params);
        setViewListener(child);
        setBackgroundDrawableCompat(child);
    }

    private void refreshItemSelector(){
        int childCount = getChildCount();
        for(int i=0;i<childCount;i++){
            setBackgroundDrawableCompat(getChildAt(i));
        }
    }

    private void setBackgroundDrawableCompat(View childView) {
        if(null!=itemSelectorDrawable) {
            Drawable newDrawable = itemSelectorDrawable.getConstantState().newDrawable();
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
                childView.setBackgroundDrawable(newDrawable);
            } else {
                childView.setBackground(newDrawable);
            }
        }
    }

    /**
     * 设置view选中事件
     *
     * @param view
     */
    private void setViewListener(final View view) {
        view.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                selectHelper.setSelectIndex(v,indexOfChild(v));
                invalidate();
            }
        });
    }

    /**
     * 设置选择监听
     *
     * @param listener
     */
    @Override
    public void setOnSingleSelectListener(OnSingleSelectListener listener) {
        this.selectHelper.setOnSingleCheckListener(listener);
    }
    @Override
    public void setOnMultiSelectListener(OnMultiSelectListener listener){
        this.selectHelper.setOnMultiCheckListener(listener);
    }
    @Override
    public void setOnRectangleSelectListener(OnRectangleSelectListener listener){
        this.selectHelper.setOnRectangleCheckListener(listener);
    }

    @Override
    public int getSingleSelectedIndex() {
        return selectHelper.getSingleCheckedIndex();
    }

    @Override
    public List<Integer> getMultiSelectedIndex() {
        return selectHelper.getMultiSelectIndex();
    }

    @Override
    public int getRectangleStartIndex() {
        return selectHelper.getRectangleStartIndex();
    }

    @Override
    public int getRectangleEndIndex() {
        return selectHelper.getRectangleEndIndex();
    }
}
