package com.cz.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;

import com.cz.library.R;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by cz on 2017/3/24.
 */

public class FixedGridLayout extends CenterGridLayout {
    public static final int TYPE_START=0x00;
    public static final int TYPE_END=0x01;
    private final SparseArray<List<View>> typeItems;

    public FixedGridLayout(Context context) {
        this(context,null,0);
    }

    public FixedGridLayout(Context context, AttributeSet attrs) {
        this(context, attrs,0);
    }

    public FixedGridLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.typeItems=new SparseArray<>();
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        for(int i=0;i<getChildCount();){
            View childView = getChildAt(i);
            LayoutParams layoutParams= (LayoutParams) childView.getLayoutParams();
            if(TYPE_START==layoutParams.itemType){
                List<View> viewItems = getViewItems(TYPE_START);
                super.removeView(childView);
                viewItems.add(childView);
            } else if(TYPE_END==layoutParams.itemType){
                List<View> viewItems = getViewItems(TYPE_END);
                super.removeView(childView);
                viewItems.add(childView);
            } else {
                i++;
            }
        }
        List<View> viewItems = getViewItems(TYPE_START);
        //倒序添加所有顶部
        for(int i=viewItems.size()-1;i>=0;i--){
            super.addView(viewItems.get(i),0,generateDefaultLayoutParams());
        }
        viewItems = getViewItems(TYPE_END);
        for(View childView:viewItems){
            super.addView(childView,getChildCount(),generateDefaultLayoutParams());
        }
    }

    private List<View> getViewItems(int type){
        List<View> views = typeItems.get(type);
        if(null==views){
            typeItems.put(type,views=new ArrayList<>());
        }
        return views;
    }

    private int getViewItemSize(int type){
        List<View> views = typeItems.get(type);
        return (null==views)?0:views.size();
    }

    public void removeStartView(int index){
        removeStartView(getTypeViewByIndex(TYPE_START,index));
    }

    private View getTypeViewByIndex(int type, int index) {
        List<View> viewItems = getViewItems(type);
        View view=null;
        if(0<=index&&index<viewItems.size()){
            view=viewItems.get(index);
        }
        return view;
    }

    public void removeStartView(View view){
        if(isTypeView(view)){
            super.removeView(view);
            List<View> viewItems = getViewItems(TYPE_START);
            viewItems.remove(view);
        }
    }

    public void removeEndView(int index){
        removeEndView(getTypeViewByIndex(TYPE_END,index));
    }

    public void removeEndView(View view){
        if(isTypeView(view)){
            super.removeView(view);
            List<View> viewItems = getViewItems(TYPE_END);
            viewItems.remove(view);
        }
    }

    private boolean isTypeView(View view){
        boolean result=false;
        for(int i=0;i<typeItems.size();i++){
            int key = typeItems.keyAt(i);
            List<View> views = typeItems.get(key);
            if(null!=view){
                if(views.contains(view)){
                    result=true;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        int childCount = getChildCount();
        int startCount = getViewItemSize(TYPE_START);
        int endCount = getViewItemSize(TYPE_END);
        boolean addLast=-1==index;
        if(0!=startCount&&!addLast&&index<=startCount){
            index+=startCount;
        } else if(0!=endCount){
            if(addLast){
                index=childCount-endCount;
            } else if(index>=childCount-endCount){
                index-=endCount;
            }
        }
        super.addView(child, index, params);
    }


    @Override
    public void removeViewAt(int index) {
        int childCount = getChildCount();
        int startCount = getViewItemSize(TYPE_START);
        int endCount = getViewItemSize(TYPE_END);
        if(0!=startCount&&index<=startCount){
            index+=startCount;
        } else if(0!=endCount&&index>=childCount-endCount){
            index-=endCount;
        }
        super.removeViewAt(index);
    }

    @Override
    public void removeView(View view) {
        if(!isTypeView(view)){
            super.removeView(view);
        }
    }

    @Override
    public void removeViews(int start, int count) {
        for(int i=start;i<start+count;i++){
            View childView = getChildAt(i);
            if(!isTypeView(childView)){
                super.removeView(childView);
            }
        }
    }

    @Override
    public void removeAllViews() {
        removeViews(0,getChildCount());
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return super.generateLayoutParams(p);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(getContext(),attrs);
    }

    public static class LayoutParams extends ViewGroup.LayoutParams{
        public int itemType;
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FixedGridLayout);
            setItemType(a.getInt(R.styleable.FixedGridLayout_layout_itemType,TYPE_START));
            a.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        private void setItemType(int itemType) {
            this.itemType=itemType;
        }
    }
}
